/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.impl.primitive;

import org.sfm.csv.impl.DelayedCellSetter;
import org.sfm.csv.impl.ParsingContext;
import org.sfm.csv.impl.cellreader.ShortCellValueReader;
import org.sfm.reflect.primitive.ShortSetter;

public class ShortDelayedCellSetter<T>
implements DelayedCellSetter<T, Short> {
    private final ShortSetter<T> setter;
    private final ShortCellValueReader reader;
    private short value;
    private boolean isNull;

    public ShortDelayedCellSetter(ShortSetter<T> setter, ShortCellValueReader reader) {
        this.setter = setter;
        this.reader = reader;
    }

    public Short consumeValue() {
        return this.isNull ? null : Short.valueOf(this.getShort());
    }

    public Short peekValue() {
        return this.isNull ? null : Short.valueOf(this.value);
    }

    public short getShort() {
        short v = this.value;
        this.value = 0;
        this.isNull = true;
        return v;
    }

    public void set(T t) throws Exception {
        this.setter.setShort(t, this.consumeValue());
    }

    public boolean isSettable() {
        return this.setter != null;
    }

    public void set(char[] chars, int offset, int length, ParsingContext parsingContext) throws Exception {
        this.isNull = length == 0;
        this.value = this.reader.readShort(chars, offset, length, parsingContext);
    }

    public String toString() {
        return "ShortDelayedCellSetter{setter=" + this.setter + ", reader=" + this.reader + '}';
    }
}

