/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.impl.primitive;

import org.sfm.csv.impl.DelayedCellSetter;
import org.sfm.csv.impl.ParsingContext;
import org.sfm.csv.impl.cellreader.ByteCellValueReader;
import org.sfm.reflect.primitive.ByteSetter;

public class ByteDelayedCellSetter<T>
implements DelayedCellSetter<T, Byte> {
    private final ByteSetter<T> setter;
    private final ByteCellValueReader reader;
    private byte value;
    private boolean isNull;

    public ByteDelayedCellSetter(ByteSetter<T> setter, ByteCellValueReader reader) {
        this.setter = setter;
        this.reader = reader;
    }

    public Byte consumeValue() {
        return this.isNull ? null : Byte.valueOf(this.consumeByte());
    }

    public Byte peekValue() {
        return this.isNull ? null : Byte.valueOf(this.value);
    }

    public byte consumeByte() {
        byte v = this.value;
        this.value = 0;
        this.isNull = true;
        return v;
    }

    public void set(T t) throws Exception {
        this.setter.setByte(t, this.consumeByte());
    }

    public boolean isSettable() {
        return this.setter != null;
    }

    public void set(char[] chars, int offset, int length, ParsingContext parsingContext) throws Exception {
        this.isNull = length == 0;
        this.value = this.reader.readByte(chars, offset, length, parsingContext);
    }

    public String toString() {
        return "ByteDelayedCellSetter{setter=" + this.setter + ", reader=" + this.reader + '}';
    }
}

