/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv.impl.cellreader;

import org.sfm.csv.CellValueReader;
import org.sfm.csv.impl.DelayedCellSetter;
import org.sfm.csv.impl.ParsingContext;
import org.sfm.reflect.Setter;

public class DelayedCellSetterImpl<T, P>
implements DelayedCellSetter<T, P> {
    private P value;
    private final CellValueReader<? extends P> reader;
    private final Setter<T, ? super P> setter;

    public DelayedCellSetterImpl(Setter<T, ? super P> setter, CellValueReader<? extends P> reader) {
        this.setter = setter;
        this.reader = reader;
    }

    public P consumeValue() {
        P val = this.value;
        this.value = null;
        return val;
    }

    public P peekValue() {
        return this.value;
    }

    public void set(T t) throws Exception {
        P val = this.value;
        this.value = null;
        this.setter.set(t, val);
    }

    public boolean isSettable() {
        return this.setter != null;
    }

    public void set(char[] chars, int offset, int length, ParsingContext parsingContext) throws Exception {
        this.value = this.reader.read(chars, offset, length, parsingContext);
    }

    public String toString() {
        return "DelayedCellSetterImpl{reader=" + this.reader + ", setter=" + this.setter + '}';
    }
}

