/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.csv;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.sfm.csv.CsvColumnDefinition;
import org.sfm.csv.CsvColumnKey;
import org.sfm.csv.CsvMapper;
import org.sfm.csv.CsvMapperBuilder;
import org.sfm.csv.CsvReader;
import org.sfm.csv.impl.CsvColumnDefinitionProviderImpl;
import org.sfm.csv.impl.DynamicCsvMapper;
import org.sfm.csv.parser.CellConsumer;
import org.sfm.csv.parser.CharBuffer;
import org.sfm.csv.parser.ConfigurableCsvCharConsumer;
import org.sfm.csv.parser.CsvCharConsumer;
import org.sfm.csv.parser.StandardCsvCharConsumer;
import org.sfm.map.ColumnDefinitionProvider;
import org.sfm.map.impl.CaseInsensitiveFieldKeyNamePredicate;
import org.sfm.reflect.ReflectionService;
import org.sfm.reflect.TypeReference;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.tuples.Tuple2;
import org.sfm.tuples.Tuple3;
import org.sfm.tuples.Tuple4;
import org.sfm.tuples.Tuple5;
import org.sfm.tuples.Tuple6;
import org.sfm.tuples.Tuple7;
import org.sfm.tuples.Tuple8;
import org.sfm.tuples.Tuples;
import org.sfm.utils.Predicate;
import org.sfm.utils.RowHandler;

public final class CsvParser {
    public static DSL separator(char c) {
        return CsvParser.schema().separator(c);
    }

    public static DSL bufferSize(int size) {
        return CsvParser.schema().bufferSize(size);
    }

    public static DSL quote(char c) {
        return CsvParser.schema().quote(c);
    }

    public static DSL skip(int skip) {
        return CsvParser.schema().skip(skip);
    }

    private static DSL schema() {
        return new DSL();
    }

    public static DSL limit(int limit) {
        return CsvParser.schema().limit(limit);
    }

    public static <T> MapToDSL<T> mapTo(Type type) {
        return CsvParser.schema().mapTo(type);
    }

    public static <T> MapToDSL<T> mapTo(Class<T> type) {
        return CsvParser.schema().mapTo(type);
    }

    public static <T> MapToDSL<T> mapTo(TypeReference<T> type) {
        return CsvParser.schema().mapTo(type);
    }

    public static <T1, T2> MapToDSL<Tuple2<T1, T2>> mapTo(Class<T1> class1, Class<T2> class2) {
        return CsvParser.schema().mapTo(class1, class2);
    }

    public static <T1, T2, T3> MapToDSL<Tuple3<T1, T2, T3>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3) {
        return CsvParser.schema().mapTo(class1, class2, class3);
    }

    public static <T1, T2, T3, T4> MapToDSL<Tuple4<T1, T2, T3, T4>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4) {
        return CsvParser.schema().mapTo(class1, class2, class3, class4);
    }

    public static <T1, T2, T3, T4, T5> MapToDSL<Tuple5<T1, T2, T3, T4, T5>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5) {
        return CsvParser.schema().mapTo(class1, class2, class3, class4, class5);
    }

    public static <T1, T2, T3, T4, T5, T6> MapToDSL<Tuple6<T1, T2, T3, T4, T5, T6>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5, Class<T6> class6) {
        return CsvParser.schema().mapTo(class1, class2, class3, class4, class5, class6);
    }

    public static <T1, T2, T3, T4, T5, T6, T7> MapToDSL<Tuple7<T1, T2, T3, T4, T5, T6, T7>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5, Class<T6> class6, Class<T7> class7) {
        return CsvParser.schema().mapTo(class1, class2, class3, class4, class5, class6, class7);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> MapToDSL<Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5, Class<T6> class6, Class<T7> class7, Class<T8> class8) {
        return CsvParser.schema().mapTo(class1, class2, class3, class4, class5, class6, class7, class8);
    }

    public static <T> MapWithDSL<T> mapWith(CsvMapper<T> mapper) {
        return CsvParser.schema().mapWith(mapper);
    }

    public static CsvReader reader(Reader reader) throws IOException {
        return CsvParser.schema().reader(reader);
    }

    public static Iterator<String[]> iterator(Reader reader) throws IOException {
        return CsvParser.schema().iterator(reader);
    }

    public static <CC extends CellConsumer> CC parse(Reader reader, CC cellConsumer) throws IOException {
        return CsvParser.schema().parse(reader, cellConsumer);
    }

    public static Stream<String[]> stream(Reader r) throws IOException {
        return CsvParser.schema().stream(r);
    }

    public static class MapWithDSL<T> {
        private final DSL dsl;
        private final CsvMapper<T> mapper;

        public MapWithDSL(DSL dsl, CsvMapper<T> mapper) {
            this.dsl = dsl;
            this.mapper = mapper;
        }

        protected final DSL getDsl() {
            return this.dsl;
        }

        protected final CsvMapper<T> getMapper() {
            return this.mapper;
        }

        public final Iterator<T> iterator(Reader reader) throws IOException {
            return this.mapper.iterator(this.dsl.reader(reader));
        }

        public final <H extends RowHandler<T>> H forEach(Reader reader, H rowHandler) throws IOException {
            if (this.dsl.limit == -1) {
                this.mapper.forEach(this.dsl.reader(reader), rowHandler);
            } else {
                this.mapper.forEach(this.dsl.reader(reader), rowHandler, this.dsl.limit);
            }
            return rowHandler;
        }

        public final Stream<T> stream(Reader reader) throws IOException {
            return this.mapper.stream(this.dsl.reader(reader));
        }
    }

    public static final class StaticMapToDSL<T>
    extends MapWithDSL<T> {
        private final ClassMeta<T> classMeta;
        private final Type mapToClass;
        private final CsvColumnDefinitionProviderImpl columnDefinitionProvider;
        private final List<Tuple2<String, CsvColumnDefinition>> columns;

        private StaticMapToDSL(DSL dsl, ClassMeta<T> classMeta, Type mapToClass, List<Tuple2<String, CsvColumnDefinition>> columns, CsvColumnDefinitionProviderImpl columnDefinitionProvider) {
            super(dsl, StaticMapToDSL.newStaticMapper(mapToClass, classMeta, columns, columnDefinitionProvider));
            this.classMeta = classMeta;
            this.mapToClass = mapToClass;
            this.columns = columns;
            this.columnDefinitionProvider = columnDefinitionProvider;
        }

        private static <T> CsvMapper<T> newStaticMapper(Type mapToClass, ClassMeta<T> classMeta, List<Tuple2<String, CsvColumnDefinition>> columns, CsvColumnDefinitionProviderImpl columnDefinitionProvider) {
            CsvMapperBuilder<T> builder = new CsvMapperBuilder<T>(mapToClass, classMeta, (ColumnDefinitionProvider<CsvColumnDefinition, CsvColumnKey>)columnDefinitionProvider);
            for (Tuple2<String, CsvColumnDefinition> col : columns) {
                builder.addMapping(col.first(), col.second());
            }
            return builder.mapper();
        }

        public StaticMapToDSL<T> addMapping(String column) {
            return this.addMapping(column, CsvColumnDefinition.identity());
        }

        public StaticMapToDSL<T> addMapping(String column, CsvColumnDefinition columnDefinition) {
            ArrayList<Tuple2<String, CsvColumnDefinition>> newColumns = new ArrayList<Tuple2<String, CsvColumnDefinition>>(this.columns);
            newColumns.add(new Tuple2<String, CsvColumnDefinition>(column, columnDefinition));
            return new StaticMapToDSL<T>(this.getDsl(), this.classMeta, this.mapToClass, newColumns, this.columnDefinitionProvider);
        }

        public StaticMapToDSL<T> addKey(String key) {
            return this.addMapping(key, CsvColumnDefinition.key());
        }
    }

    public static final class MapToDSL<T>
    extends MapWithDSL<T> {
        private final ClassMeta<T> classMeta;
        private final Type mapToClass;
        private final CsvColumnDefinitionProviderImpl columnDefinitionProvider;

        public MapToDSL(DSL dsl, Type mapToClass) {
            this(dsl, ReflectionService.newInstance().getClassMeta(mapToClass), mapToClass, new CsvColumnDefinitionProviderImpl());
        }

        private MapToDSL(DSL dsl, ClassMeta<T> classMeta, Type mapToClass, CsvColumnDefinitionProviderImpl columnDefinitionProvider) {
            super(dsl, new DynamicCsvMapper(mapToClass, classMeta, (ColumnDefinitionProvider)columnDefinitionProvider));
            this.mapToClass = mapToClass;
            this.classMeta = classMeta;
            this.columnDefinitionProvider = columnDefinitionProvider;
        }

        public StaticMapToDSL<T> headers(String ... headers) {
            return new StaticMapToDSL(this.getDsl(), this.classMeta, this.mapToClass, this.getColumnDefinitions(headers), this.columnDefinitionProvider);
        }

        public StaticMapToDSL<T> defaultHeaders() {
            return this.headers(this.classMeta.generateHeaders());
        }

        public StaticMapToDSL<T> overrideHeaders(String ... headers) {
            List<Tuple2<String, CsvColumnDefinition>> columns = this.getColumnDefinitions(headers);
            return new StaticMapToDSL(this.getDsl().skip(1), this.classMeta, this.mapToClass, columns, this.columnDefinitionProvider);
        }

        private List<Tuple2<String, CsvColumnDefinition>> getColumnDefinitions(String[] headers) {
            ArrayList<Tuple2<String, CsvColumnDefinition>> columns = new ArrayList<Tuple2<String, CsvColumnDefinition>>();
            for (String header : headers) {
                columns.add(new Tuple2<String, CsvColumnDefinition>(header, CsvColumnDefinition.identity()));
            }
            return columns;
        }

        public MapToDSL<T> columnDefinition(String column, CsvColumnDefinition columnDefinition) {
            return this.columnDefinition((Predicate<CsvColumnKey>)new CaseInsensitiveFieldKeyNamePredicate(column), columnDefinition);
        }

        public MapToDSL<T> columnDefinition(Predicate<? super CsvColumnKey> predicate, CsvColumnDefinition columnDefinition) {
            return new MapToDSL<T>(this.getDsl(), this.classMeta, this.mapToClass, this.newColumnDefinitionProvider(predicate, columnDefinition));
        }

        public MapWithDSL<T> addKeys(String ... keys) {
            List definitions = this.columnDefinitionProvider.getDefinitions();
            for (String key : keys) {
                definitions.add(new Tuple2<CaseInsensitiveFieldKeyNamePredicate, CsvColumnDefinition>(new CaseInsensitiveFieldKeyNamePredicate(key), CsvColumnDefinition.key()));
            }
            return new MapToDSL<T>(this.getDsl(), this.classMeta, this.mapToClass, new CsvColumnDefinitionProviderImpl(definitions));
        }

        private CsvColumnDefinitionProviderImpl newColumnDefinitionProvider(Predicate<? super CsvColumnKey> predicate, CsvColumnDefinition columnDefinition) {
            List definitions = this.columnDefinitionProvider.getDefinitions();
            definitions.add(new Tuple2<Predicate<? super CsvColumnKey>, CsvColumnDefinition>(predicate, columnDefinition));
            return new CsvColumnDefinitionProviderImpl(definitions);
        }

        public StaticMapToDSL<T> overrideWithDefaultHeaders() {
            return this.overrideHeaders(this.classMeta.generateHeaders());
        }

        public StaticMapToDSL<T> addMapping(String column) {
            return this.staticMapper().addMapping(column);
        }

        public StaticMapToDSL<T> addKey(String key) {
            return this.staticMapper().addKey(key);
        }

        public StaticMapToDSL<T> addMapping(String column, CsvColumnDefinition columnDefinition) {
            return this.staticMapper().addMapping(column, columnDefinition);
        }

        private StaticMapToDSL<T> staticMapper() {
            return new StaticMapToDSL(this.getDsl().skip(1), this.classMeta, this.mapToClass, Collections.emptyList(), this.columnDefinitionProvider);
        }
    }

    public static final class DSL {
        private final char separatorChar;
        private final char quoteChar;
        private final int bufferSize;
        private final int skip;
        private final int limit;

        private DSL() {
            this.separatorChar = (char)44;
            this.quoteChar = (char)34;
            this.bufferSize = 8192;
            this.skip = 0;
            this.limit = -1;
        }

        public DSL(char separatorChar, char quoteChar, int bufferSize, int skip, int limit) {
            this.separatorChar = separatorChar;
            this.quoteChar = quoteChar;
            this.bufferSize = bufferSize;
            this.skip = skip;
            this.limit = limit;
        }

        public DSL separator(char c) {
            return new DSL(c, this.quoteChar, this.bufferSize, this.skip, this.limit);
        }

        public DSL quote(char c) {
            return new DSL(this.separatorChar, c, this.bufferSize, this.skip, this.limit);
        }

        public DSL bufferSize(int size) {
            return new DSL(this.separatorChar, this.quoteChar, size, this.skip, this.limit);
        }

        public DSL skip(int skip) {
            return new DSL(this.separatorChar, this.quoteChar, this.bufferSize, skip, this.limit);
        }

        public DSL limit(int limit) {
            return new DSL(this.separatorChar, this.quoteChar, this.bufferSize, this.skip, limit);
        }

        public <CC extends CellConsumer> CC parse(Reader reader, CC cellConsumer) throws IOException {
            CsvReader csvreader = this.reader(reader);
            if (this.limit == -1) {
                return csvreader.parseAll(cellConsumer);
            }
            return csvreader.parseRows(cellConsumer, this.limit);
        }

        public CsvReader reader(Reader reader) throws IOException {
            CsvReader csvReader = new CsvReader(reader, this.charConsumer());
            csvReader.skipRows(this.skip);
            return csvReader;
        }

        public Iterator<String[]> iterator(Reader reader) throws IOException {
            return this.reader(reader).iterator();
        }

        public <T> MapToDSL<T> mapTo(Type target) {
            return new MapToDSL(this, target);
        }

        public <T> MapToDSL<T> mapTo(Class<T> target) {
            return this.mapTo((Type)target);
        }

        public <T> MapToDSL<T> mapTo(TypeReference<T> target) {
            return this.mapTo(target.getType());
        }

        public <T1, T2> MapToDSL<Tuple2<T1, T2>> mapTo(Class<T1> class1, Class<T2> class2) {
            return new MapToDSL<Tuple2<T1, T2>>(this, Tuples.typeDef(class1, class2));
        }

        public <T1, T2, T3> MapToDSL<Tuple3<T1, T2, T3>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3) {
            return new MapToDSL<Tuple3<T1, T2, T3>>(this, Tuples.typeDef(class1, class2, class3));
        }

        public <T1, T2, T3, T4> MapToDSL<Tuple4<T1, T2, T3, T4>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4) {
            return new MapToDSL<Tuple4<T1, T2, T3, T4>>(this, Tuples.typeDef(class1, class2, class3, class4));
        }

        public <T1, T2, T3, T4, T5> MapToDSL<Tuple5<T1, T2, T3, T4, T5>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5) {
            return new MapToDSL<Tuple5<T1, T2, T3, T4, T5>>(this, Tuples.typeDef(class1, class2, class3, class4, class5));
        }

        public <T1, T2, T3, T4, T5, T6> MapToDSL<Tuple6<T1, T2, T3, T4, T5, T6>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5, Class<T6> class6) {
            return new MapToDSL<Tuple6<T1, T2, T3, T4, T5, T6>>(this, Tuples.typeDef(class1, class2, class3, class4, class5, class6));
        }

        public <T1, T2, T3, T4, T5, T6, T7> MapToDSL<Tuple7<T1, T2, T3, T4, T5, T6, T7>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5, Class<T6> class6, Class<T7> class7) {
            return new MapToDSL<Tuple7<T1, T2, T3, T4, T5, T6, T7>>(this, Tuples.typeDef(class1, class2, class3, class4, class5, class6, class7));
        }

        public <T1, T2, T3, T4, T5, T6, T7, T8> MapToDSL<Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5, Class<T6> class6, Class<T7> class7, Class<T8> class8) {
            return new MapToDSL<Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>>(this, Tuples.typeDef(class1, class2, class3, class4, class5, class6, class7, class8));
        }

        public <T> MapWithDSL<T> mapWith(CsvMapper<T> mapper) {
            return new MapWithDSL<T>(this, mapper);
        }

        public Stream<String[]> stream(Reader reader) throws IOException {
            return this.reader(reader).stream();
        }

        private CsvCharConsumer charConsumer() {
            CharBuffer charBuffer = new CharBuffer(this.bufferSize);
            if (this.separatorChar == ',' && this.quoteChar == '\"') {
                return new StandardCsvCharConsumer(charBuffer);
            }
            return new ConfigurableCsvCharConsumer(charBuffer, this.separatorChar, this.quoteChar);
        }

        public int bufferSize() {
            return this.bufferSize;
        }

        public int limit() {
            return this.limit;
        }

        public int skip() {
            return this.skip;
        }

        public char separator() {
            return this.separatorChar;
        }

        public char quote() {
            return this.quoteChar;
        }
    }
}

