/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import java.util.Iterator;
import java.util.stream.Stream;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.MappingException;
import org.simpleflatmapper.map.SetRowMapper;
import org.simpleflatmapper.map.mapper.MapperCache;
import org.simpleflatmapper.map.mapper.MapperKey;
import org.simpleflatmapper.map.mapper.MapperKeyComparator;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.Enumerable;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.UnaryFactory;
import org.simpleflatmapper.util.UnaryFactoryWithException;

public class DynamicSetRowMapper<ROW, SET, T, E extends Exception, K extends FieldKey<K>>
implements SetRowMapper<ROW, SET, T, E> {
    private final MapperCache<K, SetRowMapper<ROW, SET, T, E>> mapperCache;
    private final UnaryFactory<MapperKey<K>, SetRowMapper<ROW, SET, T, E>> mapperFactory;
    private final UnaryFactoryWithException<ROW, MapperKey<K>, E> mapperKeyFromRow;
    private final UnaryFactoryWithException<SET, MapperKey<K>, E> mapperKeyFromSet;

    public DynamicSetRowMapper(UnaryFactory<MapperKey<K>, SetRowMapper<ROW, SET, T, E>> mapperFactory, UnaryFactoryWithException<ROW, MapperKey<K>, E> mapperKeyFromRow, UnaryFactoryWithException<SET, MapperKey<K>, E> mapperKeyFromSet, MapperKeyComparator<K> keyComparator) {
        this.mapperFactory = mapperFactory;
        this.mapperKeyFromRow = mapperKeyFromRow;
        this.mapperKeyFromSet = mapperKeyFromSet;
        this.mapperCache = new MapperCache(keyComparator);
    }

    @Override
    public final T map(ROW row) throws MappingException {
        try {
            return this.getMapperFromRow(row).map(row);
        }
        catch (Exception e) {
            ErrorHelper.rethrow((Throwable)e);
            return null;
        }
    }

    @Override
    public final T map(ROW row, MappingContext<? super ROW> context) throws MappingException {
        try {
            return this.getMapperFromRow(row).map(row, context);
        }
        catch (Exception e) {
            ErrorHelper.rethrow((Throwable)e);
            return null;
        }
    }

    @Override
    public final Iterator<T> iterator(SET rs) throws E, MappingException {
        return this.getMapperFromSet(rs).iterator(rs);
    }

    @Override
    public final Stream<T> stream(SET set) throws E, MappingException {
        return this.getMapperFromSet(set).stream(set);
    }

    @Override
    public Enumerable<T> enumerate(SET source) throws E, MappingException {
        return this.getMapperFromSet(source).enumerate(source);
    }

    @Override
    public final <H extends CheckedConsumer<? super T>> H forEach(SET set, H handler) throws E, MappingException {
        return this.getMapperFromSet(set).forEach(set, handler);
    }

    public String toString() {
        return "DynamicMapper{mapperFactory=" + String.valueOf(this.mapperFactory) + ", " + String.valueOf(this.mapperCache) + "}";
    }

    private SetRowMapper<ROW, SET, T, E> getMapperFromSet(SET set) throws E {
        return this.getMapper((MapperKey)this.mapperKeyFromSet.newInstance(set));
    }

    private SetRowMapper<ROW, SET, T, E> getMapperFromRow(ROW row) throws E {
        return this.getMapper((MapperKey)this.mapperKeyFromRow.newInstance(row));
    }

    public SetRowMapper<ROW, SET, T, E> getMapper(MapperKey<K> key) throws E {
        SetRowMapper mapper = this.mapperCache.get(key);
        if (mapper == null) {
            mapper = (SetRowMapper)this.mapperFactory.newInstance(key);
            this.mapperCache.add(key, mapper);
        }
        return mapper;
    }
}

