/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.MappingException;
import org.simpleflatmapper.map.SourceFieldMapper;
import org.simpleflatmapper.util.Enumerable;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.Function;
import org.simpleflatmapper.util.Predicate;

public class DiscriminatorEnumerable<S, T>
implements Enumerable<T> {
    private final PredicatedMapperWithContext<S, T>[] discriminatorMappers;
    private final Enumerable<S> sourceEnumerable;
    private final Function<? super S, ? extends CharSequence> errorMessageGenerator;
    private T currentValue;
    private T nextValue;
    private SourceFieldMapper<S, T> currentMapper;
    private MappingContext<? super S> currentMappingContext;
    private boolean exhausted = false;

    public DiscriminatorEnumerable(PredicatedMapperWithContext<S, T>[] discriminatorMappers, Enumerable<S> sourceEnumerable, Function<? super S, ? extends CharSequence> errorMessageGenerator) {
        this.discriminatorMappers = discriminatorMappers;
        this.sourceEnumerable = sourceEnumerable;
        this.errorMessageGenerator = errorMessageGenerator;
    }

    public boolean next() {
        if (this.exhausted) {
            return false;
        }
        try {
            this.currentValue = this.nextValue;
            this.nextValue = null;
            while (this.sourceEnumerable.next()) {
                this.checkMapper();
                Object source = this.sourceEnumerable.currentValue();
                if (this.currentMappingContext.broke(source)) {
                    if (this.currentValue == null) {
                        this.currentValue = this.currentMapper.map((S)source, this.currentMappingContext);
                        continue;
                    }
                    this.nextValue = this.currentMapper.map((S)source, this.currentMappingContext);
                    return true;
                }
                this.currentMapper.mapTo((S)source, this.currentValue, this.currentMappingContext);
            }
            this.exhausted = true;
            return this.currentValue != null;
        }
        catch (Exception e) {
            ErrorHelper.rethrow((Throwable)e);
            return false;
        }
    }

    public T currentValue() {
        return this.currentValue;
    }

    private void checkMapper() {
        for (PredicatedMapperWithContext<S, T> pmm : this.discriminatorMappers) {
            if (!((PredicatedMapperWithContext)pmm).predicate.test(this.sourceEnumerable.currentValue())) continue;
            if (((PredicatedMapperWithContext)pmm).mapper != this.currentMapper) {
                this.markAsBroken();
                this.currentMapper = ((PredicatedMapperWithContext)pmm).mapper;
                this.currentMappingContext = ((PredicatedMapperWithContext)pmm).mappingContext;
            }
            return;
        }
        this.mapperNotFound();
    }

    private void mapperNotFound() {
        CharSequence errorMessage = (CharSequence)this.errorMessageGenerator.apply(this.sourceEnumerable.currentValue());
        throw new MappingException("No mapper found for " + String.valueOf(errorMessage));
    }

    private void markAsBroken() {
        for (PredicatedMapperWithContext<S, T> pmm : this.discriminatorMappers) {
            ((PredicatedMapperWithContext)pmm).mappingContext.markAsBroken();
        }
    }

    public static class PredicatedMapperWithContext<ROW, T> {
        private final Predicate<ROW> predicate;
        private final SourceFieldMapper<ROW, T> mapper;
        private final MappingContext<? super ROW> mappingContext;

        public PredicatedMapperWithContext(Predicate<ROW> predicate, SourceFieldMapper<ROW, T> mapper, MappingContext<? super ROW> mappingContext) {
            this.predicate = predicate;
            this.mapper = mapper;
            this.mappingContext = mappingContext;
        }
    }
}

