/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.asm;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.simpleflatmapper.converter.Context;
import org.simpleflatmapper.map.FieldMapper;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.fieldmapper.BooleanConstantSourceFieldMapper;
import org.simpleflatmapper.map.fieldmapper.ByteConstantSourceFieldMapper;
import org.simpleflatmapper.map.fieldmapper.CharacterConstantSourceFieldMapper;
import org.simpleflatmapper.map.fieldmapper.ConstantSourceFieldMapper;
import org.simpleflatmapper.map.fieldmapper.DoubleConstantSourceFieldMapper;
import org.simpleflatmapper.map.fieldmapper.FloatConstantSourceFieldMapper;
import org.simpleflatmapper.map.fieldmapper.IntConstantSourceFieldMapper;
import org.simpleflatmapper.map.fieldmapper.LongConstantSourceFieldMapper;
import org.simpleflatmapper.map.fieldmapper.ShortConstantSourceFieldMapper;
import org.simpleflatmapper.map.getter.OptimizableIndexedContextualGetter;
import org.simpleflatmapper.map.mapper.AbstractMapper;
import org.simpleflatmapper.ow2asm.ClassWriter;
import org.simpleflatmapper.ow2asm.FieldVisitor;
import org.simpleflatmapper.ow2asm.MethodVisitor;
import org.simpleflatmapper.reflect.BiInstantiator;
import org.simpleflatmapper.reflect.asm.AsmUtils;
import org.simpleflatmapper.util.TypeHelper;

public class MapperAsmBuilder {
    private static final String ABSTRACT_MAPPER_TYPE = AsmUtils.toAsmType(AbstractMapper.class);
    private static final String FIELD_MAPPER_TYPE = AsmUtils.toAsmType(FieldMapper.class);
    private static final String INSTANTIATOR_TYPE = AsmUtils.toAsmType(BiInstantiator.class);
    private static final String mappingContextType = AsmUtils.toAsmType(MappingContext.class);
    public static final String FIELD_MAPPER_PREFIX = "fieldMapper";
    public static final String CONSTRUCTOR_MAPPER_PREFIX = "constructorMapper";

    public static <S, T> byte[] dump(String className, FieldMapper<? super S, ? super T>[] _mappers, FieldMapper<? super S, ? super T>[] _constructorMappers, Class<? super S> sourceClass, Class<T> target) throws Exception {
        String mapper;
        String mapperName;
        int i;
        ClassWriter cw = new ClassWriter(1);
        String targetType = AsmUtils.toAsmType(target);
        String mapperClassType = AsmUtils.toAsmType((String)className);
        cw.visit(50, 49, mapperClassType, "L" + ABSTRACT_MAPPER_TYPE + "<" + AsmUtils.toTargetTypeDeclaration((String)targetType) + ">;", ABSTRACT_MAPPER_TYPE, null);
        MapperBuilder[] mappers = new MapperBuilder[_mappers.length];
        for (int i2 = 0; i2 < mappers.length; ++i2) {
            mappers[i2] = MapperAsmBuilder.newMapperBuilder(_mappers[i2], FIELD_MAPPER_PREFIX, i2);
        }
        MapperBuilder[] constructorMappers = new MapperBuilder[_constructorMappers.length];
        for (i = 0; i < _constructorMappers.length; ++i) {
            constructorMappers[i] = MapperAsmBuilder.newMapperBuilder(_constructorMappers[i], CONSTRUCTOR_MAPPER_PREFIX, i);
        }
        for (i = 0; i < mappers.length; ++i) {
            mappers[i].addDeclaration(cw);
        }
        for (i = 0; i < constructorMappers.length; ++i) {
            constructorMappers[i].addDeclaration(cw);
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", "([L" + FIELD_MAPPER_TYPE + ";[L" + FIELD_MAPPER_TYPE + ";L" + INSTANTIATOR_TYPE + ";)V", "([L" + FIELD_MAPPER_TYPE + "<" + AsmUtils.toTargetTypeDeclaration(sourceClass) + AsmUtils.toTargetTypeDeclaration((String)targetType) + ">;[L" + FIELD_MAPPER_TYPE + "<" + AsmUtils.toTargetTypeDeclaration(sourceClass) + AsmUtils.toTargetTypeDeclaration((String)targetType) + ">;L" + INSTANTIATOR_TYPE + "<" + AsmUtils.toTargetTypeDeclaration((String)targetType) + ">;)V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(183, ABSTRACT_MAPPER_TYPE, "<init>", "(L" + INSTANTIATOR_TYPE + ";)V", false);
        for (i = 0; i < mappers.length; ++i) {
            mappers[i].addInit(mv, mapperClassType);
        }
        for (i = 0; i < constructorMappers.length; ++i) {
            constructorMappers[i].addInit(mv, mapperClassType);
        }
        mv.visitInsn(177);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
        mv = cw.visitMethod(17, "mapFields", "(" + AsmUtils.toTargetTypeDeclaration(sourceClass) + AsmUtils.toTargetTypeDeclaration((String)targetType) + AsmUtils.toTargetTypeDeclaration((String)mappingContextType) + ")V", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        for (i = 0; i < mappers.length; ++i) {
            mappers[i].addMappingCall(mv, mapperClassType);
        }
        mv.visitInsn(177);
        mv.visitMaxs(3, 3);
        mv = cw.visitMethod(4161, "mapFields", "(Ljava/lang/Object;Ljava/lang/Object;" + AsmUtils.toTargetTypeDeclaration((String)mappingContextType) + ")V", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, AsmUtils.toAsmType(sourceClass));
        mv.visitVarInsn(25, 2);
        mv.visitTypeInsn(192, targetType);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(182, mapperClassType, "mapFields", "(" + AsmUtils.toTargetTypeDeclaration(sourceClass) + AsmUtils.toTargetTypeDeclaration((String)targetType) + AsmUtils.toTargetTypeDeclaration((String)mappingContextType) + ")V", false);
        mv.visitInsn(177);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
        mv = cw.visitMethod(20, "mapToFields", "(" + AsmUtils.toTargetTypeDeclaration(sourceClass) + AsmUtils.toTargetTypeDeclaration((String)targetType) + AsmUtils.toTargetTypeDeclaration((String)mappingContextType) + ")V", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        for (i = 0; i < constructorMappers.length; ++i) {
            constructorMappers[i].addMappingCall(mv, mapperClassType);
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(182, mapperClassType, "mapFields", "(" + AsmUtils.toTargetTypeDeclaration(sourceClass) + AsmUtils.toTargetTypeDeclaration((String)targetType) + AsmUtils.toTargetTypeDeclaration((String)mappingContextType) + ")V", false);
        mv.visitInsn(177);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
        mv = cw.visitMethod(4164, "mapToFields", "(Ljava/lang/Object;Ljava/lang/Object;" + AsmUtils.toTargetTypeDeclaration((String)mappingContextType) + ")V", null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, AsmUtils.toAsmType(sourceClass));
        mv.visitVarInsn(25, 2);
        mv.visitTypeInsn(192, targetType);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(182, mapperClassType, "mapToFields", "(" + AsmUtils.toTargetTypeDeclaration(sourceClass) + AsmUtils.toTargetTypeDeclaration((String)targetType) + AsmUtils.toTargetTypeDeclaration((String)mappingContextType) + ")V", false);
        mv.visitInsn(177);
        mv.visitMaxs(3, 3);
        mv.visitEnd();
        mv = cw.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V", false);
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;", false);
        mv.visitMethodInsn(182, "java/lang/Class", "getSimpleName", "()Ljava/lang/String;", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitLdcInsn((Object)"{");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitInsn(87);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, ABSTRACT_MAPPER_TYPE, "appendToStringBuilder", "(Ljava/lang/StringBuilder;)V", false);
        mv.visitVarInsn(25, 1);
        for (i = 0; i < mappers.length; ++i) {
            mapperName = ", fieldMapper" + i + "=";
            mapper = String.valueOf(mappers[i]);
            mv.visitLdcInsn((Object)mapperName);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
            mv.visitLdcInsn((Object)mapper);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        }
        for (i = 0; i < constructorMappers.length; ++i) {
            mapperName = ", constructorMapper" + i + "=";
            mapper = String.valueOf(constructorMappers[i]);
            mv.visitLdcInsn((Object)mapperName);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
            mv.visitLdcInsn((Object)mapper);
            mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        }
        mv.visitLdcInsn((Object)"}");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;", false);
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;", false);
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        cw.visitEnd();
        return AsmUtils.writeClassToFile((String)className, (byte[])cw.toByteArray());
    }

    private static <S, T> MapperBuilder newMapperBuilder(FieldMapper<? super S, ? super T> mapper, String fieldMapperPrefix, int i) throws NoSuchMethodException, NoSuchFieldException, IllegalAccessException {
        if (mapper == null) {
            return EmptyMapperBuilder.INSTANCE;
        }
        if (mapper instanceof ConstantSourceFieldMapper) {
            return MapperAsmBuilder.newConstantSourceFieldMapperBuilder(mapper, i, fieldMapperPrefix, "");
        }
        if (mapper instanceof BooleanConstantSourceFieldMapper) {
            return MapperAsmBuilder.newConstantSourceFieldMapperBuilder(mapper, i, fieldMapperPrefix, "Boolean");
        }
        if (mapper instanceof ByteConstantSourceFieldMapper) {
            return MapperAsmBuilder.newConstantSourceFieldMapperBuilder(mapper, i, fieldMapperPrefix, "Byte");
        }
        if (mapper instanceof CharacterConstantSourceFieldMapper) {
            return MapperAsmBuilder.newConstantSourceFieldMapperBuilder(mapper, i, fieldMapperPrefix, "Character");
        }
        if (mapper instanceof ShortConstantSourceFieldMapper) {
            return MapperAsmBuilder.newConstantSourceFieldMapperBuilder(mapper, i, fieldMapperPrefix, "Short");
        }
        if (mapper instanceof IntConstantSourceFieldMapper) {
            return MapperAsmBuilder.newConstantSourceFieldMapperBuilder(mapper, i, fieldMapperPrefix, "Int");
        }
        if (mapper instanceof LongConstantSourceFieldMapper) {
            return MapperAsmBuilder.newConstantSourceFieldMapperBuilder(mapper, i, fieldMapperPrefix, "Long");
        }
        if (mapper instanceof FloatConstantSourceFieldMapper) {
            return MapperAsmBuilder.newConstantSourceFieldMapperBuilder(mapper, i, fieldMapperPrefix, "Float");
        }
        if (mapper instanceof DoubleConstantSourceFieldMapper) {
            return MapperAsmBuilder.newConstantSourceFieldMapperBuilder(mapper, i, fieldMapperPrefix, "Double");
        }
        return new DefaultMapperBuilder(mapper, i, fieldMapperPrefix);
    }

    private static <S, T> MapperBuilder newConstantSourceFieldMapperBuilder(FieldMapper<? super S, ? super T> mapper, int i, String fieldMapperPrefix, String gsSuffix) throws NoSuchMethodException, NoSuchFieldException, IllegalAccessException {
        Class<?> setterClass;
        Field getterField = mapper.getClass().getField("getter");
        Field setterField = mapper.getClass().getField("setter");
        Object getter = getterField.get(mapper);
        Object setter = setterField.get(mapper);
        Class<?> getterClass = getter.getClass();
        if (!Modifier.isPublic(getterClass.getModifiers())) {
            getterClass = getterField.getType();
        }
        if (!Modifier.isPublic((setterClass = setter.getClass()).getModifiers())) {
            setterClass = setterField.getType();
        }
        Method getterMethod = getterClass.getMethod("get" + gsSuffix, Object.class, Context.class);
        Class<?> propClass = getterMethod.getReturnType();
        Method setterMethod = setterClass.getMethod("set" + gsSuffix, Object.class, propClass);
        if (getter instanceof OptimizableIndexedContextualGetter) {
            Field indexField = getter.getClass().getField("index");
            int getterIndex = indexField.getInt(getter);
            for (Method method : getter.getClass().getDeclaredMethods()) {
                if (!Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) || !method.getName().equals("get" + gsSuffix) || method.getParameterTypes().length != 3 || !Context.class.equals(method.getParameterTypes()[1]) || !Integer.TYPE.equals(method.getParameterTypes()[2])) continue;
                return new IndexableConstantSourceFieldMapperBuilder(mapper, getterIndex, i, fieldMapperPrefix, method, setterClass, setterClass.getMethod("set" + gsSuffix, Object.class, propClass), setterField.getType());
            }
            throw new IllegalArgumentException("Annotated method does not have a static methd matching get" + gsSuffix + "(?, Context.class, int.class) " + String.valueOf(getter));
        }
        return new ConstantSourceFieldMapperBuilder(mapper, i, fieldMapperPrefix, getterClass, getterMethod, setterClass, setterMethod, getterField.getType(), setterField.getType());
    }

    private static Method getMapToMethod(Class<?> aClass) {
        Method m = null;
        for (Method p : aClass.getDeclaredMethods()) {
            if (Modifier.isStatic(p.getModifiers()) || !p.getName().equals("mapTo") || p.getParameterTypes() == null || p.getParameterTypes().length != 3 || m != null && p.getModifiers() >= m.getModifiers()) continue;
            m = p;
        }
        return m;
    }

    private static interface MapperBuilder {
        public void addInit(MethodVisitor var1, String var2);

        public void addMappingCall(MethodVisitor var1, String var2) throws NoSuchMethodException;

        public void addDeclaration(ClassWriter var1);
    }

    private static final class EmptyMapperBuilder
    implements MapperBuilder {
        private static final EmptyMapperBuilder INSTANCE = new EmptyMapperBuilder();

        private EmptyMapperBuilder() {
        }

        @Override
        public void addInit(MethodVisitor mv, String mapperClassType) {
        }

        @Override
        public void addMappingCall(MethodVisitor mv, String mapperClassType) {
        }

        @Override
        public void addDeclaration(ClassWriter cw) {
        }
    }

    private static final class DefaultMapperBuilder<S, T>
    implements MapperBuilder {
        private final FieldMapper<? super S, ? super T> mapper;
        private final int index;
        private final String prefix;

        private DefaultMapperBuilder(FieldMapper<? super S, ? super T> mapper, int index, String prefix) {
            this.mapper = mapper;
            this.index = index;
            this.prefix = prefix;
        }

        @Override
        public void addInit(MethodVisitor mv, String mapperClassType) {
            Type mapperClass = AsmUtils.findClosestPublicTypeExposing(this.mapper.getClass(), FieldMapper.class);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, this.prefix == MapperAsmBuilder.CONSTRUCTOR_MAPPER_PREFIX ? 2 : 1);
            AsmUtils.addIndex((MethodVisitor)mv, (int)this.index);
            mv.visitInsn(50);
            mv.visitTypeInsn(192, AsmUtils.toAsmType((Type)mapperClass));
            mv.visitFieldInsn(181, mapperClassType, this.prefix + this.index, AsmUtils.toTargetTypeDeclaration((String)AsmUtils.toAsmType((Type)mapperClass)));
        }

        @Override
        public void addMappingCall(MethodVisitor mv, String mapperClassType) {
            Type mapperClass = AsmUtils.findClosestPublicTypeExposing(this.mapper.getClass(), FieldMapper.class);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, mapperClassType, this.prefix + this.index, "L" + AsmUtils.toAsmType((Type)mapperClass) + ";");
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 3);
            Method m = MapperAsmBuilder.getMapToMethod(TypeHelper.toClass((Type)mapperClass));
            AsmUtils.invoke((MethodVisitor)mv, (Method)m);
        }

        @Override
        public void addDeclaration(ClassWriter cw) {
            Type mapperClass = AsmUtils.findClosestPublicTypeExposing(this.mapper.getClass(), FieldMapper.class);
            FieldVisitor fv = cw.visitField(18, this.prefix + this.index, AsmUtils.toTargetTypeDeclaration((String)AsmUtils.toAsmType((Type)mapperClass)), AsmUtils.toTargetTypeDeclaration((String)AsmUtils.toGenericAsmType((Type)mapperClass)), null);
            fv.visitEnd();
        }
    }

    private static final class IndexableConstantSourceFieldMapperBuilder<S, T>
    implements MapperBuilder {
        private final FieldMapper<? super S, ? super T> mapper;
        private final int getterIndex;
        private final int index;
        private final String prefix;
        private final Method getMethod;
        private final Class<?> setterClass;
        private final Method setMethod;
        private final Class<?> declaredSetterClass;

        private IndexableConstantSourceFieldMapperBuilder(FieldMapper<? super S, ? super T> mapper, int getterIndex, int index, String prefix, Method getMethod, Class<?> setterClass, Method setMethod, Class<?> declaredSetterClass) throws NoSuchMethodException {
            this.mapper = mapper;
            this.getterIndex = getterIndex;
            this.index = index;
            this.prefix = prefix;
            this.setterClass = setterClass;
            this.getMethod = getMethod;
            this.setMethod = setMethod;
            this.declaredSetterClass = declaredSetterClass;
        }

        @Override
        public void addDeclaration(ClassWriter cw) {
            FieldVisitor fvSetter = cw.visitField(18, this.prefix + this.index + "Setter", AsmUtils.toTargetTypeDeclaration((String)AsmUtils.toAsmType(this.setterClass)), AsmUtils.toTargetTypeDeclaration((String)AsmUtils.toGenericAsmType(this.setterClass)), null);
            fvSetter.visitEnd();
        }

        @Override
        public void addInit(MethodVisitor mv, String mapperClassType) {
            String fieldMapperType = AsmUtils.toAsmType(this.mapper.getClass());
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, this.prefix == MapperAsmBuilder.CONSTRUCTOR_MAPPER_PREFIX ? 2 : 1);
            AsmUtils.addIndex((MethodVisitor)mv, (int)this.index);
            mv.visitInsn(50);
            mv.visitTypeInsn(192, fieldMapperType);
            mv.visitFieldInsn(180, fieldMapperType, "setter", AsmUtils.toTargetTypeDeclaration((String)AsmUtils.toAsmType(this.declaredSetterClass)));
            mv.visitTypeInsn(192, AsmUtils.toAsmType(this.setterClass));
            mv.visitFieldInsn(181, mapperClassType, this.prefix + this.index + "Setter", AsmUtils.toTargetTypeDeclaration((String)AsmUtils.toAsmType(this.setterClass)));
        }

        @Override
        public void addMappingCall(MethodVisitor mv, String mapperClassType) throws NoSuchMethodException {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, mapperClassType, this.prefix + this.index + "Setter", AsmUtils.toTargetTypeDeclaration((String)AsmUtils.toAsmType(this.setterClass)));
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 3);
            AsmUtils.addIndex((MethodVisitor)mv, (int)this.getterIndex);
            AsmUtils.invoke((MethodVisitor)mv, (Method)this.getMethod);
            AsmUtils.invoke((MethodVisitor)mv, (Method)this.setMethod);
        }
    }

    private static final class ConstantSourceFieldMapperBuilder<S, T>
    implements MapperBuilder {
        private final FieldMapper<? super S, ? super T> mapper;
        private final int index;
        private final String prefix;
        private final Class<?> getterClass;
        private final Method getMethod;
        private final Class<?> setterClass;
        private final Method setMethod;
        private final Class<?> declaredGetterClass;
        private final Class<?> declaredSetterClass;

        private ConstantSourceFieldMapperBuilder(FieldMapper<? super S, ? super T> mapper, int index, String prefix, Class<?> getterClass, Method getMethod, Class<?> setterClass, Method setMethod, Class<?> declaredGetterClass, Class<?> declaredSetterClass) throws NoSuchMethodException {
            this.mapper = mapper;
            this.index = index;
            this.prefix = prefix;
            this.getterClass = getterClass;
            this.setterClass = setterClass;
            this.getMethod = getMethod;
            this.setMethod = setMethod;
            this.declaredGetterClass = declaredGetterClass;
            this.declaredSetterClass = declaredSetterClass;
        }

        @Override
        public void addInit(MethodVisitor mv, String mapperClassType) {
            String fieldMapperType = AsmUtils.toAsmType(this.mapper.getClass());
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, this.prefix == MapperAsmBuilder.CONSTRUCTOR_MAPPER_PREFIX ? 2 : 1);
            AsmUtils.addIndex((MethodVisitor)mv, (int)this.index);
            mv.visitInsn(50);
            mv.visitTypeInsn(192, fieldMapperType);
            mv.visitFieldInsn(180, fieldMapperType, "getter", AsmUtils.toTargetTypeDeclaration((String)AsmUtils.toAsmType(this.declaredGetterClass)));
            mv.visitTypeInsn(192, AsmUtils.toAsmType(this.getterClass));
            mv.visitFieldInsn(181, mapperClassType, this.prefix + this.index + "Getter", AsmUtils.toTargetTypeDeclaration((String)AsmUtils.toAsmType(this.getterClass)));
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, this.prefix == MapperAsmBuilder.CONSTRUCTOR_MAPPER_PREFIX ? 2 : 1);
            AsmUtils.addIndex((MethodVisitor)mv, (int)this.index);
            mv.visitInsn(50);
            mv.visitTypeInsn(192, fieldMapperType);
            mv.visitFieldInsn(180, fieldMapperType, "setter", AsmUtils.toTargetTypeDeclaration((String)AsmUtils.toAsmType(this.declaredSetterClass)));
            mv.visitTypeInsn(192, AsmUtils.toAsmType(this.setterClass));
            mv.visitFieldInsn(181, mapperClassType, this.prefix + this.index + "Setter", AsmUtils.toTargetTypeDeclaration((String)AsmUtils.toAsmType(this.setterClass)));
        }

        @Override
        public void addMappingCall(MethodVisitor mv, String mapperClassType) throws NoSuchMethodException {
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, mapperClassType, this.prefix + this.index + "Setter", AsmUtils.toTargetTypeDeclaration((String)AsmUtils.toAsmType(this.setterClass)));
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, mapperClassType, this.prefix + this.index + "Getter", AsmUtils.toTargetTypeDeclaration((String)AsmUtils.toAsmType(this.getterClass)));
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 3);
            AsmUtils.invoke((MethodVisitor)mv, (Method)this.getMethod);
            AsmUtils.invoke((MethodVisitor)mv, (Method)this.setMethod);
        }

        @Override
        public void addDeclaration(ClassWriter cw) {
            FieldVisitor fvGetter = cw.visitField(18, this.prefix + this.index + "Getter", AsmUtils.toTargetTypeDeclaration((String)AsmUtils.toAsmType(this.getterClass)), AsmUtils.toTargetTypeDeclaration((String)AsmUtils.toGenericAsmType(this.getterClass)), null);
            fvGetter.visitEnd();
            FieldVisitor fvSetter = cw.visitField(18, this.prefix + this.index + "Setter", AsmUtils.toTargetTypeDeclaration((String)AsmUtils.toAsmType(this.setterClass)), AsmUtils.toTargetTypeDeclaration((String)AsmUtils.toGenericAsmType(this.setterClass)), null);
            fvSetter.visitEnd();
        }
    }
}

