/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.FieldMapper;
import org.simpleflatmapper.map.MapperBuilderErrorHandler;
import org.simpleflatmapper.map.MapperBuildingException;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.SourceFieldMapper;
import org.simpleflatmapper.map.context.MappingContextFactory;
import org.simpleflatmapper.map.context.MappingContextFactoryBuilder;
import org.simpleflatmapper.map.impl.DiscriminatorPropertyFinder;
import org.simpleflatmapper.map.mapper.AbstractMapper;
import org.simpleflatmapper.map.mapper.AbstractMapperFactory;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.mapper.ConstantSourceMapperBuilder;
import org.simpleflatmapper.map.mapper.ContextualSourceFieldMapperImpl;
import org.simpleflatmapper.map.mapper.DefaultConstantSourceMapperBuilder;
import org.simpleflatmapper.map.mapper.GenericBuilder;
import org.simpleflatmapper.map.mapper.KeyFactory;
import org.simpleflatmapper.map.mapper.MapperSource;
import org.simpleflatmapper.map.mapper.PropertyMapping;
import org.simpleflatmapper.map.mapper.TransformSourceFieldMapper;
import org.simpleflatmapper.map.property.OptionalProperty;
import org.simpleflatmapper.reflect.BiInstantiator;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.util.BiConsumer;
import org.simpleflatmapper.util.EqualsPredicate;
import org.simpleflatmapper.util.ForEachCallBack;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.TypeHelper;

public class DiscriminatorConstantSourceMapperBuilder<S, T, K extends FieldKey<K>>
extends ConstantSourceMapperBuilder<S, T, K> {
    private final DiscriminatedBuilder<S, T, K>[] builders;
    private final MappingContextFactoryBuilder<S, K> mappingContextFactoryBuilder;
    private final CaptureError mapperBuilderErrorHandler;
    private final MapperConfig<K, ? extends S> mapperConfig;

    public DiscriminatorConstantSourceMapperBuilder(MapperConfig.Discriminator<? super S, T> discriminator, MapperSource<? super S, K> mapperSource, ClassMeta<T> classMeta, MapperConfig<K, ? extends S> mapperConfig, MappingContextFactoryBuilder<S, K> mappingContextFactoryBuilder, KeyFactory<K> keyFactory, PropertyFinder<T> propertyFinder) throws MapperBuildingException {
        this.mappingContextFactoryBuilder = mappingContextFactoryBuilder;
        this.mapperConfig = mapperConfig;
        this.builders = new DiscriminatedBuilder[discriminator.cases.length];
        this.mapperBuilderErrorHandler = new CaptureError(mapperConfig.mapperBuilderErrorHandler(), this.builders.length);
        MapperConfig<K, ? extends S> kMapperConfig = mapperConfig.mapperBuilderErrorHandler(this.mapperBuilderErrorHandler);
        for (int i = 0; i < discriminator.cases.length; ++i) {
            MapperConfig.DiscriminatorCase discriminatorCase = discriminator.cases[i];
            PropertyFinder<T> subPropertyFinder = propertyFinder;
            if (propertyFinder instanceof DiscriminatorPropertyFinder) {
                subPropertyFinder = ((DiscriminatorPropertyFinder)subPropertyFinder).getImplementationPropertyFinder(discriminatorCase.classMeta.getType());
            }
            this.builders[i] = this.getDiscriminatedBuilder(mapperSource, mappingContextFactoryBuilder, keyFactory, subPropertyFinder, kMapperConfig, discriminatorCase, classMeta);
        }
    }

    private <T> DiscriminatedBuilder<S, T, K> getDiscriminatedBuilder(MapperSource<? super S, K> mapperSource, MappingContextFactoryBuilder<S, K> mappingContextFactoryBuilder, KeyFactory<K> keyFactory, PropertyFinder<T> propertyFinder, MapperConfig<K, ? extends S> kMapperConfig, MapperConfig.DiscriminatorCase<? super S, ? extends T> discrimnatorCase, ClassMeta<T> commonClassMeta) {
        return new DiscriminatedBuilder(discrimnatorCase, new DefaultConstantSourceMapperBuilder<S, T, K>(mapperSource, discrimnatorCase.classMeta.withReflectionService(commonClassMeta.getReflectionService()), kMapperConfig, mappingContextFactoryBuilder, keyFactory, propertyFinder));
    }

    @Override
    public ConstantSourceMapperBuilder<S, T, K> addMapping(K key, ColumnDefinition<K, ?> columnDefinition) {
        for (DiscriminatedBuilder<S, T, K> builder : this.builders) {
            ((DiscriminatedBuilder)builder).builder.addMapping(key, columnDefinition);
        }
        Object composedDefinition = columnDefinition.compose(this.mapperConfig.columnDefinitions().getColumnDefinition(key));
        this.mapperBuilderErrorHandler.successfullyMapAtLeastToOne((ColumnDefinition<?, ?>)composedDefinition);
        return this;
    }

    @Override
    protected <P> void addMapping(K columnKey, ColumnDefinition<K, ?> columnDefinition, PropertyMeta<T, P> prop) {
        if (prop instanceof DiscriminatorPropertyFinder.DiscriminatorPropertyMeta) {
            DiscriminatorPropertyFinder.DiscriminatorPropertyMeta pm = (DiscriminatorPropertyFinder.DiscriminatorPropertyMeta)prop;
            pm.forEachProperty(new BiConsumer<Type, PropertyMeta<?, ?>>((FieldKey)columnKey, columnDefinition){
                final /* synthetic */ FieldKey val$columnKey;
                final /* synthetic */ ColumnDefinition val$columnDefinition;
                {
                    this.val$columnKey = fieldKey;
                    this.val$columnDefinition = columnDefinition;
                }

                public void accept(Type type, PropertyMeta<?, ?> propertyMeta) {
                    DiscriminatorConstantSourceMapperBuilder.this.getBuilder(type).addMapping(this.val$columnKey, this.val$columnDefinition, propertyMeta);
                }
            });
        } else {
            for (DiscriminatedBuilder<S, T, K> builder : this.builders) {
                ((DiscriminatedBuilder)builder).builder.addMapping(columnKey, columnDefinition, prop);
            }
        }
    }

    private ConstantSourceMapperBuilder getBuilder(Type type) {
        for (DiscriminatedBuilder<S, T, K> builder : this.builders) {
            if (!TypeHelper.areEquals((Type)((DiscriminatedBuilder)builder).builder.getTargetType(), (Type)type)) continue;
            return ((DiscriminatedBuilder)builder).builder;
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    @Override
    public List<K> getKeys() {
        HashSet keys = new HashSet();
        for (DiscriminatedBuilder<S, T, K> builder : this.builders) {
            keys.addAll(((DiscriminatedBuilder)builder).builder.getKeys());
        }
        return new ArrayList(keys);
    }

    @Override
    public <H extends ForEachCallBack<PropertyMapping<T, ?, K>>> H forEachProperties(H handler) {
        for (DiscriminatedBuilder<S, T, K> builder : this.builders) {
            ((DiscriminatedBuilder)builder).builder.forEachProperties(handler);
        }
        return handler;
    }

    @Override
    public ContextualSourceFieldMapperImpl<S, T> mapper() {
        SourceFieldMapper<S, T> mapper = this.sourceFieldMapper();
        return new ContextualSourceFieldMapperImpl<S, T>(this.mappingContextFactoryBuilder.build(), mapper);
    }

    @Override
    public SourceFieldMapper<S, T> sourceFieldMapper() {
        PredicatedInstantiator[] predicatedInstantiator = new PredicatedInstantiator[this.builders.length];
        ArrayList<2> fieldMappers = new ArrayList<2>();
        for (int i = 0; i < this.builders.length; ++i) {
            DiscriminatedBuilder<S, T, K> builder = this.builders[i];
            final Predicate predicate = ((DiscriminatedBuilder)builder).discrimnatorCase.predicate;
            DefaultConstantSourceMapperBuilder.GenericBuilderMapping genericBuilderMapping = ((DiscriminatedBuilder)builder).builder.getGenericBuilderMapping();
            predicatedInstantiator[i] = new PredicatedInstantiator(predicate, genericBuilderMapping.genericBuilderInstantiator);
            final FieldMapper[] targetFieldMappers = genericBuilderMapping.targetFieldMappers;
            fieldMappers.add(new FieldMapper<S, T>(){

                @Override
                public void mapTo(S source, T target, MappingContext<? super S> context) throws Exception {
                    if (predicate.test(source)) {
                        for (FieldMapper fm : targetFieldMappers) {
                            fm.mapTo(source, target, context);
                        }
                    }
                }
            });
        }
        boolean oneColumn = this.isOneColumn(predicatedInstantiator);
        Object gbi = oneColumn ? new OneColumnBuildBiInstantiator(predicatedInstantiator) : new GenericBuildBiInstantiator(predicatedInstantiator);
        DiscriminatorGenericBuilderMapper mapper = new DiscriminatorGenericBuilderMapper(gbi);
        FieldMapper[] targetFieldMappers = fieldMappers.toArray(new FieldMapper[0]);
        return new TransformSourceFieldMapper(mapper, targetFieldMappers, GenericBuilder.buildFunction());
    }

    private boolean isOneColumn(PredicatedInstantiator<S, T>[] predicatedInstantiator) {
        Getter getter = null;
        for (PredicatedInstantiator<S, T> pi : predicatedInstantiator) {
            if (!(((PredicatedInstantiator)pi).predicate instanceof AbstractMapperFactory.DiscriminatorConditionBuilder.SourcePredicate)) {
                return false;
            }
            AbstractMapperFactory.DiscriminatorConditionBuilder.SourcePredicate sp = (AbstractMapperFactory.DiscriminatorConditionBuilder.SourcePredicate)((PredicatedInstantiator)pi).predicate;
            Getter lg = sp.getter;
            if (getter == null) {
                getter = lg;
            } else if (getter != lg) {
                return false;
            }
            if (sp.predicate instanceof EqualsPredicate) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRootAggregate() {
        return ((DiscriminatedBuilder)this.builders[0]).builder.isRootAggregate();
    }

    @Override
    public MappingContextFactory<? super S> contextFactory() {
        return ((DiscriminatedBuilder)this.builders[0]).builder.contextFactory();
    }

    @Override
    public void addMapper(FieldMapper<S, T> mapper) {
        for (DiscriminatedBuilder<S, T, K> builder : this.builders) {
            ((DiscriminatedBuilder)builder).builder.addMapper(mapper);
        }
    }

    private static class CaptureError
    implements MapperBuilderErrorHandler {
        private final MapperBuilderErrorHandler delegate;
        private final List<PropertyNotFound> errorCollector;
        private final int nbBuilders;

        private CaptureError(MapperBuilderErrorHandler delegate, int nbBuilders) {
            this.delegate = delegate;
            this.nbBuilders = nbBuilders;
            this.errorCollector = new ArrayList<PropertyNotFound>();
        }

        @Override
        public void accessorNotFound(String msg) {
            this.delegate.accessorNotFound(msg);
        }

        @Override
        public void propertyNotFound(Type target, String property) {
            this.errorCollector.add(new PropertyNotFound(target, property));
        }

        @Override
        public void customFieldError(FieldKey<?> key, String message) {
            this.delegate.customFieldError(key, message);
        }

        public void successfullyMapAtLeastToOne(ColumnDefinition<?, ?> columnDefinition) {
            try {
                if (this.errorCollector.size() == this.nbBuilders && !columnDefinition.has(OptionalProperty.class)) {
                    PropertyNotFound propertyNotFound = this.errorCollector.get(0);
                    this.delegate.propertyNotFound(propertyNotFound.target, propertyNotFound.property);
                }
            }
            finally {
                this.errorCollector.clear();
            }
        }

        private static class PropertyNotFound {
            final Type target;
            final String property;

            private PropertyNotFound(Type target, String property) {
                this.target = target;
                this.property = property;
            }
        }
    }

    private class DiscriminatorGenericBuilderMapper<S, T>
    extends AbstractMapper<S, GenericBuilder<S, T>> {
        public DiscriminatorGenericBuilderMapper(BiInstantiator<? super S, MappingContext<? super S>, GenericBuilder<S, T>> gbi) {
            super(gbi);
        }

        @Override
        protected void mapFields(S source, GenericBuilder<S, T> target, MappingContext<? super S> mappingContext) throws Exception {
            target.mapFrom((S)source, mappingContext);
        }

        @Override
        protected void mapToFields(S source, GenericBuilder<S, T> target, MappingContext<? super S> mappingContext) throws Exception {
            target.mapFrom((S)source, mappingContext);
        }
    }

    private static class PredicatedInstantiator<S, T> {
        private final Predicate predicate;
        private final BiInstantiator<S, MappingContext<? super S>, GenericBuilder<S, T>> instantiator;

        private PredicatedInstantiator(Predicate predicate, BiInstantiator<S, MappingContext<? super S>, GenericBuilder<S, T>> instantiator) {
            this.predicate = predicate;
            this.instantiator = instantiator;
        }
    }

    private static class OneColumnBuildBiInstantiator<S, T>
    implements BiInstantiator<S, MappingContext<? super S>, GenericBuilder<S, T>> {
        private final Getter<S, ?> getter;
        private final Map<Object, BiInstantiator<S, MappingContext<? super S>, GenericBuilder<S, T>>> instantiators;

        public OneColumnBuildBiInstantiator(PredicatedInstantiator<S, T>[] predicatedInstantiators) {
            if (predicatedInstantiators == null || predicatedInstantiators.length == 0) {
                throw new IllegalArgumentException("predicatedInstantiators is null or empty");
            }
            this.getter = ((AbstractMapperFactory.DiscriminatorConditionBuilder.SourcePredicate)((PredicatedInstantiator)predicatedInstantiators[0]).predicate).getter;
            this.instantiators = new HashMap<Object, BiInstantiator<S, MappingContext<? super S>, GenericBuilder<S, T>>>();
            for (PredicatedInstantiator<S, T> pi : predicatedInstantiators) {
                EqualsPredicate ep = (EqualsPredicate)((AbstractMapperFactory.DiscriminatorConditionBuilder.SourcePredicate)((PredicatedInstantiator)pi).predicate).predicate;
                this.instantiators.put(ep.expected, ((PredicatedInstantiator)pi).instantiator);
            }
        }

        public GenericBuilder<S, T> newInstance(S o, MappingContext<? super S> o2) throws Exception {
            Object value = this.getter.get(o);
            BiInstantiator<S, MappingContext<? super S>, GenericBuilder<S, T>> instantiator = this.instantiators.get(value);
            if (instantiator == null) {
                throw new IllegalArgumentException("No discrimator matched " + value);
            }
            return (GenericBuilder)instantiator.newInstance(o, o2);
        }
    }

    private static class GenericBuildBiInstantiator<S, T>
    implements BiInstantiator<S, MappingContext<? super S>, GenericBuilder<S, T>> {
        private final PredicatedInstantiator<S, T>[] predicatedInstantiators;

        public GenericBuildBiInstantiator(PredicatedInstantiator<S, T>[] predicatedInstantiators) {
            this.predicatedInstantiators = predicatedInstantiators;
        }

        public GenericBuilder<S, T> newInstance(S o, MappingContext<? super S> o2) throws Exception {
            for (PredicatedInstantiator<S, T> pi : this.predicatedInstantiators) {
                if (!((PredicatedInstantiator)pi).predicate.test(o)) continue;
                return (GenericBuilder)((PredicatedInstantiator)pi).instantiator.newInstance(o, o2);
            }
            throw new IllegalArgumentException("No discrimator matched " + o);
        }
    }

    private static class DiscriminatedBuilder<S, T, K extends FieldKey<K>> {
        private final MapperConfig.DiscriminatorCase<? super S, T> discrimnatorCase;
        private final DefaultConstantSourceMapperBuilder<S, T, K> builder;

        private DiscriminatedBuilder(MapperConfig.DiscriminatorCase<? super S, T> discrimnatorCase, DefaultConstantSourceMapperBuilder<S, T, K> builder) {
            this.discrimnatorCase = discrimnatorCase;
            this.builder = builder;
        }
    }
}

