/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.context;

import java.util.ArrayList;
import java.util.List;
import org.simpleflatmapper.converter.ContextFactoryBuilder;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.context.KeyAndPredicate;
import org.simpleflatmapper.map.context.KeyDefinition;
import org.simpleflatmapper.map.context.KeySourceGetter;
import org.simpleflatmapper.map.context.MappingContextFactory;
import org.simpleflatmapper.map.context.impl.BreakDetectorMappingContextFactory;
import org.simpleflatmapper.map.context.impl.KeyDefinitionBuilder;
import org.simpleflatmapper.map.context.impl.NullChecker;
import org.simpleflatmapper.map.context.impl.ValuedMappingContextFactory;
import org.simpleflatmapper.map.impl.JoinUtils;
import org.simpleflatmapper.reflect.meta.ArrayElementPropertyMeta;
import org.simpleflatmapper.reflect.meta.MapKeyValueElementPropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.setter.AppendCollectionSetter;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.Supplier;

public class MappingContextFactoryBuilder<S, K>
implements ContextFactoryBuilder {
    private final Counter counter;
    private final int currentIndex;
    private final MappingContextFactoryBuilder<S, K> parent;
    private final List<KeyAndPredicate<S, K>> keys;
    private final KeySourceGetter<K, ? super S> keySourceGetter;
    private final List<MappingContextFactoryBuilder<S, K>> children = new ArrayList<MappingContextFactoryBuilder<S, K>>();
    private final List<Supplier<?>> suppliers = new ArrayList();
    private final PropertyMeta<?, ?> owner;
    private final boolean ignoreRootKey;

    public MappingContextFactoryBuilder(KeySourceGetter<K, ? super S> keySourceGetter, boolean ignoreRootKey) {
        this(new Counter(), new ArrayList<KeyAndPredicate<S, K>>(), keySourceGetter, null, null, ignoreRootKey);
    }

    protected MappingContextFactoryBuilder(Counter counter, List<KeyAndPredicate<S, K>> keys, KeySourceGetter<K, ? super S> keySourceGetter, MappingContextFactoryBuilder<S, K> parent, PropertyMeta<?, ?> owner, boolean ignoreRootKey) {
        this.counter = counter;
        this.currentIndex = counter.value;
        this.keys = keys;
        this.keySourceGetter = keySourceGetter;
        this.parent = parent;
        this.ignoreRootKey = ignoreRootKey;
        ++this.counter.value;
        this.owner = owner;
    }

    public void addKey(KeyAndPredicate<S, K> keyAndPredicate) {
        this.addKeyTo(keyAndPredicate, this.keys);
    }

    private void addKeyTo(KeyAndPredicate<S, K> keyAndPredicate, List<KeyAndPredicate<S, K>> keyAndPredicates) {
        for (int i = 0; i < keyAndPredicates.size(); ++i) {
            KeyAndPredicate<S, K> kp = keyAndPredicates.get(i);
            if (!kp.key.equals(keyAndPredicate.key)) continue;
            keyAndPredicates.set(i, kp.mergeWith(keyAndPredicate));
            return;
        }
        keyAndPredicates.add(keyAndPredicate);
    }

    public int addSupplier(Supplier<?> supplier) {
        if (this.parent == null) {
            int index = this.suppliers.size();
            this.suppliers.add(index, supplier);
            return index;
        }
        return this.parent.addSupplier(supplier);
    }

    public Predicate<S> nullChecker() {
        return new NullChecker<S, K>(this.keys, this.keySourceGetter);
    }

    public MappingContextFactoryBuilder<S, K> newBuilder(List<KeyAndPredicate<S, K>> subKeys, PropertyMeta<?, ?> owner) {
        for (MappingContextFactoryBuilder<S, K> child : this.children) {
            if (!child.owner.getPath().equals(owner.getPath()) || !child.owner.getPropertyClassMeta().equals(owner.getPropertyClassMeta())) continue;
            return child;
        }
        MappingContextFactoryBuilder<? super S, K> subBuilder = new MappingContextFactoryBuilder<S, K>(this.counter, subKeys, this.keySourceGetter, this, owner, this.ignoreRootKey);
        this.children.add(subBuilder);
        return subBuilder;
    }

    public MappingContextFactory<S> build() {
        if (this.parent != null) {
            throw new IllegalStateException();
        }
        ArrayList<MappingContextFactoryBuilder<S, K>> builders = new ArrayList<MappingContextFactoryBuilder<S, K>>();
        this.addAllBuilders(builders);
        MappingContextFactory context = this.suppliers.isEmpty() ? MappingContext.EMPTY_FACTORY : new ValuedMappingContextFactory(this.suppliers);
        if (MappingContextFactoryBuilder.hasKeys(builders)) {
            KeyDefinitionBuilder[] keyDefinitionsBuilder = new KeyDefinitionBuilder[builders.get((int)(builders.size() - 1)).currentIndex + 1];
            for (int i = 0; i < builders.size(); ++i) {
                MappingContextFactoryBuilder<S, K> builder = builders.get(i);
                this.populateKey(keyDefinitionsBuilder, builders, builder);
            }
            KeyDefinition<S, K>[] keyDefinitions = KeyDefinitionBuilder.toKeyDefinitions(keyDefinitionsBuilder);
            KeyDefinition rootKeyDefinition = keyDefinitions[0];
            context = new BreakDetectorMappingContextFactory(rootKeyDefinition, keyDefinitions, context);
        }
        return context;
    }

    private KeyDefinitionBuilder<S, K> populateKey(KeyDefinitionBuilder<S, K>[] keyDefinitions, ArrayList<MappingContextFactoryBuilder<S, K>> builders, MappingContextFactoryBuilder<S, K> builder) {
        KeyDefinitionBuilder<Object, K> keyDefinition;
        if (keyDefinitions[builder.currentIndex] != null) {
            return keyDefinitions[builder.currentIndex];
        }
        int parentIndex = super.getNonEmptyParentIndex();
        KeyDefinitionBuilder<S, K> parent = null;
        if (parentIndex != -1 && (parent = keyDefinitions[parentIndex]) == null) {
            for (int i = 0; i < builders.size(); ++i) {
                MappingContextFactoryBuilder<S, K> potentialParent = builders.get(i);
                if (potentialParent.currentIndex != parentIndex) continue;
                parent = this.populateKey(keyDefinitions, builders, potentialParent);
                break;
            }
            if (parent == null) {
                throw new IllegalArgumentException("Could not find parent for builder " + builder);
            }
        }
        if (parent != null && super.inheritKeys(parentIndex)) {
            keyDefinition = parent.asChild(builder.currentIndex);
        } else {
            ArrayList<KeyAndPredicate<S, K>> keys = new ArrayList<KeyAndPredicate<S, K>>(super.effectiveKeys());
            if (!(parent == null || parentIndex <= 0 && this.ignoreRootKey)) {
                this.appendParentKeys(parent, keys);
            }
            keyDefinition = new KeyDefinitionBuilder<S, K>(keys, builder.keySourceGetter, builder.currentIndex);
        }
        keyDefinitions[builder.currentIndex] = keyDefinition;
        return keyDefinition;
    }

    private boolean inheritKeys(int parentIndex) {
        return this.effectiveKeys().isEmpty() && !this.newObjectOnEachRow(parentIndex);
    }

    private void appendParentKeys(KeyDefinitionBuilder<S, K> parent, List<KeyAndPredicate<S, K>> keys) {
        if (!keys.isEmpty()) {
            for (KeyAndPredicate<S, K> k : parent.getKeyAndPredicates()) {
                this.addKeyTo(k, keys);
            }
        }
    }

    private List<KeyAndPredicate<S, K>> effectiveKeys() {
        if (!this.keys.isEmpty()) {
            return this.keys;
        }
        ArrayList<KeyAndPredicate<S, K>> keys = new ArrayList<KeyAndPredicate<S, K>>();
        for (MappingContextFactoryBuilder<S, K> child : this.children) {
            if (!super.isEligibleAsSubstituteKey()) continue;
            keys.addAll(super.effectiveKeys());
        }
        return keys;
    }

    private boolean newObjectOnEachRow(int parentIndex) {
        ArrayElementPropertyMeta elementPropertyMeta;
        if (this.owner instanceof ArrayElementPropertyMeta ? (elementPropertyMeta = (ArrayElementPropertyMeta)this.owner).getSetter() instanceof AppendCollectionSetter : this.owner instanceof MapKeyValueElementPropertyMeta) {
            return true;
        }
        if (this.parent != null && this.parent.currentIndex != parentIndex) {
            return super.newObjectOnEachRow(parentIndex);
        }
        return false;
    }

    private static <S, K> boolean hasKeys(ArrayList<MappingContextFactoryBuilder<S, K>> builders) {
        for (int i = 0; i < builders.size(); ++i) {
            if (builders.get(i).hasNoKeys()) continue;
            return true;
        }
        return false;
    }

    private boolean isEligibleAsSubstituteKey() {
        return !JoinUtils.isArrayElement(this.owner);
    }

    private int getNonEmptyParentIndex() {
        return this.parent == null ? -1 : (super.effectiveKeys().isEmpty() ? super.getNonEmptyParentIndex() : this.parent.currentIndex);
    }

    private void addAllBuilders(ArrayList<MappingContextFactoryBuilder<S, K>> builders) {
        builders.add(this);
        for (MappingContextFactoryBuilder<S, K> child : this.children) {
            super.addAllBuilders(builders);
        }
    }

    public boolean hasNoKeys() {
        return this.effectiveKeys().isEmpty();
    }

    public boolean hasNoDependentKeys() {
        if (!this.hasNoKeys()) {
            return false;
        }
        for (MappingContextFactoryBuilder<S, K> builder : this.children) {
            if (builder.hasNoDependentKeys()) continue;
            return false;
        }
        return true;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public int currentIndex() {
        return this.currentIndex;
    }

    public boolean hasChildren() {
        return this.children.isEmpty();
    }

    public String toString() {
        return "MappingContextFactoryBuilder{currentIndex=" + this.currentIndex + ", keys=" + this.keys + ", children=" + this.children + '}';
    }

    private static class Counter {
        int value;

        private Counter() {
        }
    }
}

