/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import java.util.List;
import org.simpleflatmapper.converter.UncheckedConverter;
import org.simpleflatmapper.map.ConsumerErrorHandler;
import org.simpleflatmapper.map.MappingException;
import org.simpleflatmapper.map.SourceFieldMapper;
import org.simpleflatmapper.map.context.MappingContextFactoryFromRows;
import org.simpleflatmapper.map.mapper.AbstractEnumerableDelegateMapper;
import org.simpleflatmapper.map.mapper.DiscriminatorEnumerable;
import org.simpleflatmapper.util.Enumerable;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.UnaryFactory;

public class DiscriminatorMapper<ROW, ROWS, T, EX extends Exception>
extends AbstractEnumerableDelegateMapper<ROW, ROWS, T, EX> {
    private final List<PredicatedMapper<ROW, ROWS, T, EX>> mappers;
    private final UncheckedConverter<ROW, String> errorConverter;
    private final UnaryFactory<ROWS, Enumerable<ROW>> rowEnumerableFactory;

    public DiscriminatorMapper(List<PredicatedMapper<ROW, ROWS, T, EX>> mappers, UnaryFactory<ROWS, Enumerable<ROW>> rowEnumerableFactory, UncheckedConverter<ROW, String> errorConverter, ConsumerErrorHandler consumerErrorHandler) {
        super(consumerErrorHandler);
        this.mappers = mappers;
        this.errorConverter = errorConverter;
        this.rowEnumerableFactory = rowEnumerableFactory;
    }

    @Override
    protected SourceFieldMapper<ROW, T> getMapper(ROW row) throws MappingException {
        for (PredicatedMapper<ROW, ROWS, T, EX> tm : this.mappers) {
            if (!tm.getPredicate().test(row)) continue;
            return tm.getMapper();
        }
        throw new MappingException("No mapper found for " + (String)this.errorConverter.convert(row));
    }

    public DiscriminatorEnumerable<ROW, T> enumerate(ROWS rows) throws EX {
        DiscriminatorEnumerable.PredicatedMapperWithContext[] mapperDiscriminators = new DiscriminatorEnumerable.PredicatedMapperWithContext[this.mappers.size()];
        for (int i = 0; i < mapperDiscriminators.length; ++i) {
            PredicatedMapper<ROW, ROWS, T, EX> predicatedMapper = this.mappers.get(i);
            mapperDiscriminators[i] = new DiscriminatorEnumerable.PredicatedMapperWithContext<ROW, T>(predicatedMapper.getPredicate(), predicatedMapper.getMapper(), predicatedMapper.getMappingContextFactory().newMappingContext(rows));
        }
        return new DiscriminatorEnumerable(mapperDiscriminators, (Enumerable)this.rowEnumerableFactory.newInstance(rows), this.errorConverter);
    }

    public static class PredicatedMapper<ROW, ROWS, T, EX extends Throwable> {
        private final Predicate<ROW> predicate;
        private final SourceFieldMapper<ROW, T> mapper;
        private final MappingContextFactoryFromRows<ROW, ROWS, EX> mappingContextFactory;

        public PredicatedMapper(Predicate<ROW> predicate, SourceFieldMapper<ROW, T> mapper, MappingContextFactoryFromRows<ROW, ROWS, EX> mappingContextFactory) {
            this.predicate = predicate;
            this.mapper = mapper;
            this.mappingContextFactory = mappingContextFactory;
        }

        public Predicate<ROW> getPredicate() {
            return this.predicate;
        }

        public SourceFieldMapper<ROW, T> getMapper() {
            return this.mapper;
        }

        public MappingContextFactoryFromRows<ROW, ROWS, EX> getMappingContextFactory() {
            return this.mappingContextFactory;
        }
    }
}

