/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map;

import java.util.ArrayList;
import java.util.List;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.util.Function;

public class Result<T, K> {
    private final T value;
    private final List<FieldError<K>> errors;

    private Result(T value, List<FieldError<K>> errors) {
        this.value = value;
        this.errors = errors;
    }

    public T getValue() {
        return this.value;
    }

    public List<FieldError<K>> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public String toString() {
        return "Result{value=" + this.value + ", errors=" + this.errors + '}';
    }

    public static <T, K> ResultBuilder<T, K> builder() {
        return new ResultBuilder();
    }

    public static <T, K> Function<ResultBuilder<T, K>, Result<T, K>> buildingFunction() {
        return new Function<ResultBuilder<T, K>, Result<T, K>>(){

            public Result<T, K> apply(ResultBuilder<T, K> tkResultBuilder) {
                return tkResultBuilder.build();
            }
        };
    }

    @ReflectionService.PassThrough
    public static class ResultBuilder<T, K> {
        private T value;
        private final List<FieldError<K>> errors = new ArrayList<FieldError<K>>();

        public void setValue(T value) {
            this.value = value;
        }

        public void addError(FieldError<K> error) {
            this.errors.add(error);
        }

        public Result<T, K> build() {
            return new Result(this.value, this.errors);
        }
    }

    public static class FieldError<K> {
        private final K key;
        private final Throwable error;

        public FieldError(K key, Throwable error) {
            this.key = key;
            this.error = error;
        }

        public K getKey() {
            return this.key;
        }

        public Throwable getError() {
            return this.error;
        }

        public String toString() {
            return "FieldError{key=" + this.key + ", error=" + this.error + '}';
        }
    }
}

