/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.property.GetterFactoryProperty;
import org.simpleflatmapper.map.property.GetterProperty;
import org.simpleflatmapper.map.property.IgnoreProperty;
import org.simpleflatmapper.map.property.KeyProperty;
import org.simpleflatmapper.map.property.RenameProperty;
import org.simpleflatmapper.map.property.SetterFactoryProperty;
import org.simpleflatmapper.map.property.SetterProperty;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.SetterFactory;
import org.simpleflatmapper.reflect.getter.GetterFactory;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.util.Asserts;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.TypeHelper;

public abstract class ColumnDefinition<K extends FieldKey<K>, CD extends ColumnDefinition<K, CD>> {
    public static final Predicate<PropertyMeta<?, ?>> DEFAULT_APPLIES_TO = new Predicate<PropertyMeta<?, ?>>(){

        public boolean test(PropertyMeta<?, ?> propertyMeta) {
            return false;
        }
    };
    private final Object[] properties;

    protected ColumnDefinition(Object[] properties) {
        this.properties = (Object[])Asserts.requireNonNull((String)"properties", (Object)properties);
    }

    public K rename(K key) {
        RenameProperty rp = this.lookFor(RenameProperty.class);
        if (rp != null) {
            return rp.apply(key);
        }
        return key;
    }

    public boolean ignore() {
        return this.has(IgnoreProperty.class);
    }

    public boolean has(Class<?> clazz) {
        return this.lookFor(clazz) != null;
    }

    public boolean isKey() {
        return this.has(KeyProperty.class);
    }

    public Predicate<PropertyMeta<?, ?>> keyAppliesTo() {
        KeyProperty kp = this.lookFor(KeyProperty.class);
        if (kp != null) {
            return kp.getAppliesTo();
        }
        return DEFAULT_APPLIES_TO;
    }

    public CD compose(CD columnDefinition) {
        ColumnDefinition cdi = (ColumnDefinition)Asserts.requireNonNull((String)"columnDefinition", columnDefinition);
        Object[] properties = Arrays.copyOf(cdi.properties, this.properties.length + cdi.properties.length);
        System.arraycopy(this.properties, 0, properties, cdi.properties.length, this.properties.length);
        return this.newColumnDefinition(properties);
    }

    public CD add(Object ... props) {
        Asserts.requireNonNull((String)"properties", (Object)props);
        Object[] properties = Arrays.copyOf(this.properties, this.properties.length + props.length);
        System.arraycopy(props, 0, properties, this.properties.length, props.length);
        return this.newColumnDefinition(properties);
    }

    public <T> T lookFor(Class<T> propClass) {
        for (Object cp : this.properties) {
            if (cp == null || !propClass.isInstance(cp)) continue;
            return (T)cp;
        }
        return null;
    }

    public <T> T[] lookForAll(Class<T> propClass) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object cp : this.properties) {
            if (cp == null || !propClass.isInstance(cp)) continue;
            list.add(cp);
        }
        return list.toArray((Object[])Array.newInstance(propClass, 0));
    }

    public Getter<?, ?> getCustomGetterFrom(Type fromType) {
        GetterProperty getterPropertyFrom = this.getCustomGetterPropertyFrom(fromType);
        return getterPropertyFrom != null ? getterPropertyFrom.getGetter() : null;
    }

    public GetterProperty getCustomGetterPropertyFrom(Type fromType) {
        for (GetterProperty getterProperty : this.lookForAll(GetterProperty.class)) {
            if (getterProperty.getSourceType() != null && !TypeHelper.isAssignable((Type)getterProperty.getSourceType(), (Type)fromType)) continue;
            return getterProperty;
        }
        return null;
    }

    public boolean hasCustomSourceFrom(Type ownerType) {
        return this.getCustomGetterPropertyFrom(ownerType) != null;
    }

    public Type getCustomSourceReturnTypeFrom(Type ownerType) {
        GetterProperty getterProperty = this.getCustomGetterPropertyFrom(ownerType);
        return getterProperty != null ? getterProperty.getReturnType() : null;
    }

    public GetterFactory<?, K> getCustomGetterFactoryFrom(Type sourceType) {
        for (GetterFactoryProperty getterFactoryProperty : this.lookForAll(GetterFactoryProperty.class)) {
            if (getterFactoryProperty.getSourceType() != null && !TypeHelper.isAssignable((Type)getterFactoryProperty.getSourceType(), (Type)sourceType)) continue;
            return getterFactoryProperty.getGetterFactory();
        }
        return null;
    }

    public Setter<?, ?> getCustomSetterTo(Type targetType) {
        for (SetterProperty setterProperty : this.lookForAll(SetterProperty.class)) {
            if (setterProperty.getTargetType() != null && !TypeHelper.isAssignable((Type)setterProperty.getTargetType(), (Type)targetType)) continue;
            return setterProperty.getSetter();
        }
        return null;
    }

    public SetterFactory<?, ?> getCustomSetterFactoryTo(Type targetType) {
        for (SetterFactoryProperty getterFactoryProperty : this.lookForAll(SetterFactoryProperty.class)) {
            if (getterFactoryProperty.getTargetType() != null && !TypeHelper.isAssignable((Type)getterFactoryProperty.getTargetType(), (Type)targetType)) continue;
            return getterFactoryProperty.getSetterFactory();
        }
        return null;
    }

    protected abstract CD newColumnDefinition(Object[] var1);

    public CD addRename(String name) {
        return this.add(new RenameProperty(name));
    }

    public CD addIgnore() {
        return this.add(new IgnoreProperty());
    }

    public CD addKey() {
        return this.add(KeyProperty.DEFAULT);
    }

    public CD addKey(Predicate<PropertyMeta<?, ?>> appliesTo) {
        return this.add(new KeyProperty(appliesTo));
    }

    protected void appendToStringBuilder(StringBuilder sb) {
        for (int i = 0; i < this.properties.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.properties[i].toString());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ColumnDefinition{");
        this.appendToStringBuilder(sb);
        sb.append("}");
        return sb.toString();
    }

    public Object[] properties() {
        return this.properties;
    }
}

