/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.FieldMapper;
import org.simpleflatmapper.map.Mapper;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.PropertyWithGetter;
import org.simpleflatmapper.map.asm.MapperAsmFactory;
import org.simpleflatmapper.map.context.KeySourceGetter;
import org.simpleflatmapper.map.context.MappingContextFactoryBuilder;
import org.simpleflatmapper.map.mapper.ConstantTargetFieldMapperFactory;
import org.simpleflatmapper.map.mapper.ContextualMapper;
import org.simpleflatmapper.map.mapper.MapperImpl;
import org.simpleflatmapper.map.mapper.PropertyMapping;
import org.simpleflatmapper.map.mapper.PropertyMappingsBuilder;
import org.simpleflatmapper.map.property.ConstantValueProperty;
import org.simpleflatmapper.map.property.FieldMapperColumnDefinition;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.Instantiator;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.ScoredGetter;
import org.simpleflatmapper.reflect.asm.AsmFactory;
import org.simpleflatmapper.reflect.getter.ConstantGetter;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.ObjectPropertyMeta;
import org.simpleflatmapper.util.ErrorHelper;
import org.simpleflatmapper.util.ForEachCallBack;
import org.simpleflatmapper.util.TypeHelper;
import org.simpleflatmapper.util.UnaryFactory;

public abstract class AbstractConstantTargetMapperBuilder<S, T, K extends FieldKey<K>, B extends AbstractConstantTargetMapperBuilder<S, T, K, B>> {
    private final ReflectionService reflectionService;
    protected final MapperConfig<K, FieldMapperColumnDefinition<K>> mapperConfig;
    protected final PropertyMappingsBuilder<T, K, FieldMapperColumnDefinition<K>> propertyMappingsBuilder;
    protected final ConstantTargetFieldMapperFactory<S, K> fieldAppenderFactory;
    protected final ClassMeta<T> classMeta;
    private final Class<S> sourceClass;
    private int currentIndex = this.getStartingIndex();

    public AbstractConstantTargetMapperBuilder(ClassMeta<T> classMeta, Class<S> sourceClass, MapperConfig<K, FieldMapperColumnDefinition<K>> mapperConfig, ConstantTargetFieldMapperFactory<S, K> fieldAppenderFactory) {
        this.sourceClass = sourceClass;
        this.fieldAppenderFactory = fieldAppenderFactory;
        this.reflectionService = classMeta.getReflectionService();
        this.mapperConfig = mapperConfig;
        this.propertyMappingsBuilder = PropertyMappingsBuilder.of(classMeta, mapperConfig, PropertyWithGetter.INSTANCE);
        this.classMeta = classMeta;
    }

    public B addColumn(String column) {
        return this.addColumn((K)column, FieldMapperColumnDefinition.identity());
    }

    public B addColumn(String column, Object ... properties) {
        FieldMapperColumnDefinition columnDefinition = FieldMapperColumnDefinition.of(properties);
        return this.addColumn(this.newKey(column, this.currentIndex++, columnDefinition), columnDefinition);
    }

    public B addColumn(K key, Object ... properties) {
        return this.addColumn(key, (FieldMapperColumnDefinition)FieldMapperColumnDefinition.identity().add(properties));
    }

    public B addColumn(String column, FieldMapperColumnDefinition<K> columnDefinition) {
        return this.addColumn(this.newKey(column, this.currentIndex++, columnDefinition), columnDefinition);
    }

    public B addColumn(K key, FieldMapperColumnDefinition<K> columnDefinition) {
        FieldMapperColumnDefinition<K> composedDefinition = columnDefinition.compose(this.mapperConfig.columnDefinitions().getColumnDefinition(key));
        K mappedColumnKey = composedDefinition.rename(key);
        if (composedDefinition.has(ConstantValueProperty.class)) {
            ConstantValueProperty staticValueProperty = composedDefinition.lookFor(ConstantValueProperty.class);
            ObjectPropertyMeta meta = new ObjectPropertyMeta(((FieldKey)key).getName(), this.classMeta.getType(), this.reflectionService, staticValueProperty.getType(), ScoredGetter.of((Getter)new ConstantGetter(staticValueProperty.getValue()), (int)1), null);
            this.propertyMappingsBuilder.addProperty(key, columnDefinition, meta);
        } else {
            this.propertyMappingsBuilder.addProperty(mappedColumnKey, composedDefinition);
        }
        return (B)this;
    }

    public Mapper<T, S> mapper() {
        Mapper<T, S> mapper;
        final ArrayList<FieldMapper<FieldMapper, S>> mappers = new ArrayList<FieldMapper<FieldMapper, S>>();
        final MappingContextFactoryBuilder mappingContextFactoryBuilder = new MappingContextFactoryBuilder(new KeySourceGetter<K, T>(){

            @Override
            public Object getValue(K key, T source) throws Exception {
                throw new UnsupportedOperationException();
            }
        });
        this.propertyMappingsBuilder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>>>(){

            public void handle(PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>> pm) {
                AbstractConstantTargetMapperBuilder.this.preFieldProcess(mappers, pm);
                FieldMapper fieldMapper = AbstractConstantTargetMapperBuilder.this.fieldAppenderFactory.newFieldMapper(pm, mappingContextFactoryBuilder, AbstractConstantTargetMapperBuilder.this.mapperConfig.mapperBuilderErrorHandler());
                mappers.add(fieldMapper);
                AbstractConstantTargetMapperBuilder.this.postFieldProcess(mappers, pm);
            }
        });
        this.postMapperProcess(mappers);
        FieldMapper[] fields = mappers.toArray(new FieldMapper[0]);
        Instantiator<T, S> instantiator = this.getInstantiator();
        if (mappers.size() < 256) {
            try {
                mapper = ((MapperAsmFactory)this.reflectionService.getAsmFactory().registerOrCreate(MapperAsmFactory.class, (UnaryFactory)new UnaryFactory<AsmFactory, MapperAsmFactory>(){

                    public MapperAsmFactory newInstance(AsmFactory asmFactory) {
                        return new MapperAsmFactory(asmFactory);
                    }
                })).createMapper(this.getKeys(), fields, new FieldMapper[0], instantiator, TypeHelper.toClass((Type)this.classMeta.getType()), this.sourceClass);
            }
            catch (Throwable e) {
                if (this.mapperConfig.failOnAsm()) {
                    return (Mapper)ErrorHelper.rethrow((Throwable)e);
                }
                mapper = new MapperImpl<S, T>(fields, new FieldMapper[0], instantiator);
            }
        } else {
            mapper = new MapperImpl<T, S>(fields, new FieldMapper[0], instantiator);
        }
        return new ContextualMapper<T, S>(mapper, mappingContextFactoryBuilder.newFactory());
    }

    protected void postMapperProcess(List<FieldMapper<T, S>> mappers) {
    }

    protected void postFieldProcess(List<FieldMapper<T, S>> mappers, PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>> pm) {
    }

    protected void preFieldProcess(List<FieldMapper<T, S>> mappers, PropertyMapping<T, ?, K, FieldMapperColumnDefinition<K>> pm) {
    }

    protected int getStartingIndex() {
        return 0;
    }

    protected abstract Instantiator<T, S> getInstantiator();

    protected abstract K newKey(String var1, int var2, FieldMapperColumnDefinition<K> var3);

    private FieldKey<?>[] getKeys() {
        return this.propertyMappingsBuilder.getKeys().toArray(new FieldKey[0]);
    }
}

