/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.context.impl;

import java.util.Arrays;
import org.simpleflatmapper.map.BreakDetector;
import org.simpleflatmapper.map.MappingException;
import org.simpleflatmapper.map.context.KeysDefinition;

public class BreakDetectorImpl<S, K>
implements BreakDetector<S> {
    private final KeysDefinition<S, K> definition;
    private final BreakDetector<S> parent;
    private Object[] lastValues;
    private boolean isBroken = true;

    public BreakDetectorImpl(KeysDefinition<S, K> definition, BreakDetector<S> parent) {
        this.definition = definition;
        this.parent = parent;
    }

    @Override
    public void handle(S source) throws MappingException {
        if (this.definition.isEmpty()) {
            return;
        }
        Object[] newValues = this.definition.getValues(source);
        this.isBroken = this.parent != null && this.parent.isBroken() || this.lastValues == null || !Arrays.deepEquals(this.lastValues, newValues);
        this.lastValues = newValues;
    }

    @Override
    public boolean isBroken() {
        return this.isBroken;
    }

    @Override
    public void markAsBroken() {
        this.isBroken = true;
        this.lastValues = null;
    }
}

