/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.property;

import org.simpleflatmapper.map.impl.JoinUtils;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.SubPropertyMeta;
import org.simpleflatmapper.util.Asserts;
import org.simpleflatmapper.util.Predicate;

public class KeyProperty {
    private static final Predicate<PropertyMeta<?, ?>> DEFAULT_PREDICATE = new Predicate<PropertyMeta<?, ?>>(){

        public boolean test(PropertyMeta<?, ?> propertyMeta) {
            if (propertyMeta.isSubProperty()) {
                SubPropertyMeta subPropertyMeta = (SubPropertyMeta)propertyMeta;
                if (JoinUtils.isArrayElement(subPropertyMeta.getOwnerProperty())) {
                    return false;
                }
                PropertyMeta subProperty = subPropertyMeta.getSubProperty();
                return !JoinUtils.isArrayElement(subProperty) && this.test(subProperty);
            }
            return true;
        }
    };
    public static final KeyProperty DEFAULT = new KeyProperty(DEFAULT_PREDICATE);
    private final Predicate<PropertyMeta<?, ?>> appliesTo;

    public KeyProperty() {
        this(DEFAULT_PREDICATE);
    }

    public KeyProperty(Predicate<PropertyMeta<?, ?>> appliesTo) {
        this.appliesTo = (Predicate)Asserts.requireNonNull((String)"appliesTo", appliesTo);
    }

    public Predicate<PropertyMeta<?, ?>> getAppliesTo() {
        return this.appliesTo;
    }

    public String toString() {
        return "Key{" + this.appliesTo + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyProperty that = (KeyProperty)o;
        return this.appliesTo.equals(that.appliesTo);
    }

    public int hashCode() {
        return this.appliesTo.hashCode();
    }
}

