/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.context.impl;

import java.util.HashMap;
import org.simpleflatmapper.map.MappingException;
import org.simpleflatmapper.map.context.Key;
import org.simpleflatmapper.map.context.KeyDefinition;

public class BreakDetector<S> {
    private final KeyDefinition<S, ?> definition;
    private final HashMap<Key, Object> cache;
    private final BreakDetector<S>[] siblings;
    private final boolean root;
    private Key currentKey;

    public BreakDetector(KeyDefinition<S, ?> definition, BreakDetector<S>[] siblings) {
        this.definition = BreakDetector.emptyToNull(definition);
        this.siblings = siblings;
        this.root = definition.isRoot();
        this.cache = this.definition == null ? null : new HashMap();
    }

    private static <S> KeyDefinition<S, ?> emptyToNull(KeyDefinition<S, ?> definition) {
        if (definition != null && definition.isEmpty()) {
            return null;
        }
        return definition;
    }

    public boolean broke(S source) throws MappingException {
        if (this.definition == null) {
            return true;
        }
        boolean b = false;
        Key oldKey = this.currentKey;
        this.currentKey = this.definition.getValues(source);
        if (oldKey == null) {
            b = true;
        } else if (!oldKey.equals(this.currentKey)) {
            b = true;
            this.markChildrenHasBroken(this.root);
        }
        this.callBrokeOnChildren(source);
        return b;
    }

    private void callBrokeOnChildren(S source) {
        KeyDefinition<S, ?>[] children = this.definition.getChildren();
        if (children == null) {
            return;
        }
        for (KeyDefinition<S, ?> keyDefinition : children) {
            this.siblings[keyDefinition.getIndex()].broke(source);
        }
    }

    private void markChildrenHasBroken(boolean root) {
        KeyDefinition<S, ?>[] children = this.definition.getChildren();
        if (children == null) {
            return;
        }
        for (KeyDefinition<S, ?> keyDefinition : children) {
            this.siblings[keyDefinition.getIndex()].markAsBroken(root);
        }
    }

    public void setValue(Object value) {
        if (this.definition != null) {
            if (this.currentKey == null) {
                throw new IllegalStateException("Invalid state currentKey is null");
            }
            this.cache.put(this.currentKey, value);
        }
    }

    public Object getValue() {
        if (this.definition != null) {
            if (this.currentKey == null) {
                throw new IllegalStateException("Invalid state currentKey is null");
            }
            return this.cache.get(this.currentKey);
        }
        return null;
    }

    public void markAsBroken(boolean root) {
        if (this.definition != null) {
            this.currentKey = null;
            if (root) {
                this.cache.clear();
            }
            this.markChildrenHasBroken(root);
        }
    }
}

