/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.context.impl;

import org.simpleflatmapper.map.BreakDetector;
import org.simpleflatmapper.map.MappingContext;

public class BreakDetectorMappingContext<S>
extends MappingContext<S> {
    private final BreakDetector<S>[] originalOrderBreakDetectors;
    private final BreakDetector<S>[] processingDectectors;
    private final BreakDetector<S> rootDetector;
    private final MappingContext<S> delegateContext;
    private final Object[] currentValues;

    public BreakDetectorMappingContext(BreakDetector<S>[] originalOrderBreakDetectors, BreakDetector<S>[] processingDectectors, int rootDetector, MappingContext<S> delegateContext, Object[] currentValues) {
        this.originalOrderBreakDetectors = originalOrderBreakDetectors;
        this.processingDectectors = processingDectectors;
        this.delegateContext = delegateContext;
        this.currentValues = currentValues;
        this.rootDetector = rootDetector == -1 ? null : originalOrderBreakDetectors[rootDetector];
    }

    private BreakDetector<S> getBreakDetector(int i) {
        return this.originalOrderBreakDetectors != null ? this.originalOrderBreakDetectors[i] : null;
    }

    @Override
    public boolean broke(int i) {
        BreakDetector<S> breakDetector = this.getBreakDetector(i);
        return breakDetector == null || breakDetector.isBroken();
    }

    @Override
    public boolean rootBroke() {
        return this.rootDetector == null || this.rootDetector.isBroken();
    }

    @Override
    public void handle(S source) {
        if (this.processingDectectors == null) {
            return;
        }
        for (BreakDetector<S> bs : this.processingDectectors) {
            if (bs == null) continue;
            bs.handle(source);
        }
    }

    @Override
    public void markAsBroken() {
        if (this.processingDectectors == null) {
            return;
        }
        for (BreakDetector<S> bs : this.processingDectectors) {
            if (bs == null) continue;
            bs.markAsBroken();
        }
    }

    @Override
    public <T> T context(int i) {
        return this.delegateContext.context(i);
    }

    @Override
    public void setCurrentValue(int i, Object value) {
        this.currentValues[i] = value;
    }

    @Override
    public Object getCurrentValue(int i) {
        return this.currentValues[i];
    }
}

