/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.fieldmapper;

import org.simpleflatmapper.map.FieldMapper;
import org.simpleflatmapper.map.Mapper;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.util.Asserts;
import org.simpleflatmapper.util.BooleanProvider;
import org.simpleflatmapper.util.Predicate;

public final class MapperFieldMapper<S, T, P>
implements FieldMapper<S, T> {
    private final Mapper<S, P> mapper;
    private final Setter<? super T, ? super P> propertySetter;
    private final Getter<? super T, ? extends P> propertyGetter;
    private final Predicate<? super S> nullChecker;
    private final Getter<MappingContext<? super S>, BooleanProvider> breakDetectorProvider;

    public MapperFieldMapper(Mapper<S, P> mapper, Setter<? super T, ? super P> propertySetter, Getter<? super T, ? extends P> propertyGetter, Predicate<? super S> nullChecker, Getter<MappingContext<? super S>, BooleanProvider> breakDetectorProvider) {
        this.mapper = (Mapper)Asserts.requireNonNull((String)"jdbcMapper", mapper);
        this.propertySetter = (Setter)Asserts.requireNonNull((String)"propertySetter", propertySetter);
        this.propertyGetter = (Getter)Asserts.requireNonNull((String)"propertyGetter", propertyGetter);
        this.nullChecker = (Predicate)Asserts.requireNonNull((String)"nullChecker", nullChecker);
        this.breakDetectorProvider = (Getter)Asserts.requireNonNull((String)"breakDetectorProvider", breakDetectorProvider);
    }

    @Override
    public void mapTo(S source, T target, MappingContext<? super S> context) throws Exception {
        if (this.nullChecker.test(source)) {
            return;
        }
        boolean isBroken = ((BooleanProvider)this.breakDetectorProvider.get(context)).getBoolean();
        if (isBroken) {
            this.propertySetter.set(target, this.mapper.map((S)source, context));
        } else {
            Object value = this.propertyGetter.get(target);
            if (value != null) {
                this.mapper.mapTo((S)source, (P)value, context);
            }
        }
    }

    public String toString() {
        return "MapperFieldMapper{jdbcMapper=" + this.mapper + ", propertySetter=" + this.propertySetter + ", propertyGetter=" + this.propertyGetter + '}';
    }
}

