/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.mapper;

import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.FieldMapper;
import org.simpleflatmapper.map.Mapper;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.context.MappingContextFactoryBuilder;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.mapper.ConstantSourceMapperBuilder;
import org.simpleflatmapper.map.mapper.KeyFactory;
import org.simpleflatmapper.map.mapper.MapperSource;
import org.simpleflatmapper.map.property.FieldMapperColumnDefinition;
import org.simpleflatmapper.reflect.meta.ClassMeta;

public abstract class AbstractMapperBuilder<S, T, K extends FieldKey<K>, M, B extends AbstractMapperBuilder<S, T, K, M, B>> {
    private final ConstantSourceMapperBuilder<S, T, K> constantSourceMapperBuilder;
    protected final MapperConfig<K, FieldMapperColumnDefinition<K>> mapperConfig;
    protected final MappingContextFactoryBuilder<? super S, K> mappingContextFactoryBuilder;
    private final KeyFactory<K> keyFactory;
    private int calculatedIndex;

    public AbstractMapperBuilder(ClassMeta<T> classMeta, MappingContextFactoryBuilder<? super S, K> parentBuilder, MapperConfig<K, FieldMapperColumnDefinition<K>> mapperConfig, MapperSource<? super S, K> mapperSource, KeyFactory<K> keyFactory, int startIndex) {
        this.constantSourceMapperBuilder = new ConstantSourceMapperBuilder<S, T, K>(mapperSource, classMeta, mapperConfig, parentBuilder, keyFactory);
        this.keyFactory = keyFactory;
        this.mapperConfig = mapperConfig;
        this.mappingContextFactoryBuilder = parentBuilder;
        this.calculatedIndex = startIndex;
    }

    public final M mapper() {
        Mapper<S, T> mapper = this.constantSourceMapperBuilder.mapper();
        if (this.constantSourceMapperBuilder.hasJoin()) {
            return this.newJoinJdbcMapper(mapper);
        }
        return this.newStaticJdbcMapper(mapper);
    }

    public final B addKey(String column) {
        return this.addMapping(column, this.calculatedIndex++, FieldMapperColumnDefinition.key());
    }

    public final B addMapping(String column) {
        return this.addMapping(column, this.calculatedIndex++);
    }

    public final B addMapping(String column, FieldMapperColumnDefinition<K> columnDefinition) {
        return this.addMapping(column, this.calculatedIndex++, columnDefinition);
    }

    public final B addMapping(String column, Object ... properties) {
        return this.addMapping(column, this.calculatedIndex++, properties);
    }

    public final B addMapping(String column, int index) {
        return this.addMapping(this.key(column, index), new Object[0]);
    }

    public final B addMapping(String column, int index, FieldMapperColumnDefinition<K> columnDefinition) {
        return this.addMapping(this.key(column, index), columnDefinition);
    }

    public final B addMapping(String column, int index, Object ... properties) {
        return this.addMapping(this.key(column, index), properties);
    }

    public final B addMapper(FieldMapper<S, T> mapper) {
        this.constantSourceMapperBuilder.addMapper(mapper);
        return (B)this;
    }

    public final B addMapping(K key, FieldMapperColumnDefinition<K> columnDefinition) {
        this.constantSourceMapperBuilder.addMapping(key, columnDefinition);
        return (B)this;
    }

    public final B addMapping(K key, Object ... properties) {
        if (properties.length == 1 && properties[0] instanceof ColumnDefinition) {
            this.constantSourceMapperBuilder.addMapping(key, (FieldMapperColumnDefinition)properties[0]);
            return (B)this;
        }
        this.constantSourceMapperBuilder.addMapping(key, FieldMapperColumnDefinition.of(properties));
        return (B)this;
    }

    private final K key(String column, int index) {
        return this.keyFactory.newKey(column, index);
    }

    protected abstract M newJoinJdbcMapper(Mapper<S, T> var1);

    protected abstract M newStaticJdbcMapper(Mapper<S, T> var1);
}

