/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jooq;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.jooq.Field;
import org.jooq.ResultQuery;
import org.jooq.Select;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.UniqueKey;
import org.jooq.exception.DataAccessException;
import org.simpleflatmapper.jooq.JooqFieldKey;
import org.simpleflatmapper.jooq.JooqJdbcMapperBuilder;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.MappingException;
import org.simpleflatmapper.map.SetRowMapper;
import org.simpleflatmapper.map.mapper.MapperCache;
import org.simpleflatmapper.map.mapper.MapperKey;
import org.simpleflatmapper.map.mapper.MapperKeyComparator;
import org.simpleflatmapper.map.property.KeyProperty;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.util.AutoCloseableEnumerable;
import org.simpleflatmapper.util.AutoCloseableIterator;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.Closer;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.Enumerable;

public final class SelectQueryMapper<T> {
    private final MapperCache<JooqFieldKey, SetRowMapper<ResultSet, ResultSet, T, SQLException>> mapperCache = new MapperCache((MapperKeyComparator)JdbcColumnKeyMapperKeyComparator.INSTANCE);
    private final ClassMeta<T> classMeta;
    private final MapperConfig<JooqFieldKey, ResultSet> mapperConfig;

    protected SelectQueryMapper(ClassMeta<T> classMeta, MapperConfig<JooqFieldKey, ResultSet> mapperConfig) {
        this.classMeta = classMeta;
        this.mapperConfig = mapperConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <SET extends TableLike & ResultQuery> List<T> asList(SET source) throws MappingException {
        SetRowMapper<ResultSet, ResultSet, T, SQLException> mapper = this.getMapper(source);
        try {
            final ArrayList list = new ArrayList();
            try (ResultSet rs = ((ResultQuery)source).fetchResultSet();){
                mapper.forEach((Object)rs, (CheckedConsumer)new Consumer<T>(){

                    public void accept(T t) {
                        list.add(t);
                    }
                });
            }
            return list;
        }
        catch (SQLException e) {
            throw new DataAccessException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <SET extends TableLike & ResultQuery, H extends CheckedConsumer<? super T>> H forEach(SET source, H handler) throws MappingException {
        SetRowMapper<ResultSet, ResultSet, T, SQLException> mapper = this.getMapper(source);
        try (ResultSet rs = ((ResultQuery)source).fetchResultSet();){
            mapper.forEach((Object)rs, handler);
        }
        catch (SQLException e) {
            throw new DataAccessException(e.getMessage(), (Throwable)e);
        }
        return handler;
    }

    public <SET extends TableLike & ResultQuery> AutoCloseableIterator<T> iterator(SET source) throws MappingException {
        SetRowMapper<ResultSet, ResultSet, T, SQLException> mapper = this.getMapper(source);
        try {
            ResultSet rs = ((ResultQuery)source).fetchResultSet();
            Iterator iterator = mapper.iterator((Object)rs);
            return new AutoCloseableIterator(iterator, this.closer(rs));
        }
        catch (SQLException e) {
            throw new DataAccessException(e.getMessage(), (Throwable)e);
        }
    }

    public <SET extends TableLike & ResultQuery> Stream<T> stream(SET source) throws MappingException {
        SetRowMapper<ResultSet, ResultSet, T, SQLException> mapper = this.getMapper(source);
        try {
            final ResultSet rs = ((ResultQuery)source).fetchResultSet();
            Stream enumerable = mapper.stream((Object)rs);
            return (Stream)enumerable.onClose(new Runnable(){

                @Override
                public void run() {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        throw new DataAccessException(e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
        catch (SQLException e) {
            throw new DataAccessException(e.getMessage(), (Throwable)e);
        }
    }

    public <SET extends TableLike & ResultQuery> AutoCloseableEnumerable<T> enumerate(SET source) throws MappingException {
        SetRowMapper<ResultSet, ResultSet, T, SQLException> mapper = this.getMapper(source);
        try {
            ResultSet rs = ((ResultQuery)source).fetchResultSet();
            Enumerable enumerable = mapper.enumerate((Object)rs);
            return new AutoCloseableEnumerable(enumerable, this.closer(rs));
        }
        catch (SQLException e) {
            throw new DataAccessException(e.getMessage(), (Throwable)e);
        }
    }

    private <SET extends TableLike & ResultQuery> SetRowMapper<ResultSet, ResultSet, T, SQLException> getMapper(SET source) {
        Field[] fields = this.getFields(source);
        FieldKey[] keys = new JooqFieldKey[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            keys[i] = new JooqFieldKey(fields[i], i);
        }
        MapperKey mapperKey = new MapperKey(keys);
        SetRowMapper<ResultSet, ResultSet, T, SQLException> mapper = (SetRowMapper<ResultSet, ResultSet, T, SQLException>)this.mapperCache.get(mapperKey);
        if (mapper == null) {
            mapper = this.buildMapper(fields);
            this.mapperCache.add(mapperKey, mapper);
        }
        return mapper;
    }

    private <SET extends TableLike & ResultQuery> Field[] getFields(SET source) {
        if (source instanceof Select) {
            List select = ((Select)source).getSelect();
            return select.toArray(new Field[0]);
        }
        return source.fields();
    }

    private SetRowMapper<ResultSet, ResultSet, T, SQLException> buildMapper(Field[] fields) {
        JooqJdbcMapperBuilder<T> mapperBuilder = new JooqJdbcMapperBuilder<T>(this.classMeta, this.mapperConfig);
        for (int i = 0; i < fields.length; ++i) {
            Object[] objectArray;
            Field field = fields[i];
            if (this.isKey(field)) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = KeyProperty.DEFAULT;
            } else {
                objectArray = new Object[]{};
            }
            Object[] properties = objectArray;
            JooqFieldKey key = new JooqFieldKey(field, i + 1);
            mapperBuilder.addMapping(key, properties);
        }
        return mapperBuilder.mapper();
    }

    private boolean isKey(Field<?> field) {
        TableField tf;
        List keys;
        if (field instanceof TableField && (keys = (tf = (TableField)field).getTable().getKeys()) != null) {
            for (UniqueKey key : keys) {
                if (!key.getFields().contains(field)) continue;
                return true;
            }
        }
        return false;
    }

    private Closer closer(final ResultSet rs) {
        return new Closer(){

            public void close() {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    throw new DataAccessException(e.getMessage(), (Throwable)e);
                }
            }
        };
    }

    private static final class JdbcColumnKeyMapperKeyComparator
    extends MapperKeyComparator<JooqFieldKey> {
        public static final JdbcColumnKeyMapperKeyComparator INSTANCE = new JdbcColumnKeyMapperKeyComparator();

        private JdbcColumnKeyMapperKeyComparator() {
        }

        public int compare(MapperKey<JooqFieldKey> m1, MapperKey<JooqFieldKey> m2) {
            JooqFieldKey[] keys2;
            JooqFieldKey[] keys1 = (JooqFieldKey[])m1.getColumns();
            int d = keys1.length - (keys2 = (JooqFieldKey[])m2.getColumns()).length;
            if (d != 0) {
                return d;
            }
            return this.compareKeys(keys1, keys2);
        }

        private int compareKeys(JooqFieldKey[] keys1, JooqFieldKey[] keys2) {
            for (int i = 0; i < keys1.length; ++i) {
                int d = this.compare(keys1[i], keys2[i]);
                if (d == 0) continue;
                return d;
            }
            return 0;
        }

        protected int compare(JooqFieldKey k1, JooqFieldKey k2) {
            int d = k1.getIndex() - k2.getIndex();
            if (d != 0) {
                return d;
            }
            d = k1.getField().getName().compareTo(k2.getField().getName());
            return d;
        }
    }
}

