/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jooq;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.RecordMapper;
import org.jooq.RecordMapperProvider;
import org.jooq.RecordType;
import org.simpleflatmapper.jooq.JooqFieldKey;
import org.simpleflatmapper.jooq.JooqMapperBuilder;
import org.simpleflatmapper.jooq.JooqMappingContextFactoryBuilder;
import org.simpleflatmapper.jooq.JooqRecordMapperWrapper;
import org.simpleflatmapper.jooq.TargetColumnsMapperKey;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.SourceMapper;
import org.simpleflatmapper.map.context.MappingContextFactory;
import org.simpleflatmapper.reflect.ReflectionService;

public class SfmRecordMapperProvider
implements RecordMapperProvider {
    private final ConcurrentMap<TargetColumnsMapperKey, MapperAndContext> mapperCache = new ConcurrentHashMap<TargetColumnsMapperKey, MapperAndContext>();
    private final MapperConfig<JooqFieldKey> mapperConfig;
    private final ReflectionService reflectionService;

    public SfmRecordMapperProvider() {
        this((MapperConfig<JooqFieldKey>)MapperConfig.fieldMapperConfig(), ReflectionService.newInstance());
    }

    public SfmRecordMapperProvider(MapperConfig<JooqFieldKey> mapperConfig, ReflectionService reflectionService) {
        this.mapperConfig = mapperConfig;
        this.reflectionService = reflectionService;
    }

    public <R extends Record, E> RecordMapper<R, E> provide(RecordType<R> recordType, Class<? extends E> type) {
        MappingContextFactory<Record> mappingContextFactory;
        SourceMapper mapper;
        TargetColumnsMapperKey key = this.getMapperKey(recordType, type);
        MapperAndContext mc = (MapperAndContext)this.mapperCache.get(key);
        if (mc == null) {
            JooqMapperBuilder mapperBuilder = new JooqMapperBuilder(this.reflectionService.getClassMeta(type), new JooqMappingContextFactoryBuilder<Record>(), this.mapperConfig);
            int i = 0;
            for (Field field : recordType.fields()) {
                mapperBuilder.addField(new JooqFieldKey(field, i++));
            }
            mapper = mapperBuilder.mapper();
            mappingContextFactory = mapperBuilder.contextFactory();
            this.mapperCache.putIfAbsent(key, new MapperAndContext(mapper, mappingContextFactory));
        } else {
            mapper = mc.mapper;
            mappingContextFactory = mc.mappingContextFactory;
        }
        return new JooqRecordMapperWrapper(mapper, (MappingContextFactory<? super Record>)mappingContextFactory);
    }

    private <R extends Record> TargetColumnsMapperKey getMapperKey(RecordType<R> recordType, Class<?> type) {
        String[] columns = new String[recordType.size()];
        int i = 0;
        for (Field field : recordType.fields()) {
            columns[i++] = field.getName();
        }
        return new TargetColumnsMapperKey(type, columns);
    }

    private class MapperAndContext {
        private final SourceMapper<Record, ?> mapper;
        private final MappingContextFactory<? super Record> mappingContextFactory;

        private MapperAndContext(SourceMapper<Record, ?> mapper, MappingContextFactory<? super Record> mappingContextFactory) {
            this.mapper = mapper;
            this.mappingContextFactory = mappingContextFactory;
        }
    }
}

