/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jooq.conv;

import java.lang.reflect.Type;
import java.util.List;
import org.sfm.jdbc.JdbcColumnKey;
import org.sfm.jdbc.ResultSetGetterFactory;
import org.sfm.jooq.conv.ArrayConverter;
import org.sfm.jooq.conv.ArrayToListConverter;
import org.sfm.map.column.FieldMapperColumnDefinition;
import org.sfm.map.mapper.ColumnDefinition;
import org.sfm.reflect.Getter;
import org.sfm.reflect.TypeHelper;
import org.sfm.utils.conv.Converter;

public class JooqConverterFactory {
    public static <P, F> Converter<F, P> getConverter(Class<F> inType, Class<P> outType) {
        return JooqConverterFactory.getConverter(inType, outType);
    }

    public static <P, F> Converter<F, P> getConverter(Class<F> inType, Type outType) {
        if (TypeHelper.isArray((Type)outType)) {
            return JooqConverterFactory.newArrayConverter(TypeHelper.getComponentTypeOfListOrArray((Type)outType));
        }
        if (TypeHelper.isAssignable(List.class, (Type)outType)) {
            return JooqConverterFactory.newArrayToListConverter(TypeHelper.getComponentTypeOfListOrArray((Type)outType));
        }
        return null;
    }

    private static <F, P, E> Converter<F, P> newArrayConverter(Type eltType) {
        FieldMapperColumnDefinition identity = FieldMapperColumnDefinition.identity();
        Getter elementGetter = new ResultSetGetterFactory().newGetter(eltType, new JdbcColumnKey("elt", 2), (ColumnDefinition)identity);
        if (elementGetter == null) {
            return null;
        }
        return new ArrayConverter(TypeHelper.toClass((Type)eltType), elementGetter);
    }

    private static <F, P, E> Converter<F, P> newArrayToListConverter(Type eltType) {
        FieldMapperColumnDefinition identity = FieldMapperColumnDefinition.identity();
        Getter elementGetter = new ResultSetGetterFactory().newGetter(eltType, new JdbcColumnKey("elt", 2), (ColumnDefinition)identity);
        if (elementGetter == null) {
            return null;
        }
        return new ArrayToListConverter(elementGetter);
    }
}

