/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.jooq;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jooq.Field;
import org.jooq.Record;
import org.jooq.RecordMapper;
import org.jooq.RecordMapperProvider;
import org.jooq.RecordType;
import org.sfm.jooq.JooqFieldKey;
import org.sfm.jooq.JooqMapperBuilder;
import org.sfm.jooq.JooqRecordMapperWrapper;
import org.sfm.jooq.TargetColumnsMapperKey;
import org.sfm.map.Mapper;

public class SfmRecordMapperProvider
implements RecordMapperProvider {
    private final ConcurrentMap<TargetColumnsMapperKey, Mapper<Record, ?>> mapperCache = new ConcurrentHashMap();

    public <R extends Record, E> RecordMapper<R, E> provide(RecordType<R> recordType, Class<? extends E> type) {
        TargetColumnsMapperKey key = this.getMapperKey(recordType, type);
        Mapper mapper = (Mapper)this.mapperCache.get(key);
        if (mapper == null) {
            JooqMapperBuilder mapperBuilder = new JooqMapperBuilder(type);
            int i = 0;
            for (Field field : recordType.fields()) {
                mapperBuilder.addField(new JooqFieldKey(field, i++));
            }
            mapper = mapperBuilder.mapper();
            this.mapperCache.putIfAbsent(key, mapper);
        }
        return new JooqRecordMapperWrapper(mapper);
    }

    private <R extends Record> TargetColumnsMapperKey getMapperKey(RecordType<R> recordType, Class<?> type) {
        String[] columns = new String[recordType.size()];
        int i = 0;
        for (Field field : recordType.fields()) {
            columns[i++] = field.getName();
        }
        return new TargetColumnsMapperKey(type, columns);
    }
}

