/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbi3;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;
import org.simpleflatmapper.jdbc.DynamicJdbcMapper;
import org.simpleflatmapper.jdbi3.StaticRowMapper;

public class DynamicRowMapper<T>
implements RowMapper<T> {
    private final DynamicJdbcMapper<T> dynamicMapper;

    public DynamicRowMapper(DynamicJdbcMapper<T> dynamicMapper) {
        this.dynamicMapper = dynamicMapper;
    }

    public T map(ResultSet resultSet, StatementContext statementContext) throws SQLException {
        return (T)this.dynamicMapper.map(resultSet);
    }

    public RowMapper<T> specialize(ResultSet rs, StatementContext ctx) throws SQLException {
        return new StaticRowMapper(this.dynamicMapper.getMapper(rs.getMetaData()));
    }
}

