/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbi;

import java.sql.ResultSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.simpleflatmapper.jdbc.DynamicJdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbi.DefaultSfmResultSetMapper;
import org.simpleflatmapper.jdbi.DynamicSfmResultSetMapper;
import org.simpleflatmapper.map.SourceMapper;
import org.simpleflatmapper.util.BiPredicate;
import org.simpleflatmapper.util.UnaryFactory;
import org.skife.jdbi.v2.ResultSetMapperFactory;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class SfmResultSetMapperFactory
implements ResultSetMapperFactory {
    private static final UnaryFactory<Class<?>, SourceMapper<ResultSet, ?>> DEFAULT_FACTORY = new UnaryFactory<Class<?>, SourceMapper<ResultSet, ?>>(){

        public SourceMapper<ResultSet, ?> newInstance(Class<?> aClass) {
            return JdbcMapperFactory.newInstance().newMapper(aClass);
        }
    };
    private static final BiPredicate<Class<?>, StatementContext> DEFAULT_ACCEPT_PREDICATE = new BiPredicate<Class<?>, StatementContext>(){

        public boolean test(Class<?> aClass, StatementContext statementContext) {
            return true;
        }
    };
    private final UnaryFactory<Class<?>, SourceMapper<ResultSet, ?>> mapperFactory;
    private final ConcurrentMap<Class<?>, ResultSetMapper<?>> cache = new ConcurrentHashMap();
    private final BiPredicate<Class<?>, StatementContext> acceptsPredicate;

    public SfmResultSetMapperFactory() {
        this(DEFAULT_FACTORY);
    }

    public SfmResultSetMapperFactory(UnaryFactory<Class<?>, SourceMapper<ResultSet, ?>> mapperFactory) {
        this(DEFAULT_ACCEPT_PREDICATE, mapperFactory);
    }

    public SfmResultSetMapperFactory(BiPredicate<Class<?>, StatementContext> acceptsPredicate, UnaryFactory<Class<?>, SourceMapper<ResultSet, ?>> mapperFactory) {
        this.mapperFactory = mapperFactory;
        this.acceptsPredicate = acceptsPredicate;
    }

    public boolean accepts(Class aClass, StatementContext statementContext) {
        return this.acceptsPredicate.test((Object)aClass, (Object)statementContext);
    }

    public ResultSetMapper mapperFor(Class aClass, StatementContext statementContext) {
        SourceMapper resultSetMapper;
        ResultSetMapper cachedMapper;
        ResultSetMapper mapper = (ResultSetMapper)this.cache.get(aClass);
        if (mapper == null && (cachedMapper = this.cache.putIfAbsent(aClass, mapper = this.toResultSetMapper(resultSetMapper = (SourceMapper)this.mapperFactory.newInstance((Object)aClass)))) != null) {
            mapper = cachedMapper;
        }
        return mapper;
    }

    private <T> ResultSetMapper<T> toResultSetMapper(SourceMapper<ResultSet, T> resultSetMapper) {
        Object mapper = resultSetMapper instanceof DynamicJdbcMapper ? new DynamicSfmResultSetMapper((DynamicJdbcMapper)resultSetMapper) : new DefaultSfmResultSetMapper<T>(resultSetMapper);
        return mapper;
    }
}

