/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc;

import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import org.simpleflatmapper.jdbc.ConnectedSelectQuery;
import org.simpleflatmapper.jdbc.Crud;
import org.simpleflatmapper.jdbc.SQLFunction;
import org.simpleflatmapper.jdbc.SelectQuery;
import org.simpleflatmapper.jdbc.TransactionTemplate;
import org.simpleflatmapper.util.CheckedConsumer;

public class ConnectedCrud<T, K> {
    private final TransactionTemplate transactionTemplate;
    private final Crud<T, K> delegate;

    public ConnectedCrud(TransactionTemplate transactionTemplate, Crud<T, K> delegate) {
        this.transactionTemplate = transactionTemplate;
        this.delegate = delegate;
    }

    public void create(final T value) throws SQLException {
        this.transactionTemplate.doInTransaction(new SQLFunction<Connection, Object>(){

            @Override
            public Object apply(Connection connection) throws SQLException {
                ConnectedCrud.this.delegate.create(connection, value);
                return null;
            }
        });
    }

    public void create(final Collection<T> values) throws SQLException {
        this.transactionTemplate.doInTransaction(new SQLFunction<Connection, Object>(){

            @Override
            public Object apply(Connection connection) throws SQLException {
                ConnectedCrud.this.delegate.create(connection, values);
                return null;
            }
        });
    }

    public <RH extends CheckedConsumer<? super K>> RH create(final T value, final RH keyConsumer) throws SQLException {
        this.transactionTemplate.doInTransaction(new SQLFunction<Connection, Object>(){

            @Override
            public Object apply(Connection connection) throws SQLException {
                ConnectedCrud.this.delegate.create(connection, value, keyConsumer);
                return null;
            }
        });
        return keyConsumer;
    }

    public <RH extends CheckedConsumer<? super K>> RH create(final Collection<T> values, final RH keyConsumer) throws SQLException {
        this.transactionTemplate.doInTransaction(new SQLFunction<Connection, Object>(){

            @Override
            public Object apply(Connection connection) throws SQLException {
                ConnectedCrud.this.delegate.create(connection, values, keyConsumer);
                return null;
            }
        });
        return keyConsumer;
    }

    public T read(final K key) throws SQLException {
        return (T)this.transactionTemplate.doInTransaction(new SQLFunction<Connection, T>(){

            @Override
            public T apply(Connection connection) throws SQLException {
                return ConnectedCrud.this.delegate.read(connection, key);
            }
        });
    }

    public <RH extends CheckedConsumer<? super T>> RH read(final Collection<K> keys, final RH consumer) throws SQLException {
        this.transactionTemplate.doInTransaction(new SQLFunction<Connection, Object>(){

            @Override
            public Object apply(Connection connection) throws SQLException {
                ConnectedCrud.this.delegate.read(connection, keys, consumer);
                return null;
            }
        });
        return consumer;
    }

    public void update(final T value) throws SQLException {
        this.transactionTemplate.doInTransaction(new SQLFunction<Connection, Object>(){

            @Override
            public Object apply(Connection connection) throws SQLException {
                ConnectedCrud.this.delegate.update(connection, value);
                return null;
            }
        });
    }

    public void update(final Collection<T> values) throws SQLException {
        this.transactionTemplate.doInTransaction(new SQLFunction<Connection, Object>(){

            @Override
            public Object apply(Connection connection) throws SQLException {
                ConnectedCrud.this.delegate.update(connection, values);
                return null;
            }
        });
    }

    public void delete(final K key) throws SQLException {
        this.transactionTemplate.doInTransaction(new SQLFunction<Connection, Object>(){

            @Override
            public Object apply(Connection connection) throws SQLException {
                ConnectedCrud.this.delegate.delete(connection, key);
                return null;
            }
        });
    }

    public void delete(final Collection<K> keys) throws SQLException {
        this.transactionTemplate.doInTransaction(new SQLFunction<Connection, Object>(){

            @Override
            public Object apply(Connection connection) throws SQLException {
                ConnectedCrud.this.delegate.delete(connection, keys);
                return null;
            }
        });
    }

    public void createOrUpdate(final T value) throws SQLException {
        this.transactionTemplate.doInTransaction(new SQLFunction<Connection, Object>(){

            @Override
            public Object apply(Connection connection) throws SQLException {
                ConnectedCrud.this.delegate.createOrUpdate(connection, value);
                return null;
            }
        });
    }

    public void createOrUpdate(final Collection<T> values) throws SQLException {
        this.transactionTemplate.doInTransaction(new SQLFunction<Connection, Object>(){

            @Override
            public Object apply(Connection connection) throws SQLException {
                ConnectedCrud.this.delegate.createOrUpdate(connection, values);
                return null;
            }
        });
    }

    public <RH extends CheckedConsumer<? super K>> RH createOrUpdate(final T value, final RH keyConsumer) throws SQLException {
        this.transactionTemplate.doInTransaction(new SQLFunction<Connection, Object>(){

            @Override
            public Object apply(Connection connection) throws SQLException {
                ConnectedCrud.this.delegate.createOrUpdate(connection, value, keyConsumer);
                return null;
            }
        });
        return keyConsumer;
    }

    public <RH extends CheckedConsumer<? super K>> RH createOrUpdate(final Collection<T> values, final RH keyConsumer) throws SQLException {
        this.transactionTemplate.doInTransaction(new SQLFunction<Connection, Object>(){

            @Override
            public Object apply(Connection connection) throws SQLException {
                ConnectedCrud.this.delegate.createOrUpdate(connection, values, keyConsumer);
                return null;
            }
        });
        return keyConsumer;
    }

    public Crud<T, K> crud() {
        return this.delegate;
    }

    public <P> ConnectedSelectQuery<T, P> where(String whereClause, Type paramClass) {
        SelectQuery selectQuery = this.delegate.where(whereClause, paramClass);
        return new ConnectedSelectQuery(selectQuery, this.transactionTemplate);
    }
}

