/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.impl;

import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.QueryPreparer;
import org.simpleflatmapper.jdbc.impl.CrudMeta;
import org.simpleflatmapper.jdbc.impl.SelectQueryImpl;
import org.simpleflatmapper.jdbc.named.NamedSqlQuery;
import org.simpleflatmapper.util.TypeHelper;

public class SelectQueryWhereFactory<T> {
    private final CrudMeta meta;
    private final JdbcMapperFactory jdbcMapperFactory;
    private final JdbcMapper<T> jdbcMapper;
    private final ConcurrentMap<SelectQueryKey, SelectQueryImpl<T, ?>> cache = new ConcurrentHashMap();

    public SelectQueryWhereFactory(CrudMeta meta, JdbcMapper<T> jdbcMapper, JdbcMapperFactory jdbcMapperFactory) {
        this.meta = meta;
        this.jdbcMapper = jdbcMapper;
        this.jdbcMapperFactory = jdbcMapperFactory;
    }

    public <P> SelectQueryImpl<T, P> where(String whereClause, Type paramClass) {
        SelectQueryImpl<T, P> newSelectQuery;
        SelectQueryKey key = new SelectQueryKey(whereClause, paramClass);
        SelectQueryImpl<T, P> selectQuery = (SelectQueryImpl<T, P>)this.cache.get(key);
        if (selectQuery == null && (selectQuery = this.cache.putIfAbsent(key, newSelectQuery = this.newSelectQuery(whereClause, paramClass))) == null) {
            selectQuery = newSelectQuery;
        }
        return selectQuery;
    }

    private <P> SelectQueryImpl<T, P> newSelectQuery(String whereClause, Type paramClass) {
        String query = this.sqlQuery(whereClause);
        JdbcMapperFactory jdbcMapperFactory = this.jdbcMapperFactory;
        if (TypeHelper.isArray((Type)paramClass) || TypeHelper.isAssignable(List.class, (Type)paramClass)) {
            jdbcMapperFactory = JdbcMapperFactory.newInstance(jdbcMapperFactory);
            jdbcMapperFactory.enableSpeculativeArrayIndexResolution();
        }
        QueryPreparer queryPreparer = jdbcMapperFactory.from(paramClass).to(NamedSqlQuery.parse(query));
        return new SelectQueryImpl(queryPreparer, this.jdbcMapper);
    }

    private String sqlQuery(String whereClause) {
        StringBuilder sb = new StringBuilder("SELECT * FROM ");
        this.meta.appendTableName(sb);
        sb.append(" WHERE ");
        sb.append(whereClause);
        return sb.toString();
    }

    private static class SelectQueryKey {
        private final String query;
        private final Type type;

        private SelectQueryKey(String query, Type type) {
            this.query = query;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SelectQueryKey that = (SelectQueryKey)o;
            if (!this.query.equals(that.query)) {
                return false;
            }
            return this.type.equals(that.type);
        }

        public int hashCode() {
            int result = this.query.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }
    }
}

