/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc;

import java.lang.reflect.Type;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import org.simpleflatmapper.converter.ContextFactory;
import org.simpleflatmapper.converter.ContextFactoryBuilder;
import org.simpleflatmapper.jdbc.JdbcColumnKey;
import org.simpleflatmapper.jdbc.MultiIndexFieldMapper;
import org.simpleflatmapper.jdbc.QueryPreparer;
import org.simpleflatmapper.jdbc.SqlTypeColumnProperty;
import org.simpleflatmapper.jdbc.impl.CollectionIndexFieldMapper;
import org.simpleflatmapper.jdbc.impl.MapperQueryPreparer;
import org.simpleflatmapper.jdbc.impl.MultiIndexQueryPreparer;
import org.simpleflatmapper.jdbc.impl.PreparedStatementIndexedSetterFactory;
import org.simpleflatmapper.jdbc.impl.SingleIndexFieldMapper;
import org.simpleflatmapper.jdbc.impl.setter.PreparedStatementIndexSetter;
import org.simpleflatmapper.jdbc.impl.setter.PreparedStatementIndexSetterOnGetter;
import org.simpleflatmapper.jdbc.named.NamedSqlQuery;
import org.simpleflatmapper.jdbc.property.IndexedSetterFactoryProperty;
import org.simpleflatmapper.jdbc.property.IndexedSetterProperty;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.context.MappingContextFactoryBuilder;
import org.simpleflatmapper.map.mapper.AbstractConstantTargetMapperBuilder;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.mapper.ConstantTargetFieldMapperFactory;
import org.simpleflatmapper.map.mapper.PropertyMapping;
import org.simpleflatmapper.map.property.FieldMapperColumnDefinition;
import org.simpleflatmapper.map.setter.ContextualIndexedSetter;
import org.simpleflatmapper.map.setter.ContextualIndexedSetterAdapter;
import org.simpleflatmapper.map.setter.ContextualIndexedSetterFactory;
import org.simpleflatmapper.reflect.BiInstantiator;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.IndexedSetter;
import org.simpleflatmapper.reflect.IndexedSetterFactory;
import org.simpleflatmapper.reflect.TypeAffinity;
import org.simpleflatmapper.reflect.getter.ArrayIndexedGetter;
import org.simpleflatmapper.reflect.getter.ArraySizeGetter;
import org.simpleflatmapper.reflect.getter.ListIndexedGetter;
import org.simpleflatmapper.reflect.getter.ListSizeGetter;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.DefaultPropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.ObjectClassMeta;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.util.ConstantPredicate;
import org.simpleflatmapper.util.ErrorDoc;
import org.simpleflatmapper.util.ForEachCallBack;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.TypeHelper;

public class PreparedStatementMapperBuilder<T>
extends AbstractConstantTargetMapperBuilder<PreparedStatement, T, JdbcColumnKey, PreparedStatementMapperBuilder<T>> {
    private ContextualIndexedSetterFactory<PreparedStatement, PropertyMapping<?, ?, JdbcColumnKey>> indexedSetterFactory = PreparedStatementIndexedSetterFactory.INSTANCE;

    public PreparedStatementMapperBuilder(ClassMeta<T> classMeta, MapperConfig<JdbcColumnKey, ?> mapperConfig, ConstantTargetFieldMapperFactory<PreparedStatement, JdbcColumnKey> preparedStatementFieldMapperFactory) {
        super(classMeta, PreparedStatement.class, mapperConfig, preparedStatementFieldMapperFactory);
    }

    private PreparedStatementMapperBuilder(PreparedStatementMapperBuilder<T> builder) {
        this(builder.classMeta, builder.mapperConfig, (ConstantTargetFieldMapperFactory<PreparedStatement, JdbcColumnKey>)builder.fieldAppenderFactory);
    }

    protected BiInstantiator<T, MappingContext<? super T>, PreparedStatement> getInstantiator() {
        return new NullInstantiator();
    }

    protected JdbcColumnKey newKey(String column, int i, FieldMapperColumnDefinition<JdbcColumnKey> columnDefinition) {
        JdbcColumnKey key = new JdbcColumnKey(column, i);
        SqlTypeColumnProperty typeColumnProperty = (SqlTypeColumnProperty)columnDefinition.lookFor(SqlTypeColumnProperty.class);
        if (typeColumnProperty == null) {
            ColumnDefinition globalDef = this.mapperConfig.columnDefinitions().getColumnDefinition((FieldKey)key);
            typeColumnProperty = (SqlTypeColumnProperty)globalDef.lookFor(SqlTypeColumnProperty.class);
        }
        if (typeColumnProperty != null) {
            return new JdbcColumnKey(key.getName(), key.getIndex(), typeColumnProperty.getSqlType(), key);
        }
        return key;
    }

    protected int getStartingIndex() {
        return 1;
    }

    public QueryPreparer<T> to(NamedSqlQuery query) {
        return this.to(query, null);
    }

    public QueryPreparer<T> to(NamedSqlQuery query, String[] generatedKeys) {
        PreparedStatementMapperBuilder<T> builder = new PreparedStatementMapperBuilder<T>(this);
        return super.preparedStatementMapper(query, generatedKeys);
    }

    private QueryPreparer<T> preparedStatementMapper(NamedSqlQuery query, String[] generatedKeys) {
        for (int i = 0; i < query.getParametersSize(); ++i) {
            this.addColumn(query.getParameter(i).getName());
        }
        boolean hasMultiIndex = (this.propertyMappingsBuilder.forEachProperties((ForEachCallBack)new ForEachCallBack<PropertyMapping<T, ?, JdbcColumnKey>>(){
            boolean hasMultiIndex;

            public void handle(PropertyMapping<T, ?, JdbcColumnKey> pm) {
                this.hasMultiIndex |= PreparedStatementMapperBuilder.this.isMultiIndex(pm.getPropertyMeta());
            }
        })).hasMultiIndex;
        if (hasMultiIndex) {
            MappingContextFactoryBuilder mappingContextFactoryBuilder = new MappingContextFactoryBuilder(this.keySourceGetter());
            return new MultiIndexQueryPreparer<T>(query, this.buildIndexFieldMappers((ContextFactoryBuilder)mappingContextFactoryBuilder), generatedKeys, (ContextFactory)mappingContextFactoryBuilder.build());
        }
        return new MapperQueryPreparer(query, this.mapper(), generatedKeys);
    }

    private boolean isMultiIndex(PropertyMeta<?, ?> propertyMeta) {
        return TypeHelper.isArray((Type)propertyMeta.getPropertyType()) || TypeHelper.isAssignable(List.class, (Type)propertyMeta.getPropertyType());
    }

    public MultiIndexFieldMapper<T>[] buildIndexFieldMappers(final ContextFactoryBuilder contextFactoryBuilder) {
        final ArrayList fields = new ArrayList();
        this.propertyMappingsBuilder.forEachProperties(new ForEachCallBack<PropertyMapping<T, ?, JdbcColumnKey>>(){

            public void handle(PropertyMapping<T, ?, JdbcColumnKey> pm) {
                if (PreparedStatementMapperBuilder.this.isMultiIndex(pm.getPropertyMeta())) {
                    fields.add(this.newCollectionFieldMapper(pm));
                } else {
                    fields.add(this.newFieldMapper(pm));
                }
            }

            private <P, C> MultiIndexFieldMapper<T> newCollectionFieldMapper(PropertyMapping<T, P, JdbcColumnKey> pm) {
                ListSizeGetter sizeGetter;
                ListIndexedGetter indexedGetter;
                PropertyMeta propertyMeta = pm.getPropertyMeta();
                Getter collectionGetter = propertyMeta.getGetter();
                if (TypeHelper.isAssignable(List.class, (Type)propertyMeta.getPropertyType())) {
                    indexedGetter = new ListIndexedGetter();
                    sizeGetter = new ListSizeGetter();
                } else if (TypeHelper.isArray((Type)propertyMeta.getPropertyType())) {
                    indexedGetter = new ArrayIndexedGetter();
                    sizeGetter = new ArraySizeGetter();
                } else {
                    throw new IllegalArgumentException("Unexpected elementMeta" + propertyMeta);
                }
                PropertyMeta childProperty = pm.getPropertyMeta().getPropertyClassMeta().newPropertyFinder().findProperty(DefaultPropertyNameMatcher.of((String)"0"), pm.getColumnDefinition().properties(), (TypeAffinity)pm.getColumnKey(), (Predicate)ConstantPredicate.truePredicate());
                PropertyMapping pmchildProperttMeta = pm.propertyMeta(childProperty);
                ContextualIndexedSetter<PreparedStatement, P> setter = this.getSetter(pmchildProperttMeta);
                return new CollectionIndexFieldMapper(setter, collectionGetter, sizeGetter, indexedGetter);
            }

            private <P, C> ContextualIndexedSetter<PreparedStatement, P> getSetter(PropertyMapping<C, P, JdbcColumnKey> pm) {
                ContextualIndexedSetter<PreparedStatement, P> setter = null;
                IndexedSetterProperty indexedSetterProperty = (IndexedSetterProperty)((Object)pm.getColumnDefinition().lookFor(IndexedSetterProperty.class));
                if (indexedSetterProperty != null) {
                    setter = ContextualIndexedSetterAdapter.of(indexedSetterProperty.getIndexedSetter());
                }
                if (setter == null) {
                    setter = this.indexedSetterFactory(pm);
                }
                if (setter == null) {
                    PreparedStatementMapperBuilder.this.mapperConfig.mapperBuilderErrorHandler().accessorNotFound("Could not find setter for " + pm.getColumnKey() + " type " + pm.getPropertyMeta().getPropertyType() + " path " + pm.getPropertyMeta().getPath() + " See " + ErrorDoc.CTFM_SETTER_NOT_FOUND.toUrl());
                }
                return setter;
            }

            private <P, C> ContextualIndexedSetter<PreparedStatement, P> indexedSetterFactory(PropertyMapping<C, P, JdbcColumnKey> pm) {
                PropertyMeta subProp;
                PropertyMapping subPropertyMapping;
                ContextualIndexedSetter<PreparedStatement, P> subSetter;
                ObjectClassMeta ocm;
                ClassMeta classMeta;
                PreparedStatementIndexSetterOnGetter setter = null;
                IndexedSetterFactoryProperty indexedSetterPropertyFactory = (IndexedSetterFactoryProperty)((Object)pm.getColumnDefinition().lookFor(IndexedSetterFactoryProperty.class));
                if (indexedSetterPropertyFactory != null) {
                    IndexedSetterFactory<?, ?> setterFactory = indexedSetterPropertyFactory.getIndexedSetterFactory();
                    setter = ContextualIndexedSetterAdapter.of((IndexedSetter)setterFactory.getIndexedSetter(pm, new Object[0]));
                }
                if (setter == null) {
                    setter = PreparedStatementMapperBuilder.this.indexedSetterFactory.getIndexedSetter(pm, contextFactoryBuilder, new Object[0]);
                }
                if (setter == null && (classMeta = pm.getPropertyMeta().getPropertyClassMeta()) instanceof ObjectClassMeta && (ocm = (ObjectClassMeta)classMeta).getNumberOfProperties() == 1 && (subSetter = this.indexedSetterFactory(subPropertyMapping = pm.propertyMeta(subProp = ocm.getFirstProperty()))) != null) {
                    setter = new PreparedStatementIndexSetterOnGetter((PreparedStatementIndexSetter)subSetter, subProp.getGetter());
                }
                return setter;
            }

            private <P> MultiIndexFieldMapper<T> newFieldMapper(PropertyMapping<T, P, JdbcColumnKey> pm) {
                return new SingleIndexFieldMapper(this.getSetter(pm), pm.getPropertyMeta().getGetter());
            }
        });
        return fields.toArray(new MultiIndexFieldMapper[0]);
    }

    private static class NullInstantiator<T>
    implements BiInstantiator<T, MappingContext<? super T>, PreparedStatement> {
        private NullInstantiator() {
        }

        public PreparedStatement newInstance(T o, MappingContext<? super T> context) throws Exception {
            throw new UnsupportedOperationException();
        }
    }
}

