/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.impl;

import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.QueryPreparer;
import org.simpleflatmapper.jdbc.impl.SelectQueryImpl;
import org.simpleflatmapper.jdbc.named.NamedSqlQuery;

public class SelectQueryWhereFactory<T> {
    private final String table;
    private final JdbcMapperFactory jdbcMapperFactory;
    private final JdbcMapper<T> jdbcMapper;
    private final ConcurrentMap<SelectQueryKey, SelectQueryImpl<T, ?>> cache = new ConcurrentHashMap();

    public SelectQueryWhereFactory(String table, JdbcMapper<T> jdbcMapper, JdbcMapperFactory jdbcMapperFactory) {
        this.table = table;
        this.jdbcMapper = jdbcMapper;
        this.jdbcMapperFactory = jdbcMapperFactory;
    }

    public <P> SelectQueryImpl<T, P> where(String whereClause, Type paramClass) {
        SelectQueryImpl<T, P> newSelectQuery;
        SelectQueryKey key = new SelectQueryKey(whereClause, paramClass);
        SelectQueryImpl<T, P> selectQuery = (SelectQueryImpl<T, P>)this.cache.get(key);
        if (selectQuery == null && (selectQuery = this.cache.putIfAbsent(key, newSelectQuery = this.newSelectQuery(whereClause, paramClass))) == null) {
            selectQuery = newSelectQuery;
        }
        return selectQuery;
    }

    private <P> SelectQueryImpl<T, P> newSelectQuery(String whereClause, Type paramClass) {
        String query = this.sqlQuery(whereClause);
        QueryPreparer queryPreparer = this.jdbcMapperFactory.from(paramClass).to(NamedSqlQuery.parse(query));
        return new SelectQueryImpl(queryPreparer, this.jdbcMapper);
    }

    private String sqlQuery(String whereClause) {
        return "SELECT * FROM " + this.table + " WHERE " + whereClause;
    }

    private static class SelectQueryKey {
        private final String query;
        private final Type type;

        private SelectQueryKey(String query, Type type) {
            this.query = query;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SelectQueryKey that = (SelectQueryKey)o;
            if (!this.query.equals(that.query)) {
                return false;
            }
            return this.type.equals(that.type);
        }

        public int hashCode() {
            int result = this.query.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }
    }
}

