/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc;

import java.sql.SQLException;
import org.simpleflatmapper.jdbc.SelectQuery;
import org.simpleflatmapper.jdbc.impl.Transaction;
import org.simpleflatmapper.jdbc.impl.TransactionFactory;
import org.simpleflatmapper.util.CheckedConsumer;

public class ConnectedSelectQuery<T, P> {
    private final SelectQuery<T, P> delegate;
    private final TransactionFactory txFactory;

    public ConnectedSelectQuery(SelectQuery<T, P> delegate, TransactionFactory txFactory) {
        this.delegate = delegate;
        this.txFactory = txFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T readFirst(P p) throws SQLException {
        T t = null;
        try (Transaction tx = this.txFactory.newTransaction();){
            t = this.delegate.readFirst(tx.connection(), p);
            tx.commit();
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <C extends CheckedConsumer<? super T>> C read(P p, C consumer) throws SQLException {
        try (Transaction tx = this.txFactory.newTransaction();){
            this.delegate.read(tx.connection(), p, consumer);
            tx.commit();
        }
        return consumer;
    }
}

