/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.impl;

import java.lang.reflect.Type;
import java.sql.PreparedStatement;
import org.simpleflatmapper.jdbc.JdbcColumnKey;
import org.simpleflatmapper.jdbc.impl.PreparedStatementIndexedSetterFactory;
import org.simpleflatmapper.jdbc.impl.setter.BooleanPreparedStatementSetter;
import org.simpleflatmapper.jdbc.impl.setter.BytePreparedStatementSetter;
import org.simpleflatmapper.jdbc.impl.setter.CharacterPreparedStatementSetter;
import org.simpleflatmapper.jdbc.impl.setter.DoublePreparedStatementSetter;
import org.simpleflatmapper.jdbc.impl.setter.FloatPreparedStatementSetter;
import org.simpleflatmapper.jdbc.impl.setter.IntegerPreparedStatementSetter;
import org.simpleflatmapper.jdbc.impl.setter.LongPreparedStatementSetter;
import org.simpleflatmapper.jdbc.impl.setter.PreparedStatementSetterImpl;
import org.simpleflatmapper.jdbc.impl.setter.ShortPreparedStatementSetter;
import org.simpleflatmapper.map.mapper.ColumnDefinition;
import org.simpleflatmapper.map.mapper.PropertyMapping;
import org.simpleflatmapper.reflect.IndexedSetter;
import org.simpleflatmapper.reflect.IndexedSetterFactory;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.SetterFactory;
import org.simpleflatmapper.util.TypeHelper;

public class PreparedStatementSetterFactory
implements SetterFactory<PreparedStatement, PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>>> {
    public static final PreparedStatementSetterFactory INSTANCE = new PreparedStatementSetterFactory(PreparedStatementIndexedSetterFactory.INSTANCE);
    private final IndexedSetterFactory<PreparedStatement, PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>>> preparedStatementIndexedSetterFactory;

    private PreparedStatementSetterFactory(IndexedSetterFactory<PreparedStatement, PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>>> preparedStatementIndexedSetterFactory) {
        this.preparedStatementIndexedSetterFactory = preparedStatementIndexedSetterFactory;
    }

    public <P> Setter<PreparedStatement, P> getSetter(PropertyMapping<?, ?, JdbcColumnKey, ? extends ColumnDefinition<JdbcColumnKey, ?>> pm) {
        int columnIndex = ((JdbcColumnKey)pm.getColumnKey()).getIndex();
        Type type = pm.getPropertyMeta().getPropertyType();
        Class clazz = TypeHelper.toBoxedClass((Type)type);
        if (Boolean.class.equals((Object)clazz)) {
            return new BooleanPreparedStatementSetter(columnIndex);
        }
        if (Byte.class.equals((Object)clazz)) {
            return new BytePreparedStatementSetter(columnIndex);
        }
        if (Character.class.equals((Object)clazz)) {
            return new CharacterPreparedStatementSetter(columnIndex);
        }
        if (Short.class.equals((Object)clazz)) {
            return new ShortPreparedStatementSetter(columnIndex);
        }
        if (Integer.class.equals((Object)clazz)) {
            return new IntegerPreparedStatementSetter(columnIndex);
        }
        if (Long.class.equals((Object)clazz)) {
            return new LongPreparedStatementSetter(columnIndex);
        }
        if (Double.class.equals((Object)clazz)) {
            return new DoublePreparedStatementSetter(columnIndex);
        }
        if (Float.class.equals((Object)clazz)) {
            return new FloatPreparedStatementSetter(columnIndex);
        }
        IndexedSetter setter = this.preparedStatementIndexedSetterFactory.getIndexedSetter(pm, new Object[0]);
        if (setter != null) {
            return new PreparedStatementSetterImpl(columnIndex, setter);
        }
        return null;
    }
}

