/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Calendar;
import java.util.UUID;
import org.simpleflatmapper.jdbc.JdbcColumnKey;
import org.simpleflatmapper.jdbc.impl.getter.BigDecimalFromStringResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.BigDecimalResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.BigIntegerFromStringResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.BigIntegerResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.BlobResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.BooleanResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.ByteArrayResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.ByteResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.CalendarResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.CharacterResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.ClobResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.DateResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.DoubleResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.FloatResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.InputStreamResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.IntResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.LongResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.NClobResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.NReaderResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.NStringResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.ObjectResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.ReaderResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.RefResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.RowIdResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.SQLXMLResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.ShortResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.SqlArrayResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.StringResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.TimeResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.TimestampResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.UndefinedDateResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.UrlFromStringResultSetGetter;
import org.simpleflatmapper.jdbc.impl.getter.UrlResultSetGetter;
import org.simpleflatmapper.map.MapperBuildingException;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.getter.BytesUUIDGetter;
import org.simpleflatmapper.reflect.getter.GetterFactory;
import org.simpleflatmapper.reflect.getter.GetterFactoryRegistry;
import org.simpleflatmapper.reflect.getter.StringUUIDGetter;
import org.simpleflatmapper.reflect.getter.UUIDUnspecifiedTypeGetter;
import org.simpleflatmapper.util.TypeHelper;

public final class ResultSetGetterFactory
implements GetterFactory<ResultSet, JdbcColumnKey> {
    public static final ResultSetGetterFactory INSTANCE = new ResultSetGetterFactory();
    public static final GetterFactory<ResultSet, JdbcColumnKey> DATE_GETTER_FACTORY = new GetterFactory<ResultSet, JdbcColumnKey>(){

        public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
            switch (key.getSqlType(properties)) {
                case -99999: {
                    return new UndefinedDateResultSetGetter(key.getIndex());
                }
                case 93: {
                    return new TimestampResultSetGetter(key.getIndex());
                }
                case 91: {
                    return new DateResultSetGetter(key.getIndex());
                }
                case 92: {
                    return new TimeResultSetGetter(key.getIndex());
                }
            }
            return null;
        }
    };
    private static final GetterFactoryRegistry<ResultSet, JdbcColumnKey> factoryRegistry = new GetterFactoryRegistry();

    private ResultSetGetterFactory() {
    }

    public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
        Class clazz = TypeHelper.wrap((Class)TypeHelper.toClass((Type)genericType));
        if (Object.class.equals((Object)clazz)) {
            return new ObjectResultSetGetter(key.getIndex());
        }
        GetterFactory getterFactory = factoryRegistry.findFactoryFor((Type)clazz);
        Getter getter = null;
        if (getterFactory != null) {
            getter = getterFactory.newGetter(genericType, (Object)key, properties);
        }
        if (getter == null && (SQLData.class.isAssignableFrom(clazz) || key.getSqlType(properties) == 2000)) {
            return new ObjectResultSetGetter(key.getIndex());
        }
        return getter;
    }

    static {
        factoryRegistry.put(String.class, (GetterFactory)new StringResultSetGetterFactory());
        factoryRegistry.put(java.util.Date.class, DATE_GETTER_FACTORY);
        factoryRegistry.put(OffsetTime.class, (GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
                if (key.getSqlType(properties) == 2013) {
                    return new ObjectResultSetGetter(key.getIndex());
                }
                return null;
            }
        });
        factoryRegistry.put(OffsetDateTime.class, (GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
                if (key.getSqlType(properties) == 2014) {
                    return new ObjectResultSetGetter(key.getIndex());
                }
                return null;
            }
        });
        factoryRegistry.put(Calendar.class, (GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
                Getter dateGetter = DATE_GETTER_FACTORY.newGetter(java.util.Date.class, (Object)key, properties);
                if (dateGetter != null) {
                    return new CalendarResultSetGetter((Getter<ResultSet, ? extends java.util.Date>)dateGetter);
                }
                return null;
            }
        });
        factoryRegistry.put(Date.class, (GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
                return new DateResultSetGetter(key.getIndex());
            }
        });
        factoryRegistry.put(Timestamp.class, (GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
                return new TimestampResultSetGetter(key.getIndex());
            }
        });
        factoryRegistry.put(Time.class, (GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
                return new TimeResultSetGetter(key.getIndex());
            }
        });
        factoryRegistry.put(Boolean.class, (GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
                return new BooleanResultSetGetter(key.getIndex());
            }
        });
        factoryRegistry.put(Byte.class, (GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
                return new ByteResultSetGetter(key.getIndex());
            }
        });
        factoryRegistry.put(Character.class, (GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
                return new CharacterResultSetGetter(key.getIndex());
            }
        });
        factoryRegistry.put(Short.class, (GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
                return new ShortResultSetGetter(key.getIndex());
            }
        });
        factoryRegistry.put(Integer.class, (GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
                return new IntResultSetGetter(key.getIndex());
            }
        });
        factoryRegistry.put(Long.class, (GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
                return new LongResultSetGetter(key.getIndex());
            }
        });
        factoryRegistry.put(Float.class, (GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
                return new FloatResultSetGetter(key.getIndex());
            }
        });
        factoryRegistry.put(Double.class, (GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
                return new DoubleResultSetGetter(key.getIndex());
            }
        });
        factoryRegistry.put(BigInteger.class, (GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
                switch (key.getSqlType(properties)) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        return new BigIntegerFromStringResultSetGetter(new StringResultSetGetter(key.getIndex()));
                    }
                    case -16: 
                    case -15: 
                    case -9: 
                    case 2011: {
                        return new BigIntegerFromStringResultSetGetter(new NStringResultSetGetter(key.getIndex()));
                    }
                }
                return new BigIntegerResultSetGetter(key.getIndex());
            }
        });
        factoryRegistry.put(BigDecimal.class, (GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
                switch (key.getSqlType(properties)) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        return new BigDecimalFromStringResultSetGetter(new StringResultSetGetter(key.getIndex()));
                    }
                    case -16: 
                    case -15: 
                    case -9: 
                    case 2011: {
                        return new BigDecimalFromStringResultSetGetter(new NStringResultSetGetter(key.getIndex()));
                    }
                }
                return new BigDecimalResultSetGetter(key.getIndex());
            }
        });
        factoryRegistry.put(URL.class, (GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
                if (key.getSqlType(properties) == 70) {
                    return new UrlResultSetGetter(key.getIndex());
                }
                return new UrlFromStringResultSetGetter(key.getIndex());
            }
        });
        factoryRegistry.put(byte[].class, (GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
                return new ByteArrayResultSetGetter(key.getIndex());
            }
        });
        factoryRegistry.put(InputStream.class, (GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
                return new InputStreamResultSetGetter(key.getIndex());
            }
        });
        factoryRegistry.put(Blob.class, (GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
                return new BlobResultSetGetter(key.getIndex());
            }
        });
        factoryRegistry.put(Reader.class, (GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
                switch (key.getSqlType(properties)) {
                    case -16: 
                    case -15: 
                    case -9: 
                    case 2011: {
                        return new NReaderResultSetGetter(key.getIndex());
                    }
                }
                return new ReaderResultSetGetter(key.getIndex());
            }
        });
        factoryRegistry.put(Clob.class, (GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
                return new ClobResultSetGetter(key.getIndex());
            }
        });
        factoryRegistry.put(NClob.class, (GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
                return new NClobResultSetGetter(key.getIndex());
            }
        });
        factoryRegistry.put(Ref.class, (GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
                return new RefResultSetGetter(key.getIndex());
            }
        });
        factoryRegistry.put(RowId.class, (GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
                return new RowIdResultSetGetter(key.getIndex());
            }
        });
        factoryRegistry.put(SQLXML.class, (GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
                return new SQLXMLResultSetGetter(key.getIndex());
            }
        });
        factoryRegistry.put(Array.class, (GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
                return new SqlArrayResultSetGetter(key.getIndex());
            }
        });
        factoryRegistry.put(UUID.class, (GetterFactory)new GetterFactory<ResultSet, JdbcColumnKey>(){

            public <P> Getter<ResultSet, P> newGetter(Type target, JdbcColumnKey key, Object ... properties) {
                switch (key.getSqlType(properties)) {
                    case -99999: {
                        return new UUIDUnspecifiedTypeGetter((Getter)new ObjectResultSetGetter(key.getIndex()));
                    }
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        return new StringUUIDGetter((Getter)new StringResultSetGetter(key.getIndex()));
                    }
                    case -16: 
                    case -15: 
                    case -9: 
                    case 2011: {
                        return new StringUUIDGetter((Getter)new NStringResultSetGetter(key.getIndex()));
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        return new BytesUUIDGetter((Getter)new ByteArrayResultSetGetter(key.getIndex()));
                    }
                    case 1111: {
                        return new ObjectResultSetGetter(key.getIndex());
                    }
                }
                throw new MapperBuildingException("Incompatible type " + key.getSqlType(properties) + " with UUID");
            }
        });
    }

    public static final class StringResultSetGetterFactory
    implements GetterFactory<ResultSet, JdbcColumnKey> {
        public <P> Getter<ResultSet, P> newGetter(Type genericType, JdbcColumnKey key, Object ... properties) {
            switch (key.getSqlType(properties)) {
                case -16: 
                case -15: 
                case -9: 
                case 2011: {
                    return new NStringResultSetGetter(key.getIndex());
                }
            }
            return new StringResultSetGetter(key.getIndex());
        }
    }
}

