/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import org.simpleflatmapper.jdbc.Crud;
import org.simpleflatmapper.jdbc.JdbcMapperFactory;
import org.simpleflatmapper.jdbc.PreparedStatementMapperBuilder;
import org.simpleflatmapper.jdbc.QueryPreparer;
import org.simpleflatmapper.jdbc.impl.BatchQueryExecutor;
import org.simpleflatmapper.jdbc.impl.ColumnMeta;
import org.simpleflatmapper.jdbc.impl.CrudMeta;
import org.simpleflatmapper.jdbc.impl.DefaultCrud;
import org.simpleflatmapper.jdbc.impl.MultiRowsBatchInsertCrud;
import org.simpleflatmapper.jdbc.impl.MysqlBatchInsertQueryExecutor;
import org.simpleflatmapper.jdbc.impl.SizeAdjusterBatchQueryExecutor;
import org.simpleflatmapper.jdbc.named.NamedSqlQuery;
import org.simpleflatmapper.reflect.meta.ClassMeta;

public class MysqlCrudFactory {
    public static <T, K> Crud<T, K> newInstance(ClassMeta<T> target, ClassMeta<K> keyTarget, CrudMeta crudMeta, JdbcMapperFactory jdbcMapperFactory, DefaultCrud<T, K> defaultCrud) throws SQLException {
        return new MultiRowsBatchInsertCrud<T, K>(defaultCrud, MysqlCrudFactory.buildBatchInsert(target, crudMeta, jdbcMapperFactory, false), MysqlCrudFactory.buildBatchInsert(target, crudMeta, jdbcMapperFactory, true));
    }

    private static <T, K> BatchQueryExecutor<T> buildBatchInsert(ClassMeta<T> target, CrudMeta crudMeta, JdbcMapperFactory jdbcMapperFactory, boolean onDuplicateKeyUpdate) throws SQLException {
        ArrayList<String> generatedKeys = new ArrayList<String>();
        ArrayList<String> insertColumns = new ArrayList<String>();
        ArrayList<String> insertColumnExpressions = new ArrayList<String>();
        ArrayList<String> updateColumns = new ArrayList<String>();
        PreparedStatementMapperBuilder<T> statementMapperBuilder = jdbcMapperFactory.from(target);
        for (ColumnMeta cm : crudMeta.getColumnMetas()) {
            String columnName = cm.getColumn();
            if (cm.isGenerated()) {
                generatedKeys.add(columnName);
            }
            if (cm.isInsertable()) {
                insertColumns.add(columnName);
                if (!cm.isGenerated()) {
                    statementMapperBuilder.addColumn(columnName);
                }
                insertColumnExpressions.add(cm.getInsertExpression());
            }
            if (cm.isKey()) continue;
            updateColumns.add(columnName);
        }
        MysqlBatchInsertQueryExecutor<T> queryExecutor = new MysqlBatchInsertQueryExecutor<T>(crudMeta.getTable(), insertColumns.toArray(new String[0]), insertColumnExpressions.toArray(new String[0]), onDuplicateKeyUpdate ? updateColumns.toArray(new String[0]) : null, generatedKeys.toArray(new String[0]), statementMapperBuilder.buildIndexFieldMappers());
        return new SizeAdjusterBatchQueryExecutor<T>(queryExecutor);
    }

    public static <T, K> QueryPreparer<T> buildUpsert(ClassMeta<T> target, CrudMeta crudMeta, JdbcMapperFactory jdbcMapperFactory) {
        ArrayList<String> generatedKeys = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append(crudMeta.getTable()).append("(");
        boolean first = true;
        for (ColumnMeta cm : crudMeta.getColumnMetas()) {
            if (cm.isGenerated()) {
                generatedKeys.add(cm.getColumn());
            }
            if (!cm.isInsertable()) continue;
            if (!first) {
                sb.append(", ");
            }
            sb.append(cm.getColumn());
            first = false;
        }
        sb.append(") VALUES(");
        first = true;
        for (ColumnMeta cm : crudMeta.getColumnMetas()) {
            if (!cm.isInsertable()) continue;
            if (!first) {
                sb.append(", ");
            }
            sb.append(cm.getInsertExpression());
            first = false;
        }
        sb.append(") ON DUPLICATE KEY UPDATE ");
        first = true;
        for (ColumnMeta cm : crudMeta.getColumnMetas()) {
            if (cm.isKey()) continue;
            if (!first) {
                sb.append(", ");
            }
            sb.append(cm.getColumn());
            sb.append(" = VALUES(").append(cm.getColumn()).append(")");
            first = false;
        }
        return jdbcMapperFactory.from(target).to(NamedSqlQuery.parse(sb), generatedKeys.toArray(new String[0]));
    }
}

