/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.impl;

import java.lang.reflect.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import org.simpleflatmapper.jdbc.Crud;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.QueryPreparer;
import org.simpleflatmapper.jdbc.SelectQuery;
import org.simpleflatmapper.jdbc.impl.KeyTupleQueryPreparer;
import org.simpleflatmapper.jdbc.impl.SelectQueryWhereFactory;
import org.simpleflatmapper.map.Mapper;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.ErrorHelper;

public final class DefaultCrud<T, K>
implements Crud<T, K> {
    protected final QueryPreparer<T> insertQueryPreparer;
    protected final QueryPreparer<T> updateQueryPreparer;
    protected final QueryPreparer<K> selectQueryPreparer;
    protected final QueryPreparer<K> deleteQueryPreparer;
    protected final QueryPreparer<T> upsertQueryPreparer;
    protected final KeyTupleQueryPreparer<K> keyTupleQueryPreparer;
    protected final JdbcMapper<T> selectQueryMapper;
    protected final JdbcMapper<K> keyMapper;
    protected final String table;
    protected final boolean hasGeneratedKeys;
    protected final SelectQueryWhereFactory<T> selectQueryWhereFactory;

    public DefaultCrud(QueryPreparer<T> insertQueryPreparer, QueryPreparer<T> updateQueryPreparer, QueryPreparer<K> selectQueryPreparer, QueryPreparer<T> upsertQueryPreparer, KeyTupleQueryPreparer<K> keyTupleQueryPreparer, JdbcMapper<T> selectQueryMapper, QueryPreparer<K> deleteQueryPreparer, JdbcMapper<K> keyMapper, String table, boolean hasGeneratedKeys, SelectQueryWhereFactory<T> selectQueryWhereFactory) {
        this.insertQueryPreparer = insertQueryPreparer;
        this.updateQueryPreparer = updateQueryPreparer;
        this.selectQueryPreparer = selectQueryPreparer;
        this.upsertQueryPreparer = upsertQueryPreparer;
        this.keyTupleQueryPreparer = keyTupleQueryPreparer;
        this.deleteQueryPreparer = deleteQueryPreparer;
        this.selectQueryMapper = selectQueryMapper;
        this.keyMapper = keyMapper;
        this.table = table;
        this.hasGeneratedKeys = hasGeneratedKeys;
        this.selectQueryWhereFactory = selectQueryWhereFactory;
    }

    @Override
    public void create(Connection connection, T value) throws SQLException {
        this.create(connection, value, null);
    }

    @Override
    public void create(Connection connection, Collection<T> values) throws SQLException {
        this.create(connection, values, (CheckedConsumer)null);
    }

    @Override
    public <RH extends CheckedConsumer<? super K>> RH create(Connection connection, T value, RH keyConsumer) throws SQLException {
        return this.executeQueryPreparer(connection, value, keyConsumer, this.insertQueryPreparer);
    }

    @Override
    public <RH extends CheckedConsumer<? super K>> RH create(Connection connection, Collection<T> values, RH keyConsumer) throws SQLException {
        return this.executeQueryPreparerInBatchMode(connection, values, keyConsumer, this.insertQueryPreparer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T read(Connection connection, K key) throws SQLException {
        PreparedStatement preparedStatement = this.selectQueryPreparer.prepare(connection).bind(key);
        try {
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                T t = this.selectQueryMapper.map(resultSet);
                return t;
            }
        }
        finally {
            this.safeClose(preparedStatement);
        }
        return null;
    }

    private void safeClose(PreparedStatement preparedStatement) {
        try {
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <RH extends CheckedConsumer<? super T>> RH read(Connection connection, Collection<K> keys, RH consumer) throws SQLException {
        PreparedStatement preparedStatement = this.keyTupleQueryPreparer.prepareStatement("SELECT * FROM " + this.table + " WHERE ", connection, keys.size());
        try {
            this.keyTupleQueryPreparer.bindTo(keys, preparedStatement, 0);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                consumer.accept(this.selectQueryMapper.map(resultSet));
            }
            RH RH = consumer;
            return RH;
        }
        catch (Exception e) {
            CheckedConsumer checkedConsumer = (CheckedConsumer)ErrorHelper.rethrow((Throwable)e);
            return (RH)checkedConsumer;
        }
        finally {
            this.safeClose(preparedStatement);
        }
    }

    @Override
    public void update(Connection connection, T value) throws SQLException {
        this.executeQueryPreparer(connection, value, null, this.updateQueryPreparer);
    }

    @Override
    public void update(Connection connection, Collection<T> values) throws SQLException {
        this.executeQueryPreparerInBatchMode(connection, values, null, this.updateQueryPreparer);
    }

    @Override
    public void delete(Connection connection, K key) throws SQLException {
        this.executeQueryPreparer(connection, key, null, this.deleteQueryPreparer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Connection connection, Collection<K> keys) throws SQLException {
        PreparedStatement preparedStatement = this.keyTupleQueryPreparer.prepareStatement("DELETE FROM " + this.table + " WHERE ", connection, keys.size());
        try {
            this.keyTupleQueryPreparer.bindTo(keys, preparedStatement, 0);
            preparedStatement.executeUpdate();
        }
        catch (Exception e) {
            ErrorHelper.rethrow((Throwable)e);
        }
        finally {
            this.safeClose(preparedStatement);
        }
    }

    @Override
    public void createOrUpdate(Connection connection, T value) throws SQLException {
        this.createOrUpdate(connection, value, null);
    }

    @Override
    public void createOrUpdate(Connection connection, Collection<T> values) throws SQLException {
        this.createOrUpdate(connection, values, (CheckedConsumer)null);
    }

    @Override
    public <RH extends CheckedConsumer<? super K>> RH createOrUpdate(Connection connection, T value, RH keyConsumer) throws SQLException {
        return this.executeQueryPreparer(connection, value, keyConsumer, this.upsertQueryPreparer);
    }

    @Override
    public <RH extends CheckedConsumer<? super K>> RH createOrUpdate(Connection connection, Collection<T> values, RH keyConsumer) throws SQLException {
        return this.executeQueryPreparerInBatchMode(connection, values, keyConsumer, this.upsertQueryPreparer);
    }

    @Override
    public <P> SelectQuery<T, P> where(String whereClause, Type paramClass) {
        return this.selectQueryWhereFactory.where(whereClause, paramClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <RH extends CheckedConsumer<? super K>> RH executeQueryPreparerInBatchMode(Connection connection, Collection<T> values, RH keyConsumer, QueryPreparer<T> queryPreparer) throws SQLException {
        PreparedStatement preparedStatement = queryPreparer.prepareStatement(connection);
        try {
            Mapper<T, PreparedStatement> mapper = queryPreparer.mapper();
            for (T value : values) {
                mapper.mapTo(value, (Object)preparedStatement, null);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            if (this.hasGeneratedKeys && keyConsumer != null) {
                this.handleGeneratedKeys(keyConsumer, preparedStatement);
            }
            Iterator<Object> iterator = keyConsumer;
            return (RH)iterator;
        }
        catch (Exception e) {
            ErrorHelper.rethrow((Throwable)e);
        }
        finally {
            this.safeClose(preparedStatement);
        }
        return keyConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <RH extends CheckedConsumer<? super K>, QPT> RH executeQueryPreparer(Connection connection, QPT value, RH keyConsumer, QueryPreparer<QPT> queryPreparer) throws SQLException {
        PreparedStatement preparedStatement = queryPreparer.prepare(connection).bind(value);
        try {
            preparedStatement.executeUpdate();
            if (this.hasGeneratedKeys && keyConsumer != null) {
                this.handleGeneratedKeys(keyConsumer, preparedStatement);
            }
            RH RH = keyConsumer;
            return RH;
        }
        finally {
            this.safeClose(preparedStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleGeneratedKeys(CheckedConsumer<? super K> keyConsumer, PreparedStatement preparedStatement) throws SQLException {
        try (ResultSet keys = preparedStatement.getGeneratedKeys();){
            while (keys.next()) {
                try {
                    keyConsumer.accept(this.keyMapper.map(keys));
                }
                catch (Exception e) {
                    ErrorHelper.rethrow((Throwable)e);
                }
            }
        }
    }
}

