/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.simpleflatmapper.jdbc.JdbcColumnKey;
import org.simpleflatmapper.jdbc.JdbcMapper;
import org.simpleflatmapper.jdbc.JdbcMappingContextFactoryBuilder;
import org.simpleflatmapper.jdbc.ResultSetGetterFactory;
import org.simpleflatmapper.jdbc.impl.ResultSetEnumarable;
import org.simpleflatmapper.map.ConsumerErrorHandler;
import org.simpleflatmapper.map.Mapper;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.context.MappingContextFactory;
import org.simpleflatmapper.map.context.MappingContextFactoryBuilder;
import org.simpleflatmapper.map.mapper.AbstractMapperBuilder;
import org.simpleflatmapper.map.mapper.JoinMapper;
import org.simpleflatmapper.map.mapper.KeyFactory;
import org.simpleflatmapper.map.mapper.MapperSource;
import org.simpleflatmapper.map.mapper.MapperSourceImpl;
import org.simpleflatmapper.map.mapper.StaticSetRowMapper;
import org.simpleflatmapper.map.property.FieldMapperColumnDefinition;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.getter.GetterFactory;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.util.Enumarable;
import org.simpleflatmapper.util.TypeReference;
import org.simpleflatmapper.util.UnaryFactory;

public final class JdbcMapperBuilder<T>
extends AbstractMapperBuilder<ResultSet, T, JdbcColumnKey, JdbcMapper<T>, JdbcMapperBuilder<T>> {
    private static final MapperSourceImpl<ResultSet, JdbcColumnKey> FIELD_MAPPER_SOURCE = new MapperSourceImpl(ResultSet.class, (GetterFactory)ResultSetGetterFactory.INSTANCE);
    private static final KeyFactory<JdbcColumnKey> KEY_FACTORY = new KeyFactory<JdbcColumnKey>(){

        public JdbcColumnKey newKey(String name, int i) {
            return new JdbcColumnKey(name, i);
        }
    };

    public JdbcMapperBuilder(TypeReference<T> target) {
        this(target.getType());
    }

    public JdbcMapperBuilder(Type target) {
        this(target, ReflectionService.newInstance());
    }

    public JdbcMapperBuilder(Type target, ReflectionService reflectService) {
        this(reflectService.getClassMeta(target), (MapperConfig<JdbcColumnKey, FieldMapperColumnDefinition<JdbcColumnKey>>)MapperConfig.fieldMapperConfig(), ResultSetGetterFactory.INSTANCE, new JdbcMappingContextFactoryBuilder());
    }

    public JdbcMapperBuilder(ClassMeta<T> classMeta, MapperConfig<JdbcColumnKey, FieldMapperColumnDefinition<JdbcColumnKey>> mapperConfig, GetterFactory<ResultSet, JdbcColumnKey> getterFactory, MappingContextFactoryBuilder<ResultSet, JdbcColumnKey> parentBuilder) {
        super(classMeta, parentBuilder, mapperConfig, (MapperSource)FIELD_MAPPER_SOURCE.getterFactory(getterFactory), KEY_FACTORY, 1);
    }

    public JdbcMapperBuilder<T> addMapping(String column, int index, int sqlType) {
        this.addMapping(column, index, sqlType, (FieldMapperColumnDefinition<JdbcColumnKey>)FieldMapperColumnDefinition.identity());
        return this;
    }

    public JdbcMapperBuilder<T> addMapping(String column, int index, int sqlType, FieldMapperColumnDefinition<JdbcColumnKey> columnDefinition) {
        return (JdbcMapperBuilder)this.addMapping(new JdbcColumnKey(column, index, sqlType), columnDefinition);
    }

    public JdbcMapperBuilder<T> addMapping(String column, int index, int sqlType, Object ... properties) {
        return (JdbcMapperBuilder)this.addMapping(new JdbcColumnKey(column, index, sqlType), properties);
    }

    public JdbcMapperBuilder<T> addMapping(ResultSetMetaData metaData) throws SQLException {
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            this.addMapping(metaData.getColumnLabel(i), i, metaData.getColumnType(i));
        }
        return this;
    }

    protected JdbcMapper<T> newJoinMapper(Mapper<ResultSet, T> mapper) {
        return new JoinJdbcMapper<T>(mapper, this.mapperConfig.consumerErrorHandler(), (MappingContextFactory<? super ResultSet>)this.mappingContextFactoryBuilder.newFactory());
    }

    protected JdbcMapper<T> newStaticMapper(Mapper<ResultSet, T> mapper) {
        return new StaticJdbcSetRowMapper<T>(mapper, this.mapperConfig.consumerErrorHandler(), (MappingContextFactory<? super ResultSet>)this.mappingContextFactoryBuilder.newFactory());
    }

    private static class StaticJdbcSetRowMapper<T>
    extends StaticSetRowMapper<ResultSet, ResultSet, T, SQLException>
    implements JdbcMapper<T> {
        public StaticJdbcSetRowMapper(Mapper<ResultSet, T> mapper, ConsumerErrorHandler errorHandler, MappingContextFactory<? super ResultSet> mappingContextFactory) {
            super(mapper, errorHandler, mappingContextFactory, (UnaryFactory)new ResultSetEnumarableFactory());
        }

        public MappingContext<? super ResultSet> newMappingContext(ResultSet resultSet) throws SQLException {
            return this.getMappingContextFactory().newContext();
        }
    }

    private static class ResultSetEnumarableFactory
    implements UnaryFactory<ResultSet, Enumarable<ResultSet>> {
        private ResultSetEnumarableFactory() {
        }

        public Enumarable<ResultSet> newInstance(ResultSet rows) {
            return new ResultSetEnumarable(rows);
        }
    }

    private static class JoinJdbcMapper<T>
    extends JoinMapper<ResultSet, ResultSet, T, SQLException>
    implements JdbcMapper<T> {
        public JoinJdbcMapper(Mapper<ResultSet, T> mapper, ConsumerErrorHandler errorHandler, MappingContextFactory<? super ResultSet> mappingContextFactory) {
            super(mapper, errorHandler, mappingContextFactory, (UnaryFactory)new ResultSetEnumarableFactory());
        }

        public MappingContext<? super ResultSet> newMappingContext(ResultSet rs) {
            return this.getMappingContextFactory().newContext();
        }
    }
}

