/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.converter;

import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.util.List;
import org.simpleflatmapper.converter.Converter;
import org.simpleflatmapper.jdbc.converter.SqlArrayToListConverter;
import org.simpleflatmapper.reflect.Getter;

public class SqlArrayToJavaArrayConverter<T>
implements Converter<java.sql.Array, T[]> {
    private final T[] emptyArray;
    private final SqlArrayToListConverter<T> sqlArrayToListConverter;

    public SqlArrayToJavaArrayConverter(Class<T> elementType, Getter<? super ResultSet, ? extends T> getter) {
        this.emptyArray = (Object[])Array.newInstance(elementType, 0);
        this.sqlArrayToListConverter = new SqlArrayToListConverter<T>(getter);
    }

    public T[] convert(java.sql.Array in) throws Exception {
        List<T> list = this.sqlArrayToListConverter.convert(in);
        return list != null ? list.toArray(this.emptyArray) : null;
    }
}

