/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.jdbc.named;

import java.util.ArrayList;
import java.util.List;
import org.simpleflatmapper.jdbc.named.NamedParameter;
import org.simpleflatmapper.jdbc.named.Parameter;
import org.simpleflatmapper.jdbc.named.Position;
import org.simpleflatmapper.jdbc.named.Symbol;
import org.simpleflatmapper.jdbc.named.Tuple;
import org.simpleflatmapper.jdbc.named.TupleBuilder;
import org.simpleflatmapper.jdbc.named.Word;

public final class NamedSqlQueryParser {
    final List<Symbol> symbols = new ArrayList<Symbol>(10);
    final List<TupleBuilder> tuples = new ArrayList<TupleBuilder>();
    int lastMarkStart = -1;
    int lastMarkEnd = -1;
    private final Callback callback;

    public NamedSqlQueryParser(Callback callback) {
        this.callback = callback;
    }

    public void parse(CharSequence cs) {
        for (int i = 0; i < cs.length(); ++i) {
            char c = cs.charAt(i);
            this.processChar(cs, i, c);
        }
        if (this.lastMarkStart != -1) {
            this.processSymbol(cs, cs.length());
        }
    }

    private void processChar(CharSequence cs, int i, char c) {
        if (c == '(') {
            this.openFunction(cs, i);
        } else if (c == ')') {
            this.closeFunction(cs, i);
        } else if (this.isSpaceOrSymbol(c)) {
            if (this.lastMarkStart != -1 && this.lastMarkEnd == -1) {
                this.lastMarkEnd = i;
            }
        } else {
            if (this.lastMarkEnd != -1) {
                this.processSymbol(cs, i);
            }
            if (this.lastMarkStart == -1) {
                this.lastMarkStart = i;
            }
        }
    }

    private void closeFunction(CharSequence cs, int i) {
        if (this.lastMarkStart != -1) {
            this.processSymbol(cs, i);
        }
        TupleBuilder topTuple = this.tuples.remove(this.tuples.size() - 1);
        Tuple tuple = topTuple.toTuple(i + 1);
        if (this.tuples.isEmpty()) {
            this.symbols.add(tuple);
        } else {
            this.tuples.get(this.tuples.size() - 1).add(tuple);
        }
    }

    private void openFunction(CharSequence cs, int i) {
        Symbol word = this.consumeSymbol(cs, i);
        int start = word.getPosition().getStart();
        if (start == -1) {
            start = i;
        }
        this.tuples.add(new TupleBuilder(word, start));
    }

    private void processSymbol(CharSequence cs, int length) {
        Symbol symbol = this.consumeSymbol(cs, length);
        if (this.tuples.isEmpty()) {
            this.symbols.add(symbol);
        } else {
            this.tuples.get(this.tuples.size() - 1).add(symbol);
        }
    }

    private boolean isSpaceOrSymbol(char c) {
        return c == ' ' || c == '=' || c == '<' || c == '>' || c == '!' || c == ',';
    }

    private Symbol consumeSymbol(CharSequence cs, int i) {
        String name = this.getName(cs, i);
        Position position = this.consumePosition();
        if (name.startsWith(":")) {
            NamedParameter namedParameter = new NamedParameter(name.substring(1), position);
            this.callback.param(namedParameter);
            return namedParameter;
        }
        if (name.equals("?")) {
            Parameter parameter = new Parameter(position);
            Word extrapolateName = this.findName(parameter);
            this.callback.param(new NamedParameter(extrapolateName.getName(), position));
            return parameter;
        }
        return new Word(name, position);
    }

    private Word findName(Parameter parameter) {
        Word w;
        Symbol s;
        if (this.symbols.isEmpty()) {
            throw new IllegalArgumentException("Cannot find name for ? at " + parameter.getPosition().getStart());
        }
        if (!this.tuples.isEmpty() && (s = this.symbols.get(this.symbols.size() - 1)) instanceof Tuple && (w = this.lookForArg(0, (Tuple)s)) != null) {
            return w;
        }
        for (int i = this.symbols.size() - 1; i >= 0; --i) {
            Word word;
            Symbol s2 = this.symbols.get(i);
            if (Word.class.isInstance(s2)) {
                return (Word)s2;
            }
            if (!Tuple.class.isInstance(s2) || (word = this.getFirstArgument((Tuple)s2)) == null) continue;
            return word;
        }
        throw new IllegalArgumentException("Cannot find name for ? at " + parameter.getPosition().getStart());
    }

    private Word getFirstArgument(Tuple arg) {
        if (arg.size() == 0) {
            return null;
        }
        Symbol s = arg.getSymbol(0);
        if (s instanceof Word) {
            return (Word)s;
        }
        if (s instanceof Tuple) {
            return this.getFirstArgument((Tuple)s);
        }
        return null;
    }

    private Word lookForArg(int stackLevel, Tuple s) {
        TupleBuilder tupleBuilder = this.tuples.get(stackLevel);
        int position = tupleBuilder.size();
        if (s.size() > position) {
            Symbol symbol = s.getSymbol(position);
            if (Word.class.isInstance(symbol)) {
                return (Word)symbol;
            }
            if (stackLevel + 1 < this.tuples.size() && symbol instanceof Tuple) {
                return this.lookForArg(stackLevel + 1, (Tuple)symbol);
            }
        }
        return null;
    }

    private Position consumePosition() {
        Position position = new Position(this.lastMarkStart, this.lastMarkEnd);
        this.lastMarkEnd = -1;
        this.lastMarkStart = -1;
        return position;
    }

    private String getName(CharSequence cs, int i) {
        String name;
        if (this.lastMarkStart != -1) {
            if (this.lastMarkEnd == -1) {
                this.lastMarkEnd = i;
            }
            name = cs.subSequence(this.lastMarkStart, this.lastMarkEnd).toString();
        } else {
            name = "";
        }
        return name;
    }

    public static interface Callback {
        public void param(NamedParameter var1);
    }
}

