/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.datastax.impl.getter;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableByIndexData;
import org.simpleflatmapper.datastax.DataTypeHelper;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.primitive.ByteGetter;

public class DatastaxGenericByteGetter
implements ByteGetter<GettableByIndexData>,
Getter<GettableByIndexData, Byte> {
    private final int index;
    private final DataType.Name dataTypeName;

    public DatastaxGenericByteGetter(int index, DataType dataType) {
        this.index = index;
        this.dataTypeName = this.validateName(dataType);
    }

    private DataType.Name validateName(DataType dataType) {
        DataType.Name name = dataType.getName();
        if (DataTypeHelper.isNumber(name)) {
            return name;
        }
        throw new IllegalArgumentException("Datatype " + dataType + " not a number");
    }

    public Byte get(GettableByIndexData target) throws Exception {
        if (target.isNull(this.index)) {
            return null;
        }
        return this.getByte(target);
    }

    public byte getByte(GettableByIndexData target) throws Exception {
        switch (this.dataTypeName) {
            case BIGINT: 
            case COUNTER: {
                return (byte)target.getLong(this.index);
            }
            case VARINT: {
                return target.getVarint(this.index).byteValue();
            }
            case INT: {
                return (byte)target.getInt(this.index);
            }
            case DECIMAL: {
                return target.getDecimal(this.index).byteValue();
            }
            case FLOAT: {
                return (byte)target.getFloat(this.index);
            }
            case DOUBLE: {
                return (byte)target.getDouble(this.index);
            }
            case SMALLINT: {
                return (byte)target.getShort(this.index);
            }
            case TINYINT: {
                return target.getByte(this.index);
            }
            case TIME: {
                return (byte)target.getTime(this.index);
            }
        }
        return 0;
    }
}

