/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.datastax.impl.setter;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.SettableByIndexData;
import com.datastax.driver.core.TupleType;
import com.datastax.driver.core.TupleValue;
import java.lang.reflect.Type;
import java.util.List;
import org.simpleflatmapper.datastax.DatastaxColumnKey;
import org.simpleflatmapper.datastax.SettableDataMapperBuilder;
import org.simpleflatmapper.datastax.impl.SettableDataSetterFactory;
import org.simpleflatmapper.map.FieldMapper;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.mapper.ConstantTargetFieldMapperFactory;
import org.simpleflatmapper.map.mapper.ConstantTargetFieldMapperFactoryImpl;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.SetterFactory;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.tuple.Tuple2;

public class TupleValueSettableDataSetter
implements Setter<SettableByIndexData, TupleValue> {
    private final int index;

    public TupleValueSettableDataSetter(int index) {
        this.index = index;
    }

    public void set(SettableByIndexData target, TupleValue value) throws Exception {
        if (value == null) {
            target.setToNull(this.index);
        } else {
            target.setTupleValue(this.index, value);
        }
    }

    public static <T extends Tuple2<?, ?>> FieldMapper<T, SettableByIndexData> newTupleMapper(Type target, TupleType tt, MapperConfig<DatastaxColumnKey, ?> config, ReflectionService reflectionService) {
        SettableDataMapperBuilder<T> builder = TupleValueSettableDataSetter.newFieldMapperBuilder(config, reflectionService, target);
        List componentTypes = tt.getComponentTypes();
        for (int i = 0; i < componentTypes.size(); ++i) {
            builder.addColumn(new DatastaxColumnKey("elt" + i, i, (DataType)componentTypes.get(i)), new Object[0]);
        }
        return builder.mapper();
    }

    public static <T> SettableDataMapperBuilder<T> newFieldMapperBuilder(MapperConfig<DatastaxColumnKey, ?> config, ReflectionService reflectionService, Type target) {
        ClassMeta classMeta = reflectionService.getClassMeta(target);
        return new SettableDataMapperBuilder(classMeta, config, (ConstantTargetFieldMapperFactory<SettableByIndexData, DatastaxColumnKey>)ConstantTargetFieldMapperFactoryImpl.newInstance((SetterFactory)new SettableDataSetterFactory(config, reflectionService), SettableByIndexData.class));
    }
}

