/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.datastax.impl.getter;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableByIndexData;
import java.math.BigInteger;
import org.simpleflatmapper.datastax.DataTypeHelper;
import org.simpleflatmapper.reflect.Getter;

public class DatastaxGenericBigIntegerGetter
implements Getter<GettableByIndexData, BigInteger> {
    private final int index;
    private final DataType.Name dataTypeName;

    public DatastaxGenericBigIntegerGetter(int index, DataType dataType) {
        this.index = index;
        this.dataTypeName = this.validateName(dataType);
    }

    private DataType.Name validateName(DataType dataType) {
        if (DataTypeHelper.isNumber(dataType)) {
            return dataType.getName();
        }
        throw new IllegalArgumentException("DataType " + dataType + "is not a number");
    }

    public BigInteger get(GettableByIndexData target) throws Exception {
        if (target.isNull(this.index)) {
            return null;
        }
        switch (this.dataTypeName) {
            case BIGINT: 
            case COUNTER: {
                return BigInteger.valueOf(target.getLong(this.index));
            }
            case VARINT: {
                return target.getVarint(this.index);
            }
            case INT: {
                return BigInteger.valueOf(target.getInt(this.index));
            }
            case DECIMAL: {
                return target.getDecimal(this.index).toBigInteger();
            }
            case FLOAT: {
                return BigInteger.valueOf((long)target.getFloat(this.index));
            }
            case DOUBLE: {
                return BigInteger.valueOf((long)target.getDouble(this.index));
            }
            case SMALLINT: {
                return BigInteger.valueOf(target.getShort(this.index));
            }
            case TINYINT: {
                return BigInteger.valueOf(target.getByte(this.index));
            }
            case TIME: {
                return BigInteger.valueOf(target.getTime(this.index));
            }
        }
        return null;
    }
}

