/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.datastax.impl.getter;

import com.datastax.driver.core.GettableByIndexData;
import com.datastax.driver.core.UserType;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.simpleflatmapper.datastax.DatastaxColumnKey;
import org.simpleflatmapper.datastax.DatastaxMapperBuilder;
import org.simpleflatmapper.datastax.DatastaxMapperFactory;
import org.simpleflatmapper.datastax.impl.DatastaxMappingContextFactoryBuilder;
import org.simpleflatmapper.datastax.impl.RowGetterFactory;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.Mapper;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.map.context.MappingContextFactoryBuilder;
import org.simpleflatmapper.map.mapper.ConstantSourceMapperBuilder;
import org.simpleflatmapper.map.mapper.MapperSource;
import org.simpleflatmapper.map.mapper.MapperSourceImpl;
import org.simpleflatmapper.map.property.FieldMapperColumnDefinition;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.getter.GetterFactory;
import org.simpleflatmapper.reflect.meta.ClassMeta;

public class DatastaxUDTGetter<T>
implements Getter<GettableByIndexData, T> {
    private final Mapper<GettableByIndexData, T> mapper;
    private final int index;

    public DatastaxUDTGetter(Mapper<GettableByIndexData, T> mapper, int index) {
        this.mapper = mapper;
        this.index = index;
    }

    public T get(GettableByIndexData target) throws Exception {
        return (T)this.mapper.map((Object)target.getUDTValue(this.index));
    }

    public static <P> Getter<GettableByIndexData, P> newInstance(DatastaxMapperFactory factory, Type target, UserType tt, int index) {
        Mapper<GettableByIndexData, P> mapper = DatastaxUDTGetter.newUDTMapper(target, tt, factory);
        return new DatastaxUDTGetter<P>(mapper, index);
    }

    public static <P> Mapper<GettableByIndexData, P> newUDTMapper(Type target, UserType tt, DatastaxMapperFactory factory) {
        ConstantSourceMapperBuilder<GettableByIndexData, P, DatastaxColumnKey> builder = DatastaxUDTGetter.newFieldMapperBuilder(factory, target);
        Iterator iterator = tt.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            UserType.Field f = (UserType.Field)iterator.next();
            FieldMapperColumnDefinition identity = FieldMapperColumnDefinition.identity();
            builder.addMapping((FieldKey)new DatastaxColumnKey(f.getName(), i, f.getType()), identity);
            ++i;
        }
        return builder.mapper();
    }

    public static <P> ConstantSourceMapperBuilder<GettableByIndexData, P, DatastaxColumnKey> newFieldMapperBuilder(DatastaxMapperFactory factory, Type target) {
        MapperConfig config = factory.mapperConfig();
        MapperSourceImpl mapperSource = new MapperSourceImpl(GettableByIndexData.class, (GetterFactory)new RowGetterFactory(factory));
        ClassMeta classMeta = factory.getClassMeta(target);
        return new ConstantSourceMapperBuilder((MapperSource)mapperSource, classMeta, config, (MappingContextFactoryBuilder)new DatastaxMappingContextFactoryBuilder(), DatastaxMapperBuilder.KEY_FACTORY);
    }
}

