/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.datastax.impl.getter;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableByIndexData;
import java.math.BigDecimal;
import org.sfm.datastax.DataHelper;
import org.sfm.datastax.DataTypeHelper;
import org.sfm.reflect.Getter;

public class DatastaxGenericBigDecimalGetter
implements Getter<GettableByIndexData, BigDecimal> {
    private final int index;
    private final DataType.Name dataTypeName;

    public DatastaxGenericBigDecimalGetter(int index, DataType dataType) {
        this.index = index;
        this.dataTypeName = this.validateName(dataType);
    }

    private DataType.Name validateName(DataType dataType) {
        DataType.Name name = dataType.getName();
        if (DataTypeHelper.isNumber(name)) {
            return name;
        }
        throw new IllegalArgumentException("Datatype " + dataType + " not a number");
    }

    public BigDecimal get(GettableByIndexData target) throws Exception {
        if (target.isNull(this.index)) {
            return null;
        }
        switch (this.dataTypeName) {
            case BIGINT: 
            case COUNTER: {
                return BigDecimal.valueOf(target.getLong(this.index));
            }
            case VARINT: {
                return new BigDecimal(target.getVarint(this.index));
            }
            case INT: {
                return BigDecimal.valueOf(target.getInt(this.index));
            }
            case DECIMAL: {
                return target.getDecimal(this.index);
            }
            case FLOAT: {
                return BigDecimal.valueOf(target.getFloat(this.index));
            }
            case DOUBLE: {
                return BigDecimal.valueOf(target.getDouble(this.index));
            }
        }
        if (DataTypeHelper.isSmallInt(this.dataTypeName)) {
            return BigDecimal.valueOf(DataHelper.getShort(this.index, target));
        }
        if (DataTypeHelper.isTinyInt(this.dataTypeName)) {
            return BigDecimal.valueOf(DataHelper.getByte(this.index, target));
        }
        if (DataTypeHelper.isTime(this.dataTypeName)) {
            return BigDecimal.valueOf(DataHelper.getTime(this.index, target));
        }
        return null;
    }
}

