/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.datastax.impl;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableData;
import org.sfm.reflect.Getter;
import org.sfm.reflect.primitive.FloatGetter;

public class DatastaxGenericFloatGetter
implements FloatGetter<GettableData>,
Getter<GettableData, Float> {
    private final int index;
    private final DataType.Name dataTypeName;

    public DatastaxGenericFloatGetter(int index, DataType dataType) {
        this.index = index;
        this.dataTypeName = this.validateName(dataType);
    }

    private DataType.Name validateName(DataType dataType) {
        DataType.Name name = dataType.getName();
        switch (name) {
            case BIGINT: 
            case VARINT: 
            case INT: 
            case DECIMAL: 
            case FLOAT: 
            case DOUBLE: 
            case COUNTER: {
                return name;
            }
        }
        throw new IllegalArgumentException("Datatype " + dataType + " not a number");
    }

    public Float get(GettableData target) throws Exception {
        if (target.isNull(this.index)) {
            return null;
        }
        return Float.valueOf(this.getFloat(target));
    }

    public float getFloat(GettableData target) throws Exception {
        switch (this.dataTypeName) {
            case BIGINT: 
            case COUNTER: {
                return target.getLong(this.index);
            }
            case VARINT: {
                return target.getVarint(this.index).floatValue();
            }
            case INT: {
                return target.getInt(this.index);
            }
            case DECIMAL: {
                return target.getDecimal(this.index).floatValue();
            }
            case FLOAT: {
                return target.getFloat(this.index);
            }
            case DOUBLE: {
                return (float)target.getDouble(this.index);
            }
        }
        return 0.0f;
    }
}

