/*
 * Decompiled with CFR 0.152.
 */
package org.sfm.datastax;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.GettableData;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.exceptions.DriverException;
import java.sql.SQLException;
import org.sfm.datastax.DatastaxColumnKey;
import org.sfm.datastax.DatastaxMapper;
import org.sfm.datastax.impl.ResultSetEnumarable;
import org.sfm.datastax.impl.RowGetterFactory;
import org.sfm.map.GetterFactory;
import org.sfm.map.Mapper;
import org.sfm.map.MapperConfig;
import org.sfm.map.RowHandlerErrorHandler;
import org.sfm.map.column.ColumnProperty;
import org.sfm.map.column.FieldMapperColumnDefinition;
import org.sfm.map.context.MappingContextFactory;
import org.sfm.map.context.MappingContextFactoryBuilder;
import org.sfm.map.mapper.AbstractMapperBuilder;
import org.sfm.map.mapper.JoinMapperImpl;
import org.sfm.map.mapper.MapperSource;
import org.sfm.map.mapper.MapperSourceImpl;
import org.sfm.map.mapper.StaticSetRowMapper;
import org.sfm.reflect.meta.ClassMeta;
import org.sfm.utils.Enumarable;
import org.sfm.utils.UnaryFactory;

public final class DatastaxMapperBuilder<T>
extends AbstractMapperBuilder<Row, T, DatastaxColumnKey, DatastaxMapper<T>, DatastaxMapperBuilder<T>> {
    public static final MapperSourceImpl<GettableData, DatastaxColumnKey> FIELD_MAPPER_SOURCE = new MapperSourceImpl(GettableData.class, (GetterFactory)new RowGetterFactory());

    public DatastaxMapperBuilder(ClassMeta<T> classMeta, MapperConfig<DatastaxColumnKey, FieldMapperColumnDefinition<DatastaxColumnKey, Row>> mapperConfig, GetterFactory<GettableData, DatastaxColumnKey> getterFactory, MappingContextFactoryBuilder<Row, DatastaxColumnKey> parentBuilder) {
        super(classMeta, parentBuilder, mapperConfig, (MapperSource)FIELD_MAPPER_SOURCE.getterFactory(getterFactory), 0);
    }

    public DatastaxMapperBuilder<T> addMapping(String column, int index, DataType dataType, ColumnProperty ... properties) {
        return (DatastaxMapperBuilder)this.addMapping(new DatastaxColumnKey(column, index, dataType), properties);
    }

    public DatastaxMapperBuilder<T> addMapping(ColumnDefinitions metaData) throws SQLException {
        for (int i = 1; i <= metaData.size(); ++i) {
            this.addMapping(metaData.getName(i), i, metaData.getType(i), new ColumnProperty[0]);
        }
        return this;
    }

    protected DatastaxColumnKey key(String column, int index) {
        return new DatastaxColumnKey(column, index);
    }

    protected DatastaxMapper<T> newJoinJdbcMapper(Mapper<Row, T> mapper) {
        return new JoinDatastaxMapper<T>(mapper, this.mapperConfig.rowHandlerErrorHandler(), (MappingContextFactory<? super Row>)this.mappingContextFactoryBuilder.newFactory());
    }

    protected DatastaxMapper<T> newStaticJdbcMapper(Mapper<Row, T> mapper) {
        return new StaticDatastaxMapper<T>(mapper, this.mapperConfig.rowHandlerErrorHandler(), (MappingContextFactory<? super Row>)this.mappingContextFactoryBuilder.newFactory());
    }

    public static class StaticDatastaxMapper<T>
    extends StaticSetRowMapper<Row, ResultSet, T, DriverException>
    implements DatastaxMapper<T> {
        public StaticDatastaxMapper(Mapper<Row, T> mapper, RowHandlerErrorHandler errorHandler, MappingContextFactory<? super Row> mappingContextFactory) {
            super(mapper, errorHandler, mappingContextFactory, (UnaryFactory)new ResultSetEnumarableFactory());
        }
    }

    private static class ResultSetEnumarableFactory
    implements UnaryFactory<ResultSet, Enumarable<Row>> {
        private ResultSetEnumarableFactory() {
        }

        public Enumarable<Row> newInstance(ResultSet rows) {
            return new ResultSetEnumarable(rows);
        }
    }

    private static class JoinDatastaxMapper<T>
    extends JoinMapperImpl<Row, ResultSet, T, DriverException>
    implements DatastaxMapper<T> {
        public JoinDatastaxMapper(Mapper<Row, T> mapper, RowHandlerErrorHandler errorHandler, MappingContextFactory<? super Row> mappingContextFactory) {
            super(mapper, errorHandler, mappingContextFactory, (UnaryFactory)new ResultSetEnumarableFactory());
        }
    }
}

