/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.mapper;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import org.simpleflatmapper.converter.Context;
import org.simpleflatmapper.csv.CellValueReader;
import org.simpleflatmapper.csv.CsvColumnDefinition;
import org.simpleflatmapper.csv.CsvColumnKey;
import org.simpleflatmapper.csv.CsvRow;
import org.simpleflatmapper.csv.property.CustomReaderFactoryProperty;
import org.simpleflatmapper.csv.property.CustomReaderProperty;
import org.simpleflatmapper.map.context.MappingContextFactoryBuilder;
import org.simpleflatmapper.map.getter.BooleanContextualGetter;
import org.simpleflatmapper.map.getter.ByteContextualGetter;
import org.simpleflatmapper.map.getter.CharacterContextualGetter;
import org.simpleflatmapper.map.getter.ContextualGetter;
import org.simpleflatmapper.map.getter.ContextualGetterFactory;
import org.simpleflatmapper.map.getter.DoubleContextualGetter;
import org.simpleflatmapper.map.getter.FloatContextualGetter;
import org.simpleflatmapper.map.getter.IntContextualGetter;
import org.simpleflatmapper.map.getter.LongContextualGetter;
import org.simpleflatmapper.map.getter.ShortContextualGetter;
import org.simpleflatmapper.util.TypeHelper;

public class CsvRowGetterFactory
implements ContextualGetterFactory<CsvRow, CsvColumnKey> {
    public static final CsvRowGetterFactory INSTANCE = new CsvRowGetterFactory();
    private Map<Class<?>, ContextualGetterFactory<CsvRow, CsvColumnKey>> getterFactory = new HashMap();

    public CsvRowGetterFactory() {
        this.getterFactory.put(Boolean.TYPE, new ContextualGetterFactory<CsvRow, CsvColumnKey>(){

            public <P> ContextualGetter<CsvRow, P> newGetter(Type target, CsvColumnKey key, MappingContextFactoryBuilder<?, CsvColumnKey> mappingContextFactoryBuilder, Object ... properties) {
                int index = key.getIndex();
                return new CsvBooleanGetter(index);
            }
        });
        this.getterFactory.put(Byte.TYPE, new ContextualGetterFactory<CsvRow, CsvColumnKey>(){

            public <P> ContextualGetter<CsvRow, P> newGetter(Type target, CsvColumnKey key, MappingContextFactoryBuilder<?, CsvColumnKey> mappingContextFactoryBuilder, Object ... properties) {
                int index = key.getIndex();
                return new CsvByteGetter(index);
            }
        });
        this.getterFactory.put(Character.TYPE, new ContextualGetterFactory<CsvRow, CsvColumnKey>(){

            public <P> ContextualGetter<CsvRow, P> newGetter(Type target, CsvColumnKey key, MappingContextFactoryBuilder<?, CsvColumnKey> mappingContextFactoryBuilder, Object ... properties) {
                int index = key.getIndex();
                return new CsvCharGetter(index);
            }
        });
        this.getterFactory.put(Short.TYPE, new ContextualGetterFactory<CsvRow, CsvColumnKey>(){

            public <P> ContextualGetter<CsvRow, P> newGetter(Type target, CsvColumnKey key, MappingContextFactoryBuilder<?, CsvColumnKey> mappingContextFactoryBuilder, Object ... properties) {
                int index = key.getIndex();
                return new CsvShortGetter(index);
            }
        });
        this.getterFactory.put(Integer.TYPE, new ContextualGetterFactory<CsvRow, CsvColumnKey>(){

            public <P> ContextualGetter<CsvRow, P> newGetter(Type target, CsvColumnKey key, MappingContextFactoryBuilder<?, CsvColumnKey> mappingContextFactoryBuilder, Object ... properties) {
                int index = key.getIndex();
                return new CsvIntegerGetter(index);
            }
        });
        this.getterFactory.put(Long.TYPE, new ContextualGetterFactory<CsvRow, CsvColumnKey>(){

            public <P> ContextualGetter<CsvRow, P> newGetter(Type target, CsvColumnKey key, MappingContextFactoryBuilder<?, CsvColumnKey> mappingContextFactoryBuilder, Object ... properties) {
                int index = key.getIndex();
                return new CsvLongGetter(index);
            }
        });
        this.getterFactory.put(Float.TYPE, new ContextualGetterFactory<CsvRow, CsvColumnKey>(){

            public <P> ContextualGetter<CsvRow, P> newGetter(Type target, CsvColumnKey key, MappingContextFactoryBuilder<?, CsvColumnKey> mappingContextFactoryBuilder, Object ... properties) {
                int index = key.getIndex();
                return new CsvFloatGetter(index);
            }
        });
        this.getterFactory.put(Double.TYPE, new ContextualGetterFactory<CsvRow, CsvColumnKey>(){

            public <P> ContextualGetter<CsvRow, P> newGetter(Type target, CsvColumnKey key, MappingContextFactoryBuilder<?, CsvColumnKey> mappingContextFactoryBuilder, Object ... properties) {
                int index = key.getIndex();
                return new CsvDoubleGetter(index);
            }
        });
        this.getterFactory.put(Boolean.class, new ContextualGetterFactory<CsvRow, CsvColumnKey>(){

            public <P> ContextualGetter<CsvRow, P> newGetter(Type target, CsvColumnKey key, MappingContextFactoryBuilder<?, CsvColumnKey> mappingContextFactoryBuilder, Object ... properties) {
                int index = key.getIndex();
                return new CsvBoxedBooleanGetter(index);
            }
        });
        this.getterFactory.put(Byte.class, new ContextualGetterFactory<CsvRow, CsvColumnKey>(){

            public <P> ContextualGetter<CsvRow, P> newGetter(Type target, CsvColumnKey key, MappingContextFactoryBuilder<?, CsvColumnKey> mappingContextFactoryBuilder, Object ... properties) {
                int index = key.getIndex();
                return new CsvBoxedByteGetter(index);
            }
        });
        this.getterFactory.put(Character.class, new ContextualGetterFactory<CsvRow, CsvColumnKey>(){

            public <P> ContextualGetter<CsvRow, P> newGetter(Type target, CsvColumnKey key, MappingContextFactoryBuilder<?, CsvColumnKey> mappingContextFactoryBuilder, Object ... properties) {
                int index = key.getIndex();
                return new CsvBoxedCharGetter(index);
            }
        });
        this.getterFactory.put(Short.class, new ContextualGetterFactory<CsvRow, CsvColumnKey>(){

            public <P> ContextualGetter<CsvRow, P> newGetter(Type target, CsvColumnKey key, MappingContextFactoryBuilder<?, CsvColumnKey> mappingContextFactoryBuilder, Object ... properties) {
                int index = key.getIndex();
                return new CsvBoxedShortGetter(index);
            }
        });
        this.getterFactory.put(Integer.class, new ContextualGetterFactory<CsvRow, CsvColumnKey>(){

            public <P> ContextualGetter<CsvRow, P> newGetter(Type target, CsvColumnKey key, MappingContextFactoryBuilder<?, CsvColumnKey> mappingContextFactoryBuilder, Object ... properties) {
                int index = key.getIndex();
                return new CsvBoxedIntegerGetter(index);
            }
        });
        this.getterFactory.put(Long.class, new ContextualGetterFactory<CsvRow, CsvColumnKey>(){

            public <P> ContextualGetter<CsvRow, P> newGetter(Type target, CsvColumnKey key, MappingContextFactoryBuilder<?, CsvColumnKey> mappingContextFactoryBuilder, Object ... properties) {
                int index = key.getIndex();
                return new CsvBoxedLongGetter(index);
            }
        });
        this.getterFactory.put(Float.class, new ContextualGetterFactory<CsvRow, CsvColumnKey>(){

            public <P> ContextualGetter<CsvRow, P> newGetter(Type target, CsvColumnKey key, MappingContextFactoryBuilder<?, CsvColumnKey> mappingContextFactoryBuilder, Object ... properties) {
                int index = key.getIndex();
                return new CsvBoxedFloatGetter(index);
            }
        });
        this.getterFactory.put(Double.class, new ContextualGetterFactory<CsvRow, CsvColumnKey>(){

            public <P> ContextualGetter<CsvRow, P> newGetter(Type target, CsvColumnKey key, MappingContextFactoryBuilder<?, CsvColumnKey> mappingContextFactoryBuilder, Object ... properties) {
                int index = key.getIndex();
                return new CsvBoxedDoubleGetter(index);
            }
        });
        this.getterFactory.put(String.class, new ContextualGetterFactory<CsvRow, CsvColumnKey>(){

            public <P> ContextualGetter<CsvRow, P> newGetter(Type target, CsvColumnKey key, MappingContextFactoryBuilder<?, CsvColumnKey> mappingContextFactoryBuilder, Object ... properties) {
                int index = key.getIndex();
                return new CsvStringGetter(index);
            }
        });
        this.getterFactory.put(CharSequence.class, new ContextualGetterFactory<CsvRow, CsvColumnKey>(){

            public <P> ContextualGetter<CsvRow, P> newGetter(Type target, CsvColumnKey key, MappingContextFactoryBuilder<?, CsvColumnKey> mappingContextFactoryBuilder, Object ... properties) {
                int index = key.getIndex();
                return new CsvCharSequenceGetter(index);
            }
        });
        this.getterFactory.put(BigDecimal.class, new ContextualGetterFactory<CsvRow, CsvColumnKey>(){

            public <P> ContextualGetter<CsvRow, P> newGetter(Type target, CsvColumnKey key, MappingContextFactoryBuilder<?, CsvColumnKey> mappingContextFactoryBuilder, Object ... properties) {
                int index = key.getIndex();
                return new CsvBigDecimalGetter(index);
            }
        });
        this.getterFactory.put(BigInteger.class, new ContextualGetterFactory<CsvRow, CsvColumnKey>(){

            public <P> ContextualGetter<CsvRow, P> newGetter(Type target, CsvColumnKey key, MappingContextFactoryBuilder<?, CsvColumnKey> mappingContextFactoryBuilder, Object ... properties) {
                int index = key.getIndex();
                return new CsvBigIntegerGetter(index);
            }
        });
    }

    public <P> ContextualGetter<CsvRow, P> newGetter(Type target, CsvColumnKey key, MappingContextFactoryBuilder<?, CsvColumnKey> mappingContextFactoryBuilder, Object ... properties) {
        ContextualGetterFactory<CsvRow, CsvColumnKey> getterFactory;
        CellValueReader reader;
        Class<String> clazz = TypeHelper.toClass((Type)target);
        CustomReaderProperty customReaderProperty = null;
        CustomReaderFactoryProperty customReaderFactoryProperty = null;
        for (Object o : properties) {
            if (o instanceof CustomReaderProperty) {
                customReaderProperty = (CustomReaderProperty)o;
                continue;
            }
            if (!(o instanceof CustomReaderFactoryProperty)) continue;
            customReaderFactoryProperty = (CustomReaderFactoryProperty)o;
        }
        if (customReaderProperty != null) {
            return new CustomReaderGetter(key.getIndex(), customReaderProperty.getReader());
        }
        if (customReaderFactoryProperty != null && (reader = customReaderFactoryProperty.getReaderFactory().getReader(target, key.getIndex(), CsvColumnDefinition.of(properties), null)) != null) {
            return new CustomReaderGetter(key.getIndex(), reader);
        }
        if (clazz.equals(Object.class)) {
            clazz = String.class;
        }
        if ((getterFactory = this.getterFactory.get(clazz)) != null) {
            return getterFactory.newGetter(target, (Object)key, mappingContextFactoryBuilder, properties);
        }
        return null;
    }

    private class CustomReaderGetter<P>
    implements ContextualGetter<CsvRow, P> {
        private final CellValueReader<?> reader;
        private final int index;

        public CustomReaderGetter(int index, CellValueReader<?> reader) {
            this.index = index;
            this.reader = reader;
        }

        public P get(CsvRow target, Context context) throws Exception {
            return (P)target.read(this.reader, this.index);
        }
    }

    private static class CsvBoxedBooleanGetter
    implements ContextualGetter<CsvRow, Boolean> {
        private final int index;

        public CsvBoxedBooleanGetter(int index) {
            this.index = index;
        }

        public Boolean get(CsvRow target, Context context) {
            return target.getBoxedBoolean(this.index);
        }
    }

    private static class CsvBoxedDoubleGetter
    implements ContextualGetter<CsvRow, Double> {
        private final int index;

        public CsvBoxedDoubleGetter(int index) {
            this.index = index;
        }

        public Double get(CsvRow target, Context context) {
            return target.getBoxedDouble(this.index);
        }
    }

    private static class CsvBoxedFloatGetter
    implements ContextualGetter<CsvRow, Float> {
        private final int index;

        public CsvBoxedFloatGetter(int index) {
            this.index = index;
        }

        public Float get(CsvRow target, Context context) {
            return target.getBoxedFloat(this.index);
        }
    }

    private static class CsvBoxedLongGetter
    implements ContextualGetter<CsvRow, Long> {
        private final int index;

        public CsvBoxedLongGetter(int index) {
            this.index = index;
        }

        public Long get(CsvRow target, Context context) {
            return target.getBoxedLong(this.index);
        }
    }

    private static class CsvBoxedIntegerGetter
    implements ContextualGetter<CsvRow, Integer> {
        private final int index;

        public CsvBoxedIntegerGetter(int index) {
            this.index = index;
        }

        public Integer get(CsvRow target, Context context) {
            return target.getBoxedInt(this.index);
        }
    }

    private static class CsvBoxedShortGetter
    implements ContextualGetter<CsvRow, Short> {
        private final int index;

        public CsvBoxedShortGetter(int index) {
            this.index = index;
        }

        public Short get(CsvRow target, Context context) {
            return target.getBoxedShort(this.index);
        }
    }

    private static class CsvBoxedCharGetter
    implements ContextualGetter<CsvRow, Character> {
        private final int index;

        public CsvBoxedCharGetter(int index) {
            this.index = index;
        }

        public Character get(CsvRow target, Context context) {
            return target.getBoxedChar(this.index);
        }
    }

    private static class CsvBoxedByteGetter
    implements ContextualGetter<CsvRow, Byte> {
        private final int index;

        public CsvBoxedByteGetter(int index) {
            this.index = index;
        }

        public Byte get(CsvRow target, Context context) {
            return target.getBoxedByte(this.index);
        }
    }

    private static class CsvBooleanGetter
    implements ContextualGetter<CsvRow, Boolean>,
    BooleanContextualGetter<CsvRow> {
        private final int index;

        public CsvBooleanGetter(int index) {
            this.index = index;
        }

        public Boolean get(CsvRow target, Context context) {
            return target.getBoolean(this.index);
        }

        public boolean getBoolean(CsvRow target, Context context) {
            return target.getBoolean(this.index);
        }
    }

    private static class CsvDoubleGetter
    implements ContextualGetter<CsvRow, Double>,
    DoubleContextualGetter<CsvRow> {
        private final int index;

        public CsvDoubleGetter(int index) {
            this.index = index;
        }

        public Double get(CsvRow target, Context context) {
            return target.getDouble(this.index);
        }

        public double getDouble(CsvRow target, Context context) {
            return target.getDouble(this.index);
        }
    }

    private static class CsvFloatGetter
    implements ContextualGetter<CsvRow, Float>,
    FloatContextualGetter<CsvRow> {
        private final int index;

        public CsvFloatGetter(int index) {
            this.index = index;
        }

        public Float get(CsvRow target, Context context) {
            return Float.valueOf(target.getFloat(this.index));
        }

        public float getFloat(CsvRow target, Context context) {
            return target.getFloat(this.index);
        }
    }

    private static class CsvLongGetter
    implements ContextualGetter<CsvRow, Long>,
    LongContextualGetter<CsvRow> {
        private final int index;

        public CsvLongGetter(int index) {
            this.index = index;
        }

        public Long get(CsvRow target, Context context) {
            return target.getLong(this.index);
        }

        public long getLong(CsvRow target, Context context) {
            return target.getLong(this.index);
        }
    }

    private static class CsvIntegerGetter
    implements ContextualGetter<CsvRow, Integer>,
    IntContextualGetter<CsvRow> {
        private final int index;

        public CsvIntegerGetter(int index) {
            this.index = index;
        }

        public Integer get(CsvRow target, Context context) {
            return target.getInt(this.index);
        }

        public int getInt(CsvRow target, Context context) {
            return target.getInt(this.index);
        }
    }

    private static class CsvShortGetter
    implements ContextualGetter<CsvRow, Short>,
    ShortContextualGetter<CsvRow> {
        private final int index;

        public CsvShortGetter(int index) {
            this.index = index;
        }

        public Short get(CsvRow target, Context context) {
            return target.getShort(this.index);
        }

        public short getShort(CsvRow target, Context context) {
            return target.getShort(this.index);
        }
    }

    private static class CsvCharGetter
    implements ContextualGetter<CsvRow, Character>,
    CharacterContextualGetter<CsvRow> {
        private final int index;

        public CsvCharGetter(int index) {
            this.index = index;
        }

        public Character get(CsvRow target, Context context) {
            return Character.valueOf(target.getChar(this.index));
        }

        public char getCharacter(CsvRow target, Context context) {
            return target.getChar(this.index);
        }
    }

    private static class CsvByteGetter
    implements ContextualGetter<CsvRow, Byte>,
    ByteContextualGetter<CsvRow> {
        private final int index;

        public CsvByteGetter(int index) {
            this.index = index;
        }

        public Byte get(CsvRow target, Context context) {
            return target.getByte(this.index);
        }

        public byte getByte(CsvRow target, Context context) {
            return target.getByte(this.index);
        }
    }

    private static class CsvStringGetter
    implements ContextualGetter<CsvRow, String> {
        private final int index;

        public CsvStringGetter(int index) {
            this.index = index;
        }

        public String get(CsvRow target, Context context) {
            return target.getString(this.index);
        }
    }

    private static class CsvBigDecimalGetter
    implements ContextualGetter<CsvRow, BigDecimal> {
        private final int index;

        public CsvBigDecimalGetter(int index) {
            this.index = index;
        }

        public BigDecimal get(CsvRow target, Context context) {
            return target.getBigDecimal(this.index);
        }
    }

    private static class CsvBigIntegerGetter
    implements ContextualGetter<CsvRow, BigInteger> {
        private final int index;

        public CsvBigIntegerGetter(int index) {
            this.index = index;
        }

        public BigInteger get(CsvRow target, Context context) {
            return target.getBigInteger(this.index);
        }
    }

    private static class CsvCharSequenceGetter
    implements ContextualGetter<CsvRow, CharSequence> {
        private final int index;

        public CsvCharSequenceGetter(int index) {
            this.index = index;
        }

        public CharSequence get(CsvRow target, Context context) {
            return target.getCharSequence(this.index);
        }
    }
}

