/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.impl;

import java.util.Arrays;
import org.simpleflatmapper.lightningcsv.parser.CellConsumer;
import org.simpleflatmapper.util.Consumer;

public class CellConsumerFixLengthToCheckConsumer
implements CellConsumer {
    private final String[] values;
    private int currentIndex;
    private final Consumer<String[]> consumer;

    public CellConsumerFixLengthToCheckConsumer(int l, Consumer<String[]> consumer) {
        this.values = new String[l];
        this.consumer = consumer;
    }

    public void newCell(char[] chars, int offset, int length) {
        if (this.currentIndex < this.values.length) {
            this.values[this.currentIndex++] = new String(chars, offset, length);
        }
    }

    public boolean endOfRow() {
        try {
            this.consumer.accept((Object)Arrays.copyOf(this.values, this.values.length));
        }
        finally {
            Arrays.fill(this.values, null);
            this.currentIndex = 0;
        }
        return true;
    }

    public void end() {
        if (this.currentIndex > 0) {
            this.endOfRow();
        }
    }
}

