/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.simpleflatmapper.csv.CsvColumnDefinition;
import org.simpleflatmapper.csv.CsvColumnKey;
import org.simpleflatmapper.csv.CsvMapper;
import org.simpleflatmapper.csv.CsvMapperBuilder;
import org.simpleflatmapper.csv.impl.CsvColumnDefinitionProviderImpl;
import org.simpleflatmapper.csv.impl.DynamicCsvMapper;
import org.simpleflatmapper.lightningcsv.CloseableCsvReader;
import org.simpleflatmapper.lightningcsv.CsvParser;
import org.simpleflatmapper.lightningcsv.CsvReader;
import org.simpleflatmapper.lightningcsv.parser.CellConsumer;
import org.simpleflatmapper.lightningcsv.parser.CellPreProcessor;
import org.simpleflatmapper.lightningcsv.parser.CharBuffer;
import org.simpleflatmapper.lightningcsv.parser.CharConsumerFactory;
import org.simpleflatmapper.lightningcsv.parser.StringArrayCellConsumer;
import org.simpleflatmapper.lightningcsv.parser.TextFormat;
import org.simpleflatmapper.lightningcsv.parser.YamlCellPreProcessor;
import org.simpleflatmapper.map.mapper.ColumnDefinitionProvider;
import org.simpleflatmapper.map.property.KeyProperty;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.tuple.Tuple2;
import org.simpleflatmapper.tuple.Tuple3;
import org.simpleflatmapper.tuple.Tuple4;
import org.simpleflatmapper.tuple.Tuple5;
import org.simpleflatmapper.tuple.Tuple6;
import org.simpleflatmapper.tuple.Tuple7;
import org.simpleflatmapper.tuple.Tuple8;
import org.simpleflatmapper.tuple.Tuples;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.CloseableIterator;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.TypeReference;

public final class CsvParser {
    public static final int DEFAULT_MAX_BUFFER_SIZE_8M = 0x800000;
    public static final int DEFAULT_BUFFER_SIZE_4K = 4096;
    public static final Charset DEFAULT_CHARSET = Charset.defaultCharset();
    private static final CharConsumerFactory CHAR_CONSUMER_FACTORY = CharConsumerFactory.newInstance();

    public static DSL separator(char c) {
        return (DSL)CsvParser.dsl().separator(c);
    }

    public static DSL bufferSize(int size) {
        return (DSL)CsvParser.dsl().bufferSize(size);
    }

    public static DSL maxBufferSize(int size) {
        return (DSL)CsvParser.dsl().maxBufferSize(size);
    }

    public static DSL quote(char c) {
        return (DSL)CsvParser.dsl().quote(c);
    }

    public static DSL skip(int skip) {
        return (DSL)CsvParser.dsl().skip(skip);
    }

    public static DSL dsl() {
        return new DSL();
    }

    public static DSL limit(int limit) {
        return (DSL)CsvParser.dsl().limit(limit);
    }

    public static <T> MapToDSL<T> mapTo(Type type) {
        return CsvParser.dsl().mapTo(type);
    }

    public static <T> MapToDSL<T> mapTo(Class<T> type) {
        return CsvParser.dsl().mapTo(type);
    }

    public static <T> MapToDSL<T> mapTo(TypeReference<T> type) {
        return CsvParser.dsl().mapTo(type);
    }

    public static <T1, T2> MapToDSL<Tuple2<T1, T2>> mapTo(Class<T1> class1, Class<T2> class2) {
        return CsvParser.dsl().mapTo(class1, class2);
    }

    public static <T1, T2, T3> MapToDSL<Tuple3<T1, T2, T3>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3) {
        return CsvParser.dsl().mapTo(class1, class2, class3);
    }

    public static <T1, T2, T3, T4> MapToDSL<Tuple4<T1, T2, T3, T4>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4) {
        return CsvParser.dsl().mapTo(class1, class2, class3, class4);
    }

    public static <T1, T2, T3, T4, T5> MapToDSL<Tuple5<T1, T2, T3, T4, T5>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5) {
        return CsvParser.dsl().mapTo(class1, class2, class3, class4, class5);
    }

    public static <T1, T2, T3, T4, T5, T6> MapToDSL<Tuple6<T1, T2, T3, T4, T5, T6>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5, Class<T6> class6) {
        return CsvParser.dsl().mapTo(class1, class2, class3, class4, class5, class6);
    }

    public static <T1, T2, T3, T4, T5, T6, T7> MapToDSL<Tuple7<T1, T2, T3, T4, T5, T6, T7>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5, Class<T6> class6, Class<T7> class7) {
        return CsvParser.dsl().mapTo(class1, class2, class3, class4, class5, class6, class7);
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8> MapToDSL<Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5, Class<T6> class6, Class<T7> class7, Class<T8> class8) {
        return CsvParser.dsl().mapTo(class1, class2, class3, class4, class5, class6, class7, class8);
    }

    public static <T> MapWithDSL<T> mapWith(CsvMapper<T> mapper) {
        return CsvParser.dsl().mapWith(mapper);
    }

    public static CsvReader reader(Reader reader) throws IOException {
        return CsvParser.dsl().reader(reader);
    }

    public static CsvReader reader(CharSequence content) throws IOException {
        return CsvParser.dsl().reader(content);
    }

    public static CsvReader reader(String content) throws IOException {
        return CsvParser.dsl().reader(content);
    }

    public static CloseableCsvReader reader(File file) throws IOException {
        return CsvParser.dsl().reader(file);
    }

    public static Iterator<String[]> iterator(Reader reader) throws IOException {
        return CsvParser.dsl().iterator(reader);
    }

    public static Iterator<String[]> iterator(CharSequence content) throws IOException {
        return CsvParser.dsl().iterator(content);
    }

    public static CloseableIterator<String[]> iterator(File file) throws IOException {
        return CsvParser.dsl().iterator(file);
    }

    public static <H extends CheckedConsumer<String[]>> H forEach(Reader reader, H consumer) throws IOException {
        return (H)CsvParser.dsl().forEach(reader, consumer);
    }

    public static <H extends CheckedConsumer<String[]>> H forEach(CharSequence content, H consumer) throws IOException {
        return (H)CsvParser.dsl().forEach(content, consumer);
    }

    public static <H extends CheckedConsumer<String[]>> H forEach(File file, H consumer) throws IOException {
        return (H)CsvParser.dsl().forEach(file, consumer);
    }

    public static <CC extends CellConsumer> CC parse(Reader reader, CC cellConsumer) throws IOException {
        return (CC)CsvParser.dsl().parse(reader, cellConsumer);
    }

    public static <CC extends CellConsumer> CC parse(CharSequence content, CC cellConsumer) throws IOException {
        return (CC)CsvParser.dsl().parse(content, cellConsumer);
    }

    public static <CC extends CellConsumer> CC parse(String content, CC cellConsumer) throws IOException {
        return (CC)CsvParser.dsl().parse(content, cellConsumer);
    }

    public static <CC extends CellConsumer> CC parse(File file, CC cellConsumer) throws IOException {
        return (CC)CsvParser.dsl().parse(file, cellConsumer);
    }

    private static Reader newReader(File file) throws IOException {
        return CsvParser.newReader(file, DEFAULT_CHARSET);
    }

    private static Reader newReader(File file, Charset charset) throws IOException {
        FileChannel fileChannel = FileChannel.open(file.toPath(), new OpenOption[0]);
        try {
            return Channels.newReader(fileChannel, charset.newDecoder(), -1);
        }
        catch (Throwable e) {
            CsvParser.safeClose(fileChannel);
            throw e;
        }
    }

    private static void safeClose(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Reader newReaderJava6(File file, Charset charset) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        FileChannel fileChannel = null;
        try {
            fileChannel = randomAccessFile.getChannel();
            return Channels.newReader(fileChannel, charset.newDecoder(), -1);
        }
        catch (RuntimeException t) {
            CsvParser.safeClose(fileChannel);
            CsvParser.safeClose(randomAccessFile);
            throw t;
        }
        catch (Error t) {
            CsvParser.safeClose(fileChannel);
            CsvParser.safeClose(randomAccessFile);
            throw t;
        }
    }

    public static Stream<String[]> stream(Reader r) throws IOException {
        return CsvParser.dsl().stream(r);
    }

    @Deprecated
    public static Stream<String[]> stream(File file) throws IOException {
        return CsvParser.dsl().stream(file);
    }

    public static <R> R stream(File file, Function<Stream<String[]>, R> function) throws IOException {
        return (R)CsvParser.dsl().stream(file, function);
    }

    public static Stream<String[]> stream(String content) throws IOException {
        return CsvParser.dsl().stream(content);
    }

    private static <T> CsvMapper<T> newDefaultStaticMapper(Type mapToClass, ClassMeta<T> classMeta, CsvColumnDefinitionProviderImpl columnDefinitionProvider) {
        CsvMapperBuilder<T> builder = new CsvMapperBuilder<T>(mapToClass, classMeta, (ColumnDefinitionProvider<CsvColumnDefinition, CsvColumnKey>)columnDefinitionProvider);
        builder.addDefaultHeaders();
        return builder.mapper();
    }

    private static <T> CsvMapper<T> newStaticMapper(Type mapToClass, ClassMeta<T> classMeta, List<Tuple2<String, CsvColumnDefinition>> columns, CsvColumnDefinitionProviderImpl columnDefinitionProvider) {
        CsvMapperBuilder<T> builder = new CsvMapperBuilder<T>(mapToClass, classMeta, (ColumnDefinitionProvider<CsvColumnDefinition, CsvColumnKey>)columnDefinitionProvider);
        for (Tuple2<String, CsvColumnDefinition> col : columns) {
            builder.addMapping((String)col.first(), (CsvColumnDefinition)((Object)col.second()));
        }
        return builder.mapper();
    }

    public static class MapWithDSL<T> {
        private final CsvParser.AbstractDSL<?> dsl;
        private final CsvMapper<T> mapper;

        public MapWithDSL(CsvParser.AbstractDSL dsl, CsvMapper<T> mapper) {
            this.dsl = dsl;
            this.mapper = mapper;
        }

        protected final CsvParser.AbstractDSL getDsl() {
            return this.dsl;
        }

        public final Iterator<T> iterator(Reader reader) throws IOException {
            return this.mapper.iterator(this.dsl.reader(reader));
        }

        public final Iterator<T> iterator(CharSequence content) throws IOException {
            return this.mapper.iterator(this.dsl.reader(content));
        }

        public final Iterator<T> iterator(String content) throws IOException {
            return this.mapper.iterator(this.dsl.reader(content));
        }

        public final CloseableIterator<T> iterator(File file) throws IOException {
            CsvParser.OnReaderFactory factory = new CsvParser.OnReaderFactory<CloseableIterator<T>, CsvParser.AbstractDSL<?>>(){

                public CloseableIterator<T> apply(Reader reader, CsvParser.AbstractDSL<?> dsl) throws IOException {
                    return new CloseableIterator(this.iterator(reader), (Closeable)reader);
                }
            };
            return (CloseableIterator)org.simpleflatmapper.lightningcsv.CsvParser.onReader((File)file, this.dsl, (CsvParser.OnReaderFactory)factory);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <H extends CheckedConsumer<T>> H forEach(File file, H consumer) throws IOException {
            Reader reader = CsvParser.newReader(file);
            H h = this.forEach(reader, consumer);
            return h;
            finally {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }

        public final <H extends CheckedConsumer<T>> H forEach(Reader reader, H consumer) throws IOException {
            return this.forEach(consumer, this.dsl.reader(reader));
        }

        public final <H extends CheckedConsumer<T>> H forEach(CharSequence content, H consumer) throws IOException {
            return this.forEach(consumer, this.dsl.reader(content));
        }

        public final <H extends CheckedConsumer<T>> H forEach(String content, H consumer) throws IOException {
            return this.forEach(consumer, this.dsl.reader(content));
        }

        private <H extends CheckedConsumer<T>> H forEach(H consumer, CsvReader csvReader) throws IOException {
            if (this.dsl.limit() == -1) {
                this.mapper.forEach(csvReader, consumer);
            } else {
                this.mapper.forEach(csvReader, consumer, this.dsl.limit());
            }
            return consumer;
        }

        public final Stream<T> stream(Reader reader) throws IOException {
            return this.mapper.stream(this.dsl.reader(reader));
        }

        public final Stream<T> stream(CharSequence content) throws IOException {
            return this.mapper.stream(this.dsl.reader(content));
        }

        public final Stream<T> stream(String content) throws IOException {
            return this.mapper.stream(this.dsl.reader(content));
        }

        @Deprecated
        public final Stream<T> stream(File file) throws IOException {
            CsvParser.OnReaderFactory factory = new CsvParser.OnReaderFactory<Stream<T>, CsvParser.AbstractDSL<?>>(){

                public Stream<T> apply(Reader reader, CsvParser.AbstractDSL<?> dsl) throws IOException {
                    return (Stream)this.stream(reader).onClose(() -> {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    });
                }
            };
            return (Stream)org.simpleflatmapper.lightningcsv.CsvParser.onReader((File)file, this.dsl, (CsvParser.OnReaderFactory)factory);
        }

        public final <R> R stream(File file, Function<Stream<T>, R> function) throws IOException {
            Reader reader = CsvParser.newReader(file);
            try {
                return function.apply(this.stream(reader));
            }
            catch (IOException ioe) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw ioe;
            }
        }
    }

    public static final class StaticMapToDSL<T>
    extends MapWithDSL<T> {
        private final ClassMeta<T> classMeta;
        private final Type mapToClass;
        private final CsvColumnDefinitionProviderImpl columnDefinitionProvider;
        private final List<Tuple2<String, CsvColumnDefinition>> columns;

        private StaticMapToDSL(CsvParser.AbstractDSL dsl, ClassMeta<T> classMeta, Type mapToClass, CsvMapper<T> mapper, CsvColumnDefinitionProviderImpl columnDefinitionProvider) {
            super(dsl, mapper);
            this.classMeta = classMeta;
            this.mapToClass = mapToClass;
            this.columns = new ArrayList<Tuple2<String, CsvColumnDefinition>>();
            this.columnDefinitionProvider = columnDefinitionProvider;
        }

        private StaticMapToDSL(CsvParser.AbstractDSL dsl, ClassMeta<T> classMeta, Type mapToClass, List<Tuple2<String, CsvColumnDefinition>> columns, CsvColumnDefinitionProviderImpl columnDefinitionProvider) {
            super(dsl, CsvParser.newStaticMapper(mapToClass, classMeta, columns, columnDefinitionProvider));
            this.classMeta = classMeta;
            this.mapToClass = mapToClass;
            this.columns = columns;
            this.columnDefinitionProvider = columnDefinitionProvider;
        }

        public StaticMapToDSL<T> addMapping(String column) {
            return this.addMapping(column, CsvColumnDefinition.identity());
        }

        public StaticMapToDSL<T> addMapping(String column, CsvColumnDefinition columnDefinition) {
            ArrayList<Tuple2<String, CsvColumnDefinition>> newColumns = new ArrayList<Tuple2<String, CsvColumnDefinition>>(this.columns);
            newColumns.add((Tuple2<String, CsvColumnDefinition>)new Tuple2((Object)column, (Object)columnDefinition));
            return new StaticMapToDSL<T>(this.getDsl(), this.classMeta, this.mapToClass, newColumns, this.columnDefinitionProvider);
        }

        public StaticMapToDSL<T> addKey(String key) {
            return this.addMapping(key, CsvColumnDefinition.key());
        }
    }

    public static final class MapToDSL<T>
    extends MapWithDSL<T> {
        private final ClassMeta<T> classMeta;
        private final Type mapToClass;
        private final CsvColumnDefinitionProviderImpl columnDefinitionProvider;

        public MapToDSL(CsvParser.AbstractDSL dsl, Type mapToClass) {
            this(dsl, ReflectionService.newInstance().getClassMeta(mapToClass), mapToClass, new CsvColumnDefinitionProviderImpl());
        }

        private MapToDSL(CsvParser.AbstractDSL dsl, ClassMeta<T> classMeta, Type mapToClass, CsvColumnDefinitionProviderImpl columnDefinitionProvider) {
            super(dsl, new DynamicCsvMapper<T>(mapToClass, classMeta, (ColumnDefinitionProvider<CsvColumnDefinition, CsvColumnKey>)columnDefinitionProvider));
            this.mapToClass = mapToClass;
            this.classMeta = classMeta;
            this.columnDefinitionProvider = columnDefinitionProvider;
        }

        public StaticMapToDSL<T> headers(String ... headers) {
            return this.headers(headers, this.getDsl());
        }

        public StaticMapToDSL<T> overrideHeaders(String ... headers) {
            return this.headers(headers, this.getDsl().skip(1));
        }

        private StaticMapToDSL<T> headers(String[] headers, CsvParser.AbstractDSL csvDsl) {
            return new StaticMapToDSL(csvDsl, this.classMeta, this.mapToClass, this.getColumnDefinitions(headers), this.columnDefinitionProvider);
        }

        public StaticMapToDSL<T> defaultHeaders() {
            return this.defaultHeaders(this.getDsl());
        }

        public StaticMapToDSL<T> overrideWithDefaultHeaders() {
            return this.defaultHeaders(this.getDsl().skip(1));
        }

        private StaticMapToDSL<T> defaultHeaders(CsvParser.AbstractDSL csvDsl) {
            return new StaticMapToDSL(csvDsl, this.classMeta, this.mapToClass, CsvParser.newDefaultStaticMapper(this.mapToClass, this.classMeta, this.columnDefinitionProvider), this.columnDefinitionProvider);
        }

        private List<Tuple2<String, CsvColumnDefinition>> getColumnDefinitions(String[] headers) {
            ArrayList<Tuple2<String, CsvColumnDefinition>> columns = new ArrayList<Tuple2<String, CsvColumnDefinition>>();
            for (String header : headers) {
                columns.add((Tuple2<String, CsvColumnDefinition>)new Tuple2((Object)header, (Object)CsvColumnDefinition.identity()));
            }
            return columns;
        }

        public MapToDSL<T> columnDefinition(String column, CsvColumnDefinition columnDefinition) {
            return new MapToDSL<T>(this.getDsl(), this.classMeta, this.mapToClass, this.newColumnDefinitionProvider(column, columnDefinition));
        }

        public MapToDSL<T> columnDefinition(Predicate<? super CsvColumnKey> predicate, CsvColumnDefinition columnDefinition) {
            return new MapToDSL<T>(this.getDsl(), this.classMeta, this.mapToClass, this.newColumnDefinitionProvider(predicate, columnDefinition));
        }

        public MapWithDSL<T> addKeys(String ... keys) {
            CsvColumnDefinitionProviderImpl newProvider = this.columnDefinitionProvider.copy();
            for (String key : keys) {
                newProvider.addColumnProperty(key, KeyProperty.DEFAULT);
            }
            return new MapToDSL<T>(this.getDsl(), this.classMeta, this.mapToClass, newProvider);
        }

        private CsvColumnDefinitionProviderImpl newColumnDefinitionProvider(String name, CsvColumnDefinition columnDefinition) {
            CsvColumnDefinitionProviderImpl newProvider = this.columnDefinitionProvider.copy();
            newProvider.addColumnDefinition(name, columnDefinition);
            return newProvider;
        }

        private CsvColumnDefinitionProviderImpl newColumnDefinitionProvider(Predicate<? super CsvColumnKey> predicate, CsvColumnDefinition columnDefinition) {
            CsvColumnDefinitionProviderImpl newProvider = this.columnDefinitionProvider.copy();
            newProvider.addColumnDefinition(predicate, columnDefinition);
            return newProvider;
        }

        public StaticMapToDSL<T> addMapping(String column) {
            return this.staticMapper().addMapping(column);
        }

        public StaticMapToDSL<T> addKey(String key) {
            return this.staticMapper().addKey(key);
        }

        public StaticMapToDSL<T> addMapping(String column, CsvColumnDefinition columnDefinition) {
            return this.staticMapper().addMapping(column, columnDefinition);
        }

        private StaticMapToDSL<T> staticMapper() {
            return this.headers(new String[0], this.getDsl().skip(1));
        }
    }

    public static final class DSLYamlComment
    extends AbstractDSL<DSLYamlComment> {
        private static final CsvParser.OnReaderFactory<CloseableCsvReader, DSLYamlComment> CREATE_CLOSEABLE_CSV_RAW_READER = new CsvParser.OnReaderFactory<CloseableCsvReader, DSLYamlComment>(){

            public CloseableCsvReader apply(Reader reader, DSLYamlComment dsl) throws IOException {
                return new CloseableCsvReader(dsl.rawReader(dsl.charBuffer(reader)), (Closeable)reader);
            }
        };

        protected DSLYamlComment(char separatorChar, char quoteChar, char escapeChar, int bufferSize, int skip, int limit, int maxBufferSize, CsvParser.AbstractDSL.StringPostProcessing stringPostProcessing, org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer> cellConsumerWrapper, boolean yamlComment, boolean parallelReader, boolean specialisedCharConsumer) {
            super(separatorChar, quoteChar, escapeChar, bufferSize, skip, limit, maxBufferSize, stringPostProcessing, cellConsumerWrapper, yamlComment, parallelReader, specialisedCharConsumer);
        }

        private CsvReader rawReader(CharBuffer charBuffer) throws IOException {
            CsvReader csvReader = new CsvReader(this.charConsumer(charBuffer), null);
            csvReader.skipRows(this.skip);
            return csvReader;
        }

        public void forEach(Reader reader, CheckedConsumer<String[]> rowConsumer, CheckedConsumer<String> commentConsumer) throws IOException {
            this._forEach(this.rawReader(this.charBuffer(reader)), rowConsumer, commentConsumer);
        }

        public void forEach(CharSequence content, CheckedConsumer<String[]> rowConsumer, CheckedConsumer<String> commentConsumer) throws IOException {
            this._forEach(this.rawReader(this.charBuffer(content)), rowConsumer, commentConsumer);
        }

        public void forEach(String content, CheckedConsumer<String[]> rowConsumer, CheckedConsumer<String> commentConsumer) throws IOException {
            this._forEach(this.rawReader(this.charBuffer(content)), rowConsumer, commentConsumer);
        }

        private void _forEach(CsvReader reader, CheckedConsumer<String[]> rowConsumer, CheckedConsumer<String> commentConsumer) throws IOException {
            reader.parseAll((CellConsumer)this.newYamlCellConsumer(rowConsumer, commentConsumer));
        }

        private YamlCellPreProcessor.YamlCellConsumer newYamlCellConsumer(CheckedConsumer<String[]> rowConsumer, CheckedConsumer<String> commentConsumer) {
            TextFormat textFormat = this.getTextFormat();
            return new YamlCellPreProcessor.YamlCellConsumer((CellConsumer)StringArrayCellConsumer.newInstance(rowConsumer), YamlCellPreProcessor.commentConsumerToCellConsumer(commentConsumer), this.superGetCellTransformer(textFormat, this.stringPostProcessing));
        }

        private CellPreProcessor superGetCellTransformer(TextFormat textFormat, CsvParser.AbstractDSL.StringPostProcessing stringPostProcessing) {
            return super.getCellTransformer(textFormat, stringPostProcessing);
        }

        protected CellPreProcessor getCellTransformer(TextFormat textFormat, CsvParser.AbstractDSL.StringPostProcessing stringPostProcessing) {
            return new YamlCellPreProcessor(stringPostProcessing == CsvParser.AbstractDSL.StringPostProcessing.TRIM_AND_UNESCAPE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forEach(File file, CheckedConsumer<String[]> rowConsumer, CheckedConsumer<String> commentConsumer) throws IOException {
            try (CloseableCsvReader csvReader = this.rawReader(file);){
                csvReader.parseAll((CellConsumer)this.newYamlCellConsumer(rowConsumer, commentConsumer));
            }
        }

        private final CloseableCsvReader rawReader(File file) throws IOException {
            return (CloseableCsvReader)org.simpleflatmapper.lightningcsv.CsvParser.onReader((File)file, (CsvParser.AbstractDSL)this, CREATE_CLOSEABLE_CSV_RAW_READER);
        }

        protected DSLYamlComment newDSL(char separatorChar, char quoteChar, char escapeChar, int bufferSize, int skip, int limit, int maxBufferSize, CsvParser.AbstractDSL.StringPostProcessing stringPostProcessing, org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer> cellConsumerWrapper, boolean yamlComment, boolean parallelReader, boolean specialisedCharConsumer) {
            return new DSLYamlComment(separatorChar, quoteChar, escapeChar, bufferSize, skip, limit, maxBufferSize, stringPostProcessing, cellConsumerWrapper, yamlComment, parallelReader, specialisedCharConsumer);
        }
    }

    public static final class DSL
    extends AbstractDSL<DSL> {
        protected DSL() {
        }

        protected DSL(char separatorChar, char quoteChar, char escapeChar, int bufferSize, int skip, int limit, int maxBufferSize, CsvParser.AbstractDSL.StringPostProcessing stringPostProcessing, org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer> cellConsumerWrapper, boolean yamlComment, boolean parallelReader, boolean specialisedCharConsumer) {
            super(separatorChar, quoteChar, escapeChar, bufferSize, skip, limit, maxBufferSize, stringPostProcessing, cellConsumerWrapper, yamlComment, parallelReader, specialisedCharConsumer);
        }

        public DSL trimSpaces() {
            return new DSL(this.separatorChar, this.quoteChar, this.escapeChar, this.bufferSize, this.skip, this.limit, this.maxBufferSize, CsvParser.AbstractDSL.StringPostProcessing.TRIM_AND_UNESCAPE, (org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer>)this.cellConsumerWrapper, this.yamlComment, this.parallelReader, this.specialisedCharConsumer);
        }

        public DSLYamlComment withYamlComments() {
            return new DSLYamlComment(this.separatorChar, this.quoteChar, this.escapeChar, this.bufferSize, this.skip, this.limit, this.maxBufferSize, this.stringPostProcessing, (org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer>)new org.simpleflatmapper.util.Function<CellConsumer, CellConsumer>(){

                public CellConsumer apply(CellConsumer cellConsumer) {
                    TextFormat textFormat = this.getTextFormat();
                    return new YamlCellPreProcessor.YamlCellConsumer(cellConsumer, null, this.getCellTransformer(textFormat, stringPostProcessing));
                }
            }, true, this.parallelReader, this.specialisedCharConsumer);
        }

        public DSLYamlComment withYamlCommentsAsCell() {
            return new DSLYamlComment(this.separatorChar, this.quoteChar, this.escapeChar, this.bufferSize, this.skip, this.limit, this.maxBufferSize, this.stringPostProcessing, (org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer>)new org.simpleflatmapper.util.Function<CellConsumer, CellConsumer>(){

                public CellConsumer apply(CellConsumer cellConsumer) {
                    TextFormat textFormat = this.getTextFormat();
                    return new YamlCellPreProcessor.YamlCellConsumer(cellConsumer, cellConsumer, this.getCellTransformer(textFormat, stringPostProcessing));
                }
            }, true, this.parallelReader, this.specialisedCharConsumer);
        }

        public DSL disableUnescaping() {
            return new DSL(this.separatorChar, this.quoteChar, this.escapeChar, this.bufferSize, this.skip, this.limit, this.maxBufferSize, CsvParser.AbstractDSL.StringPostProcessing.NONE, (org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer>)this.cellConsumerWrapper, this.yamlComment, this.parallelReader, this.specialisedCharConsumer);
        }

        protected DSL newDSL(char separatorChar, char quoteChar, char escapeChar, int bufferSize, int skip, int limit, int maxBufferSize, CsvParser.AbstractDSL.StringPostProcessing stringPostProcessing, org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer> cellConsumerWrapper, boolean yamlComment, boolean parallelReader, boolean specialisedCharConsumer) {
            return new DSL(separatorChar, quoteChar, escapeChar, bufferSize, skip, limit, maxBufferSize, stringPostProcessing, cellConsumerWrapper, yamlComment, parallelReader, specialisedCharConsumer);
        }
    }

    protected static abstract class AbstractDSL<D extends AbstractDSL<D>>
    extends CsvParser.AbstractDSL<D> {
        public AbstractDSL() {
        }

        public AbstractDSL(char separatorChar, char quoteChar, char escapeChar, int bufferSize, int skip, int limit, int maxBufferSize, CsvParser.AbstractDSL.StringPostProcessing stringPostProcessing, org.simpleflatmapper.util.Function<? super CellConsumer, ? extends CellConsumer> cellConsumerWrapper, boolean yamlComment, boolean parallelReader, boolean specialisedCharConsumer) {
            super(separatorChar, quoteChar, escapeChar, bufferSize, skip, limit, maxBufferSize, stringPostProcessing, cellConsumerWrapper, yamlComment, parallelReader, specialisedCharConsumer);
        }

        public final <T> MapToDSL<T> mapTo(Type target) {
            return new MapToDSL((CsvParser.AbstractDSL)this, target);
        }

        public final <T> MapToDSL<T> mapTo(Class<T> target) {
            return this.mapTo((Type)target);
        }

        public final <T> MapToDSL<T> mapTo(TypeReference<T> target) {
            return this.mapTo(target.getType());
        }

        public final <T1, T2> MapToDSL<Tuple2<T1, T2>> mapTo(Class<T1> class1, Class<T2> class2) {
            return new MapToDSL<Tuple2<T1, T2>>((CsvParser.AbstractDSL)this, Tuples.typeDef((Type[])new Type[]{class1, class2}));
        }

        public final <T1, T2, T3> MapToDSL<Tuple3<T1, T2, T3>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3) {
            return new MapToDSL<Tuple3<T1, T2, T3>>((CsvParser.AbstractDSL)this, Tuples.typeDef((Type[])new Type[]{class1, class2, class3}));
        }

        public final <T1, T2, T3, T4> MapToDSL<Tuple4<T1, T2, T3, T4>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4) {
            return new MapToDSL<Tuple4<T1, T2, T3, T4>>((CsvParser.AbstractDSL)this, Tuples.typeDef((Type[])new Type[]{class1, class2, class3, class4}));
        }

        public final <T1, T2, T3, T4, T5> MapToDSL<Tuple5<T1, T2, T3, T4, T5>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5) {
            return new MapToDSL<Tuple5<T1, T2, T3, T4, T5>>((CsvParser.AbstractDSL)this, Tuples.typeDef((Type[])new Type[]{class1, class2, class3, class4, class5}));
        }

        public final <T1, T2, T3, T4, T5, T6> MapToDSL<Tuple6<T1, T2, T3, T4, T5, T6>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5, Class<T6> class6) {
            return new MapToDSL<Tuple6<T1, T2, T3, T4, T5, T6>>((CsvParser.AbstractDSL)this, Tuples.typeDef((Type[])new Type[]{class1, class2, class3, class4, class5, class6}));
        }

        public final <T1, T2, T3, T4, T5, T6, T7> MapToDSL<Tuple7<T1, T2, T3, T4, T5, T6, T7>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5, Class<T6> class6, Class<T7> class7) {
            return new MapToDSL<Tuple7<T1, T2, T3, T4, T5, T6, T7>>((CsvParser.AbstractDSL)this, Tuples.typeDef((Type[])new Type[]{class1, class2, class3, class4, class5, class6, class7}));
        }

        public final <T1, T2, T3, T4, T5, T6, T7, T8> MapToDSL<Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>> mapTo(Class<T1> class1, Class<T2> class2, Class<T3> class3, Class<T4> class4, Class<T5> class5, Class<T6> class6, Class<T7> class7, Class<T8> class8) {
            return new MapToDSL<Tuple8<T1, T2, T3, T4, T5, T6, T7, T8>>((CsvParser.AbstractDSL)this, Tuples.typeDef((Type[])new Type[]{class1, class2, class3, class4, class5, class6, class7, class8}));
        }

        public final <T> MapWithDSL<T> mapWith(CsvMapper<T> mapper) {
            return new MapWithDSL<T>(this, mapper);
        }
    }
}

