/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.impl.asm;

import java.lang.reflect.Type;
import java.util.Arrays;
import org.simpleflatmapper.csv.CsvColumnKey;
import org.simpleflatmapper.csv.mapper.CellSetter;
import org.simpleflatmapper.csv.mapper.CsvMapperCellHandler;
import org.simpleflatmapper.csv.mapper.DelayedCellSetterFactory;
import org.simpleflatmapper.map.FieldMapperErrorHandler;
import org.simpleflatmapper.reflect.Instantiator;

public class CsvMapperKey {
    private final CsvColumnKey[] keys;
    private final Class<?>[] setters;
    private final Class<?>[] delayedSetters;
    private final Class<?> instantiator;
    private final Type target;
    private final Class<?> fieldErrorHandler;
    private final int maxMethodSize;

    public <T> CsvMapperKey(CsvColumnKey[] keys, CellSetter<T>[] setters, DelayedCellSetterFactory<T, ?>[] delayedCellSetterFactories, Instantiator<CsvMapperCellHandler<T>, T> instantiator, Type target, FieldMapperErrorHandler<? super CsvColumnKey> fieldErrorHandler, int maxMethodSize) {
        this.keys = keys;
        this.setters = this.getClassArray(setters);
        this.delayedSetters = this.getClassArray(delayedCellSetterFactories);
        this.instantiator = this.getClass(instantiator);
        this.target = target;
        this.fieldErrorHandler = this.getClass(fieldErrorHandler);
        this.maxMethodSize = maxMethodSize;
    }

    private Class<?>[] getClassArray(Object[] objects) {
        Class[] classes = new Class[objects != null ? objects.length : 0];
        if (objects != null) {
            int i = 0;
            for (Object o : objects) {
                classes[i] = this.getClass(o);
                ++i;
            }
        }
        return classes;
    }

    private Class<?> getClass(Object o) {
        if (o != null) {
            return o.getClass();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CsvMapperKey that = (CsvMapperKey)o;
        if (this.maxMethodSize != that.maxMethodSize) {
            return false;
        }
        if (!Arrays.equals((Object[])this.keys, (Object[])that.keys)) {
            return false;
        }
        if (!Arrays.equals(this.setters, that.setters)) {
            return false;
        }
        if (!Arrays.equals(this.delayedSetters, that.delayedSetters)) {
            return false;
        }
        if (this.instantiator != null ? !this.instantiator.equals(that.instantiator) : that.instantiator != null) {
            return false;
        }
        if (this.target != null ? !this.target.equals(that.target) : that.target != null) {
            return false;
        }
        return !(this.fieldErrorHandler == null ? that.fieldErrorHandler != null : !this.fieldErrorHandler.equals(that.fieldErrorHandler));
    }

    public int hashCode() {
        int result = this.keys != null ? Arrays.hashCode((Object[])this.keys) : 0;
        result = 31 * result + (this.setters != null ? Arrays.hashCode(this.setters) : 0);
        result = 31 * result + (this.delayedSetters != null ? Arrays.hashCode(this.delayedSetters) : 0);
        result = 31 * result + (this.instantiator != null ? this.instantiator.hashCode() : 0);
        result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
        result = 31 * result + (this.fieldErrorHandler != null ? this.fieldErrorHandler.hashCode() : 0);
        result = 31 * result + this.maxMethodSize;
        return result;
    }
}

