/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.impl.primitive;

import org.simpleflatmapper.csv.ParsingContext;
import org.simpleflatmapper.csv.impl.cellreader.FloatCellValueReader;
import org.simpleflatmapper.csv.mapper.DelayedCellSetter;
import org.simpleflatmapper.reflect.primitive.FloatSetter;

public class FloatDelayedCellSetter<T>
implements DelayedCellSetter<T, Float> {
    private final FloatSetter<? super T> setter;
    private final FloatCellValueReader reader;
    private float value;
    private boolean isNull;

    public FloatDelayedCellSetter(FloatSetter<? super T> setter, FloatCellValueReader reader) {
        this.setter = setter;
        this.reader = reader;
    }

    @Override
    public Float consumeValue() {
        return this.isNull ? null : Float.valueOf(this.consumeFloat());
    }

    @Override
    public Float peekValue() {
        return this.isNull ? null : Float.valueOf(this.value);
    }

    public float consumeFloat() {
        float v = this.value;
        this.value = 0.0f;
        this.isNull = true;
        return v;
    }

    @Override
    public void set(T t) throws Exception {
        this.setter.setFloat(t, this.consumeValue().floatValue());
    }

    @Override
    public boolean isSettable() {
        return this.setter != null;
    }

    @Override
    public void set(char[] chars, int offset, int length, ParsingContext parsingContext) throws Exception {
        this.isNull = length == 0;
        this.value = this.reader.readFloat(chars, offset, length, parsingContext);
    }

    public String toString() {
        return "FloatDelayedCellSetter{setter=" + this.setter + ", reader=" + this.reader + '}';
    }
}

