/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.mapper;

import org.simpleflatmapper.csv.mapper.BreakDetector;
import org.simpleflatmapper.csv.mapper.CsvMapperCellHandler;
import org.simpleflatmapper.csv.parser.CellConsumer;
import org.simpleflatmapper.map.ConsumerErrorHandler;
import org.simpleflatmapper.util.CheckedConsumer;

public final class CsvMapperCellConsumer<T>
implements CellConsumer {
    private final CsvMapperCellHandler<T> mapperSetters;
    protected final ConsumerErrorHandler consumerErrorHandlers;
    protected final BreakDetector breakDetector;
    protected final CheckedConsumer<? super T> handler;
    protected final CsvMapperCellConsumer[] children;
    private final int maxMandatoryCellIndex;
    protected int cellIndex = 0;
    private boolean calledHandler = false;
    private boolean producedObject = false;
    private CsvMapperCellConsumer<?> parent;

    public CsvMapperCellConsumer(CsvMapperCellHandler<T> csvMapperCellHandler, ConsumerErrorHandler consumerErrorHandlers, CheckedConsumer<? super T> handler, BreakDetector breakDetector, CsvMapperCellConsumer<?>[] children, int maxMandatoryCellIndex) {
        this.mapperSetters = csvMapperCellHandler;
        this.consumerErrorHandlers = consumerErrorHandlers;
        this.handler = handler;
        this.breakDetector = breakDetector;
        this.children = children;
        this.mapperSetters.mapperCellConsumer = this;
        for (CsvMapperCellConsumer<?> child : children) {
            super.setParent(this);
        }
        this.maxMandatoryCellIndex = maxMandatoryCellIndex;
    }

    private void setParent(CsvMapperCellConsumer<?> parent) {
        this.parent = parent;
    }

    @Override
    public final boolean endOfRow() {
        this.composeInstance();
        this.resetConsumer();
        boolean calledHandler = this.calledHandler;
        this.calledHandler = false;
        return calledHandler;
    }

    public T getOrCreateCurrentInstance() {
        T t = this.getCurrentInstance();
        if (t == null) {
            this.composeInstance();
        }
        t = this.getCurrentInstance();
        return t;
    }

    public final T getCurrentInstance() {
        return this.mapperSetters.getCurrentInstance();
    }

    protected final boolean hasData() {
        return this.cellIndex > this.maxMandatoryCellIndex;
    }

    protected final void callHandler() {
        this.calledHandler = true;
        if (this.handler == null) {
            return;
        }
        try {
            this.handler.accept(this.getCurrentInstance());
        }
        catch (Exception e) {
            this.consumerErrorHandlers.handlerError((Throwable)e, this.getCurrentInstance());
        }
    }

    @Override
    public final void end() {
        this.endOfRow();
        this.afterEnd();
    }

    @Override
    public final void newCell(char[] chars, int offset, int length) {
        int index = this.cellIndex;
        this.newCell(chars, offset, length, index);
        this.afterNewCell(index);
    }

    public final void newCell(char[] chars, int offset, int length, int cellIndex) {
        if (this.mapperSetters.isDelayedSetter(cellIndex)) {
            this.mapperSetters.delayedCellValue(chars, offset, length, cellIndex);
        } else if (this.isNotNull()) {
            this.mapperSetters.cellValue(chars, offset, length, cellIndex);
        }
        this.cellIndex = cellIndex + 1;
    }

    private boolean isNotNull() {
        if (this.breakDetector == null) {
            this.mapperSetters.createInstanceIfNull();
            return true;
        }
        return this.breakDetector.isNotNull();
    }

    public final BreakDetector getBreakDetector() {
        return this.breakDetector;
    }

    private void resetConsumer() {
        for (CsvMapperCellConsumer child : this.children) {
            child.resetConsumer();
        }
        if (this.breakDetector != null) {
            this.breakDetector.reset();
        } else {
            this.mapperSetters.resetCurrentInstance();
        }
        this.cellIndex = 0;
    }

    private void composeInstance() {
        if (this.hasData() && (this.breakDetector == null || this.breakDetector.isNotNull())) {
            for (CsvMapperCellConsumer child : this.children) {
                child.composeInstance();
            }
            this.mapperSetters.createInstanceIfNull();
            this.mapperSetters.applyDelayedSetters();
            if (this.breakDetector == null) {
                this.callHandler();
            }
        }
    }

    protected void afterEnd() {
        if (this.breakDetector != null && this.mapperSetters.hasInstance()) {
            this.callHandler();
        }
    }

    protected void afterNewCell(int index) {
        if (this.breakDetector == null) {
            return;
        }
        this.updateBreakStatus(index);
    }

    private void updateBreakStatus(int cellIndex) {
        if ((this.breakDetector == null || this.breakDetector.updateStatus(this.mapperSetters, cellIndex)) && (this.breakDetector == null || this.breakDetector.broken())) {
            if (this.mapperSetters.hasInstance()) {
                this.callHandler();
                this.mapperSetters.resetCurrentInstance();
            }
            this.updateChildrenStatus(cellIndex);
            if (this.breakDetector == null || this.breakDetector.isNotNull()) {
                this.mapperSetters.createInstance();
            }
            return;
        }
        this.updateChildrenStatus(cellIndex);
    }

    private void updateChildrenStatus(int cellIndex) {
        for (CsvMapperCellConsumer consumer : this.children) {
            consumer.updateBreakStatus(cellIndex);
        }
    }

    public Object getRootCurrentInstance() {
        if (this.parent == null) {
            return this.mapperSetters.currentInstance;
        }
        return this.parent.getRootCurrentInstance();
    }
}

